/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.action;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.TestsPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractTestAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    private ArrayList failures = new ArrayList(4);

    public void dispose() {
    }

    public abstract Test getTestSuite();

    public void init(IWorkbenchWindow arg0) {
    }

    protected Plugin getTestPlugin() {
        return TestsPlugin.getDefault();
    }

    public void run(IAction arg0) {
        Object e;
        this.failures.clear();
        TestSuite suite = new TestSuite();
        Test test = this.getTestSuite();
        if (test == null) {
            return;
        }
        suite.addTest(test);
        TestResult result = new TestResult();
        suite.run(result);
        System.out.println("Test results: " + result.errorCount() + " errors, " + result.failureCount() + " failures.");
        Enumeration en = result.errors();
        while (en.hasMoreElements()) {
            e = en.nextElement();
            this.failures.add(e);
            System.out.println(e);
        }
        en = result.failures();
        while (en.hasMoreElements()) {
            e = en.nextElement();
            this.failures.add(e);
            System.out.println(e);
        }
        this.logTestResults();
    }

    public void logTestResults() {
        Plugin plugin = this.getTestPlugin();
        Log.info((Plugin)plugin, (int)1, (String)"Test Results:");
        List results = this.getFailures();
        int i = 0;
        while (i < results.size()) {
            Object entry = results.get(i);
            try {
                Log.error((Plugin)plugin, (int)4, (String)entry.toString(), (Throwable)((TestFailure)entry).thrownException());
            }
            catch (Exception exception) {
                Log.error((Plugin)plugin, (int)4, (String)entry.toString());
            }
            ++i;
        }
    }

    public List getFailures() {
        return this.failures;
    }

    public void selectionChanged(IAction action, ISelection arg1) {
        action.setEnabled(true);
    }
}

