/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.tools;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.gef.EditDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeConnectionTool;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.PresentationTestFixture;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.widgets.Event;

public class ConnectionToolTests
extends AbstractTestBase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.diagram.ui.tools.ConnectionToolTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite s = new TestSuite((Class)clazz);
        return s;
    }

    public ConnectionToolTests(String name) {
        super(name);
    }

    protected void setTestFixture() {
        this.testFixture = new PresentationTestFixture();
    }

    protected PresentationTestFixture getFixture() {
        return (PresentationTestFixture)this.testFixture;
    }

    public void test_doubleClickUnspecifiedTypeConnectionTool() throws Exception {
        this.getFixture().openDiagram();
        ArrayList<NoteEditPart> eps = new ArrayList<NoteEditPart>(2);
        eps.add(this.getFixture().createNote());
        eps.add(this.getFixture().createNote());
        ConnectionToolTests.assertEquals((String)"Notes not created properly.", (int)2, (int)this.getDiagramEditPart().getPrimaryEditParts().size());
        ConnectionToolTests.assertEquals((String)"There shouldn't be any connections yet.", (int)0, (int)this.getDiagramEditPart().getConnections().size());
        this.getDiagramEditPart().getViewer().setSelection((ISelection)new StructuredSelection(eps));
        UnspecifiedTypeConnectionTool tool = new UnspecifiedTypeConnectionTool(Collections.singletonList(DiagramNotationType.NOTE_ATTACHMENT));
        tool.setEditDomain((EditDomain)this.getDiagramWorkbenchPart().getDiagramEditDomain());
        tool.activate();
        tool.mouseDoubleClick(this.createMouseEvent(0, 0), this.getDiagramEditPart().getViewer());
        tool.deactivate();
        ConnectionToolTests.assertEquals((String)"Connection wasn't created.", (int)1, (int)this.getDiagramEditPart().getConnections().size());
    }

    MouseEvent createMouseEvent(int x, int y) {
        Event e = new Event();
        e.widget = this.getDiagramEditPart().getViewer().getControl();
        e.display = e.widget.getDisplay();
        e.button = 1;
        e.x = x;
        e.y = y;
        return new MouseEvent(e);
    }
}

