/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestCommandCallback;

public abstract class AbstractShapeTests
extends AbstractTestBase {
    public AbstractShapeTests(String arg0) {
        super(arg0);
    }

    protected void testCommandOnEditParts(Request request, final Object propertyValue, final EStructuralFeature feature) {
        Iterator objects = this.getShapesIn(this.getDrawSurfaceEditPart()).iterator();
        while (objects.hasNext()) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)objects.next();
            Command cmd = editPart.getCommand(request);
            if (cmd == null) continue;
            final View view = (View)editPart.getModel();
            this.testCommand(cmd, new ITestCommandCallback(){

                public void onCommandExecution() {
                    AbstractShapeTests.assertTrue((boolean)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)feature).equals(propertyValue));
                }
            });
        }
    }

    public void testRATLC00046844() throws Exception {
        IGraphicalEditPart editPart = null;
        Iterator objects = this.getShapesIn(this.getDrawSurfaceEditPart()).iterator();
        if (objects.hasNext()) {
            editPart = (IGraphicalEditPart)objects.next();
        }
        View shapeView = (View)editPart.getModel();
        this.getDrawSurfaceFigure().invalidate();
        this.getDrawSurfaceFigure().validate();
        Dimension newDim = new Dimension(400, 400);
        Dimension oldDim = editPart.getFigure().getSize();
        SetBoundsCommand cmd = new SetBoundsCommand(this.getTestFixture().getEditingDomain(), "testRATLC00046844", (IAdaptable)new EObjectAdapter((EObject)shapeView), newDim);
        this.testCommand((ICommand)cmd, new ITestCommandCallback(){

            public void onCommandExecution() {
            }
        });
        this.getTestFixture().getCommandStack().undo();
        this.getDrawSurfaceFigure().invalidate();
        this.getDrawSurfaceFigure().validate();
        AbstractShapeTests.assertTrue((boolean)editPart.getFigure().getSize().equals((Object)oldDim));
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

