/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gef;

import java.util.Arrays;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.lite.services.DefaultDiagramLayouter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.lite.gen.LiteGeneratorConfiguration;
import org.eclipse.gmf.tests.rt.GeneratedCanvasTest;
import org.eclipse.gmf.tests.setup.ViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramElementTest
extends GeneratedCanvasTest {
    private static final Rectangle NODE_1_BOUNDS = new Rectangle(10, 10, 100, 100);
    private static final Rectangle NODE_2_BOUNDS = new Rectangle(200, 200, 150, 150);
    private static final Rectangle NODE_3_BOUNDS = new Rectangle(400, 570, 70, 70);

    public DiagramElementTest(String name) {
        super(name, (ViewerConfiguration.Factory)new LiteGeneratorConfiguration());
    }

    public void testAlignNodes() {
        Node createdNode1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode1);
        this.moveNode(createdNode1, NODE_1_BOUNDS);
        EditPart ep1 = this.findEditPart((View)createdNode1);
        Node createdNode2 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode2);
        this.moveNode(createdNode2, NODE_2_BOUNDS);
        EditPart ep2 = this.findEditPart((View)createdNode2);
        Node createdNode3 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode3);
        this.moveNode(createdNode3, NODE_3_BOUNDS);
        EditPart ep3 = this.findEditPart((View)createdNode3);
        this.align(Arrays.asList(ep2, ep3, ep1), 1);
        this.checkBounds(createdNode1, NODE_1_BOUNDS);
        this.checkBounds(createdNode2, new Rectangle(10, 200, 150, 150));
        this.checkBounds(createdNode3, new Rectangle(10, 570, 70, 70));
        this.getCommandStack().undo();
        this.align(Arrays.asList(ep1, ep3, ep2), 4);
        this.checkBounds(createdNode1, new Rectangle(250, 10, 100, 100));
        this.checkBounds(createdNode2, NODE_2_BOUNDS);
        this.checkBounds(createdNode3, new Rectangle(280, 570, 70, 70));
        this.getCommandStack().undo();
        this.align(Arrays.asList(ep1, ep2, ep3), 32);
        this.checkBounds(createdNode1, new Rectangle(10, 540, 100, 100));
        this.checkBounds(createdNode2, new Rectangle(200, 490, 150, 150));
        this.checkBounds(createdNode3, NODE_3_BOUNDS);
        this.getCommandStack().undo();
    }

    private void layout(IFigure parentFigure) {
        parentFigure.getLayoutManager().layout(parentFigure);
    }

    private void moveNode(Node node, Rectangle bounds) {
        DiagramElementTest.assertTrue((String)"Unexpected layout constraint", (boolean)(node.getLayoutConstraint() instanceof Bounds));
        Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
        Rectangle original = new Rectangle(nodeBounds.getX(), nodeBounds.getY(), nodeBounds.getWidth(), nodeBounds.getHeight());
        GraphicalEditPart editPart = (GraphicalEditPart)this.findEditPart((View)node);
        DiagramElementTest.assertNotNull((String)"Missing editpart for the node", (Object)editPart);
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize");
        req.setMoveDelta(bounds.getTopLeft().translate(original.getTopLeft().negate()));
        req.setSizeDelta(bounds.getSize().getDifference(original.getSize()));
        req.setEditParts((EditPart)editPart);
        req.setResizeDirection(9);
        org.eclipse.gef.commands.Command cmd = editPart.getCommand((Request)req);
        DiagramElementTest.assertNotNull((String)"No resize command", (Object)cmd);
        DiagramElementTest.assertTrue((String)"Can't execute resize command", (boolean)cmd.canExecute());
        this.getCommandStack().execute(cmd);
        this.checkBounds(node, bounds);
    }

    private void align(List<EditPart> nodes, int alignment) {
        this.layout(((GraphicalEditPart)nodes.get(0)).getFigure().getParent());
        AlignmentAction action = new AlignmentAction((IWorkbenchPart)new ViewPart(){

            public Object getAdapter(Class adapter) {
                if (CommandStack.class == adapter) {
                    return DiagramElementTest.this.getCommandStack();
                }
                return super.getAdapter(adapter);
            }

            public void createPartControl(Composite parent) {
            }

            public void setFocus() {
            }
        }, alignment);
        StructuredSelection selection = new StructuredSelection(nodes);
        action.setSelectionProvider(new ISelectionProvider((IStructuredSelection)selection){
            private final /* synthetic */ IStructuredSelection val$selection;
            {
                this.val$selection = iStructuredSelection;
            }

            public void setSelection(ISelection selection) {
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this.val$selection;
            }

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }
        });
        action.update();
        action.run();
    }

    private void checkBounds(Node node, Rectangle bounds) {
        DiagramElementTest.assertTrue((String)"Unexpected layout constraint", (boolean)(node.getLayoutConstraint() instanceof Bounds));
        Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
        this.checkBounds(nodeBounds, bounds);
    }

    private void checkBounds(Bounds nodeBounds, Rectangle bounds) {
        DiagramElementTest.assertEquals((int)nodeBounds.getX(), (int)bounds.x);
        DiagramElementTest.assertEquals((int)nodeBounds.getY(), (int)bounds.y);
        DiagramElementTest.assertEquals((int)nodeBounds.getWidth(), (int)bounds.width);
        DiagramElementTest.assertEquals((int)nodeBounds.getHeight(), (int)bounds.height);
    }

    public void testLayouter() throws Exception {
        Node createdNode1 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode1);
        this.moveNode(createdNode1, NODE_1_BOUNDS);
        GraphicalEditPart ep1 = (GraphicalEditPart)this.findEditPart((View)createdNode1);
        Node createdNode2 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode2);
        this.moveNode(createdNode2, NODE_1_BOUNDS);
        GraphicalEditPart ep2 = (GraphicalEditPart)this.findEditPart((View)createdNode2);
        Node createdNode3 = this.createTopNode((GenCommonBase)this.getSetup().getGenModel().getNodeA());
        DiagramElementTest.assertNotNull((String)"Node not created", (Object)createdNode3);
        this.moveNode(createdNode3, NODE_1_BOUNDS);
        GraphicalEditPart ep3 = (GraphicalEditPart)this.findEditPart((View)createdNode3);
        GraphicalEditPart diagramEP = (GraphicalEditPart)this.getDiagramEditPart();
        DiagramElementTest.assertTrue((boolean)this.checkModelIntersection(createdNode1, createdNode2));
        DiagramElementTest.assertTrue((boolean)this.checkModelIntersection(createdNode1, createdNode3));
        DiagramElementTest.assertTrue((boolean)this.checkModelIntersection(createdNode2, createdNode3));
        this.layout(diagramEP.getFigure());
        DiagramElementTest.assertTrue((boolean)this.checkVisualIntersection(ep1, ep2));
        DiagramElementTest.assertTrue((boolean)this.checkVisualIntersection(ep1, ep3));
        DiagramElementTest.assertTrue((boolean)this.checkVisualIntersection(ep2, ep3));
        DefaultDiagramLayouter layouter = new DefaultDiagramLayouter();
        Command command = layouter.layout(diagramEP);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram().getElement());
        this.getCommandStack().execute((org.eclipse.gef.commands.Command)new WrappingCommand(editingDomain, command));
        DiagramElementTest.assertFalse((boolean)this.checkModelIntersection(createdNode1, createdNode2));
        DiagramElementTest.assertFalse((boolean)this.checkModelIntersection(createdNode1, createdNode3));
        DiagramElementTest.assertFalse((boolean)this.checkModelIntersection(createdNode2, createdNode3));
        this.layout(diagramEP.getFigure());
        DiagramElementTest.assertFalse((boolean)this.checkVisualIntersection(ep1, ep2));
        DiagramElementTest.assertFalse((boolean)this.checkVisualIntersection(ep1, ep3));
        DiagramElementTest.assertFalse((boolean)this.checkVisualIntersection(ep2, ep3));
    }

    private boolean checkVisualIntersection(GraphicalEditPart ep1, GraphicalEditPart ep2) {
        return ep1.getFigure().getBounds().intersects(ep2.getFigure().getBounds());
    }

    private boolean checkModelIntersection(Node node1, Node node2) {
        Rectangle rect1 = this.getNodePosition(node1);
        Rectangle rect2 = this.getNodePosition(node2);
        return rect1.intersects(rect2);
    }

    private Rectangle getNodePosition(Node node) {
        DiagramElementTest.assertTrue((String)"Unexpected layout constraint", (boolean)(node.getLayoutConstraint() instanceof Bounds));
        Bounds nodeBounds = (Bounds)node.getLayoutConstraint();
        return new Rectangle(nodeBounds.getX(), nodeBounds.getY(), nodeBounds.getWidth(), nodeBounds.getHeight());
    }
}

