/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.commands.core.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;

public abstract class DuplicateEObjectsCommand
extends AbstractTransactionalCommand {
    private List objectsToBeDuplicated;
    private Map allDuplicatedObjects;

    public DuplicateEObjectsCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated) {
        super(editingDomain, label, DuplicateEObjectsCommand.getWorkspaceFiles(eObjectsToBeDuplicated));
        this.objectsToBeDuplicated = eObjectsToBeDuplicated;
        this.allDuplicatedObjects = new HashMap();
    }

    public DuplicateEObjectsCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated, Map allDuplicatedObjectsMap) {
        super(editingDomain, label, DuplicateEObjectsCommand.getWorkspaceFiles(eObjectsToBeDuplicated));
        this.objectsToBeDuplicated = eObjectsToBeDuplicated;
        this.allDuplicatedObjects = allDuplicatedObjectsMap;
    }

    public DuplicateEObjectsCommand(TransactionalEditingDomain editingDomain, String label, List eObjectsToBeDuplicated, Map allDuplicatedObjectsMap, EObject targetContainer) {
        super(editingDomain, label, DuplicateEObjectsCommand.getWorkspaceFiles(targetContainer));
        this.objectsToBeDuplicated = eObjectsToBeDuplicated;
        this.allDuplicatedObjects = allDuplicatedObjectsMap;
    }

    protected Map getAllDuplicatedObjectsMap() {
        return this.allDuplicatedObjects;
    }

    protected List getObjectsToBeDuplicated() {
        return this.objectsToBeDuplicated;
    }

    public boolean canExecute() {
        for (EObject original : this.objectsToBeDuplicated) {
            EReference reference = original.eContainmentFeature();
            if (reference != null && FeatureMapUtil.isMany((EObject)original.eContainer(), (EStructuralFeature)reference)) continue;
            return false;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        ClipboardSupportUtil.getCopyElements((Collection)this.getObjectsToBeDuplicated());
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        copier.copyAll((Collection)this.objectsToBeDuplicated);
        copier.copyReferences();
        this.getAllDuplicatedObjectsMap().putAll(copier);
        for (EObject original : this.objectsToBeDuplicated) {
            EObject duplicate = (EObject)copier.get((Object)original);
            EReference reference = original.eContainmentFeature();
            if (reference == null || !FeatureMapUtil.isMany((EObject)original.eContainer(), (EStructuralFeature)reference) || !ClipboardSupportUtil.isOkToAppendEObjectAt((EObject)original.eContainer(), (EReference)reference, (EObject)duplicate)) continue;
            ClipboardSupportUtil.appendEObjectAt((EObject)original.eContainer(), (EReference)reference, (EObject)duplicate);
        }
        return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
    }
}

