/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class DeferredLayoutCommand
extends AbstractTransactionalCommand {
    protected String layoutType;
    protected List viewAdapters;
    protected IGraphicalEditPart containerEP;

    public DeferredLayoutCommand(TransactionalEditingDomain editingDomain, List viewAdapters, IGraphicalEditPart containerEP) {
        this(editingDomain, viewAdapters, containerEP, "DEFAULT");
    }

    public DeferredLayoutCommand(TransactionalEditingDomain editingDomain, List viewAdapters, IGraphicalEditPart containerEP, String commandLayoutType) {
        super(editingDomain, DiagramUIMessages.Command_Deferred_Layout, null);
        this.layoutType = commandLayoutType != null ? commandLayoutType : "DEFAULT";
        this.viewAdapters = viewAdapters;
        this.containerEP = containerEP;
    }

    public List getAffectedFiles() {
        View view;
        if (this.containerEP != null && (view = (View)this.containerEP.getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        RunnableWithResult refreshRunnable = new RunnableWithResult(){
            private IStatus status;
            private Object result;

            public Object getResult() {
                return this.result;
            }

            public void setStatus(IStatus status) {
                this.status = status;
            }

            public IStatus getStatus() {
                return this.status;
            }

            public void run() {
                Object ep;
                DeferredLayoutCommand.this.containerEP.refresh();
                DeferredLayoutCommand.this.getContainerFigure().invalidate();
                DeferredLayoutCommand.this.getContainerFigure().validate();
                ArrayList editParts = new ArrayList(DeferredLayoutCommand.this.viewAdapters.size());
                Map epRegistry = DeferredLayoutCommand.this.containerEP.getRoot().getViewer().getEditPartRegistry();
                for (IAdaptable ad : DeferredLayoutCommand.this.viewAdapters) {
                    View view = (View)ad.getAdapter(View.class);
                    ep = epRegistry.get(view);
                    if (ep == null) continue;
                    editParts.add(ep);
                }
                if (editParts.isEmpty()) {
                    this.result = editParts;
                    return;
                }
                HashSet layoutSet = new HashSet(editParts.size());
                layoutSet.addAll(editParts);
                for (Object obj : DeferredLayoutCommand.this.containerEP.getChildren()) {
                    if (layoutSet.contains(obj) || !(obj instanceof IGraphicalEditPart)) continue;
                    ep = (IGraphicalEditPart)obj;
                    ep.refresh();
                }
                this.result = editParts;
            }
        };
        EditPartUtil.synchronizeRunnableToMainThread(this.containerEP, (Runnable)refreshRunnable);
        List editParts = (List)refreshRunnable.getResult();
        if (editParts == null || editParts.isEmpty()) {
            return CommandResult.newOKCommandResult();
        }
        ArrangeRequest request = new ArrangeRequest("arrangeSelectionAction", this.layoutType);
        request.setPartsToArrange(editParts);
        Command layoutCmd = this.containerEP.getCommand(request);
        if (layoutCmd != null && layoutCmd.canExecute()) {
            ICommand optimizedCommand = this.optimizeCommand(layoutCmd);
            optimizedCommand.execute(progressMonitor, info);
            optimizedCommand = null;
        }
        return CommandResult.newOKCommandResult();
    }

    private ICommand optimizeCommand(Command command) {
        if (command instanceof ICommandProxy) {
            ICommand icmd = ((ICommandProxy)command).getICommand();
            return icmd;
        }
        if (command instanceof CompoundCommand) {
            CompositeTransactionalCommand transactionalCommand = new CompositeTransactionalCommand(this.getEditingDomain(), command.getLabel());
            transactionalCommand.setTransactionNestingEnabled(false);
            CompoundCommand compound = (CompoundCommand)command;
            for (Command iteredCommand : compound.getCommands()) {
                ICommand iteredICommand = this.optimizeCommand(iteredCommand);
                transactionalCommand.compose((IUndoableOperation)iteredICommand);
            }
            return transactionalCommand;
        }
        if (command != null) {
            return new CommandProxy(command);
        }
        return null;
    }

    protected void cleanup() {
        this.containerEP = null;
        this.viewAdapters = null;
        super.cleanup();
    }

    protected IFigure getContainerFigure() {
        return this.containerEP.getFigure();
    }

    protected IGraphicalEditPart getContainerEP() {
        return this.containerEP;
    }

    protected List getViewAdapters() {
        return this.viewAdapters;
    }

    public boolean canExecute() {
        return super.canExecute() && this.containerEP != null;
    }
}

