/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.edithelpers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class NotationViewDependentsAdvice
extends AbstractEditHelperAdvice {
    public ICommand getBeforeEditCommand(IEditCommandRequest request) {
        if (request instanceof DestroyDependentsRequest) {
            return this.getBeforeDestroyDependentsCommand((DestroyDependentsRequest)request);
        }
        return null;
    }

    public ICommand getAfterEditCommand(IEditCommandRequest request) {
        return null;
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        EObject destructee = request.getElementToDestroy();
        CrossReferenceAdapter crossReferenceAdapter = this.getCrossReferenceAdapter(request, destructee);
        ICommand result = this.getDestroyDependentsCommand(destructee, request, NotationPackage.Literals.VIEW__ELEMENT, crossReferenceAdapter);
        if (destructee instanceof View) {
            result = CompositeCommand.compose((ICommand)result, (ICommand)this.getDestroyDependentsCommand(destructee, request, NotationPackage.Literals.NODE_ENTRY__KEY, crossReferenceAdapter));
            if (destructee instanceof Node || destructee instanceof Edge) {
                View view = (View)destructee;
                if (view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__SOURCE_EDGES)) {
                    result = CompositeCommand.compose((ICommand)result, (ICommand)request.getDestroyDependentsCommand((Collection)view.getSourceEdges()));
                }
                if (view.eIsSet((EStructuralFeature)NotationPackage.Literals.VIEW__TARGET_EDGES)) {
                    result = CompositeCommand.compose((ICommand)result, (ICommand)request.getDestroyDependentsCommand((Collection)view.getTargetEdges()));
                }
            }
        }
        return result;
    }

    private CrossReferenceAdapter getCrossReferenceAdapter(DestroyDependentsRequest request, EObject destructee) {
        TransactionalEditingDomain domain;
        CrossReferenceAdapter crossReferenceAdapter = null;
        Map cacheMaps = (Map)request.getParameter("Cache_Maps");
        if (cacheMaps != null) {
            crossReferenceAdapter = (CrossReferenceAdapter)cacheMaps.get("CrossRefAdapter");
        }
        if (crossReferenceAdapter == null && (crossReferenceAdapter = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)destructee)) == null && (domain = TransactionUtil.getEditingDomain((EObject)destructee)) != null) {
            crossReferenceAdapter = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)domain.getResourceSet());
        }
        return crossReferenceAdapter;
    }

    private ICommand getDestroyDependentsCommand(EObject destructee, DestroyDependentsRequest request, EReference eRef, CrossReferenceAdapter crossReferenceAdapter) {
        Collection revRefs;
        if (crossReferenceAdapter != null && !(revRefs = crossReferenceAdapter.getNonNavigableInverseReferences(destructee)).isEmpty()) {
            HashSet<EObject> set = null;
            Iterator it = revRefs.iterator();
            while (it.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)it.next();
                if (setting.getEStructuralFeature() != eRef) continue;
                if (set == null) {
                    set = new HashSet<EObject>();
                }
                set.add(setting.getEObject());
            }
            if (set != null) {
                return request.getDestroyDependentsCommand(set);
            }
        }
        return null;
    }
}

