/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.ActionManager;
import org.eclipse.gmf.runtime.common.ui.action.IActionWithProgress;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.util.PartListenerAdapter;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractContributionItem
extends ContributionItem
implements ISelectionChangedListener,
IOperationHistoryListener,
IActionWithProgress {
    private boolean setup;
    private IWorkbenchPage workbenchPage;
    private IPartListener partListener;
    private IWorkbenchPart workbenchPart;
    private Listener itemListener;
    private Item item;
    private Control control;
    private String label;
    private boolean enabled = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.AbstractContributionItem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public AbstractContributionItem(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    public AbstractContributionItem(IWorkbenchPage workbenchPage, String id) {
        super(id);
        if (!$assertionsDisabled && workbenchPage == null) {
            throw new AssertionError((Object)"workbenchPage is null");
        }
        this.workbenchPage = workbenchPage;
        this.partListener = new PartListenerAdapter(){

            public void partActivated(IWorkbenchPart part) {
                AbstractContributionItem.this.setWorkbenchPart(part);
                AbstractContributionItem.this.update();
            }
        };
        this.itemListener = new Listener(){

            public void handleEvent(Event event) {
                AbstractContributionItem.this.handleWidgetEvent(event);
            }
        };
    }

    protected void init() {
        if (this.getWorkbenchPart() == null) {
            this.setWorkbenchPart(this.workbenchPage.getActivePart());
        }
        this.workbenchPage.addPartListener(this.partListener);
    }

    public void dispose() {
        this.workbenchPage.removePartListener(this.partListener);
        this.setWorkbenchPart(null);
        this.item = null;
        this.control = null;
        super.dispose();
    }

    protected IWorkbenchPart getWorkbenchPart() {
        return this.workbenchPart;
    }

    protected IUndoContext getUndoContext() {
        IWorkbenchPart part = this.getWorkbenchPart();
        if (part != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.commands.operations.IUndoContext");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IUndoContext)part.getAdapter((Class)clazz);
        }
        return null;
    }

    protected Control getControl() {
        return this.control;
    }

    protected Item getItem() {
        return this.item;
    }

    protected ToolItem getToolItem() {
        return this.item instanceof ToolItem ? (ToolItem)this.item : null;
    }

    protected MenuItem getMenuItem() {
        return this.item instanceof MenuItem ? (MenuItem)this.item : null;
    }

    public String getLabel() {
        return this.label;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setWorkbenchPart(IWorkbenchPart workbenchPart) {
        ISelectionProvider provider;
        if (this.getWorkbenchPart() != null) {
            if (this.isSelectionListener() && (provider = this.getWorkbenchPart().getSite().getSelectionProvider()) != null) {
                provider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.isOperationHistoryListener()) {
                this.getOperationHistory().removeOperationHistoryListener((IOperationHistoryListener)this);
            }
        }
        this.workbenchPart = workbenchPart;
        if (workbenchPart != null) {
            if (this.isSelectionListener() && (provider = this.getWorkbenchPart().getSite().getSelectionProvider()) != null) {
                provider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (this.isOperationHistoryListener()) {
                this.getOperationHistory().addOperationHistoryListener((IOperationHistoryListener)this);
            }
        }
    }

    public final void fill(Composite parent) {
        this.init();
        this.control = this.createControl(parent);
        if (this.control != null) {
            this.update();
        }
        if (!$assertionsDisabled && this.control == null) {
            throw new AssertionError((Object)"The contribution item cannot fill in composites");
        }
    }

    public final void fill(Menu parent, int index) {
        this.init();
        MenuItem menuItem = this.createMenuItem(parent, index);
        if (menuItem != null) {
            menuItem.setData((Object)this);
            menuItem.setText(this.getLabel());
            menuItem.addListener(12, this.getItemListener());
            this.setItem((Item)menuItem);
            this.update();
        }
        if (!$assertionsDisabled && menuItem == null) {
            throw new AssertionError((Object)"The contribution item cannot fill in menus");
        }
    }

    public final void fill(ToolBar parent, int index) {
        this.init();
        ToolItem toolItem = this.createToolItem(parent, index);
        if (toolItem != null) {
            toolItem.setData((Object)this);
            toolItem.setToolTipText(this.getLabel());
            toolItem.addListener(12, this.getItemListener());
            this.setItem((Item)toolItem);
            this.update();
        }
        if (!$assertionsDisabled && toolItem == null) {
            throw new AssertionError((Object)"The contribution item cannot fill in toolbars");
        }
    }

    protected ToolItem createToolItem(ToolBar parent, int index) {
        this.control = this.createControl((Composite)parent);
        if (this.control != null) {
            ToolItem anItem = new ToolItem(parent, 2, index);
            anItem.setControl(this.control);
            anItem.setWidth(this.computeWidth(this.control));
            return anItem;
        }
        return null;
    }

    protected MenuItem createMenuItem(Menu parent, int index) {
        return null;
    }

    protected Control createControl(Composite parent) {
        return null;
    }

    protected int computeWidth(Control cont) {
        return cont.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    public final void update() {
        if (this.getWorkbenchPart() == null) {
            this.setWorkbenchPart(this.workbenchPage.getActivePart());
        }
        if (this.getWorkbenchPart() != null) {
            this.refresh();
        }
    }

    public void refresh() {
        this.setEnabled(this.calculateEnabled());
        if (this.getControl() != null || this.getItem() != null) {
            this.refreshItem();
        }
    }

    protected void refreshItem() {
        if (this.getControl() != null) {
            this.getControl().setEnabled(this.isEnabled());
        } else if (this.getToolItem() != null) {
            this.getToolItem().setEnabled(this.isEnabled());
        } else if (this.getMenuItem() != null) {
            this.getMenuItem().setEnabled(this.isEnabled());
        }
    }

    protected abstract boolean calculateEnabled();

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void execute(ICommand command) {
        if (command == null || !command.canExecute()) {
            return;
        }
        command.addContext(this.getUndoContext());
        try {
            this.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"execute", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)3, (String)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ActionManager getActionManager() {
        ActionManager manager;
        IWorkbenchPart iWorkbenchPart = this.getWorkbenchPart();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.gmf.runtime.common.ui.action.ActionManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (manager = (ActionManager)iWorkbenchPart.getAdapter((Class)clazz)) == null ? ActionManager.getDefault() : manager;
    }

    protected IOperationHistory getOperationHistory() {
        return this.getActionManager().getOperationHistory();
    }

    protected void runWithEvent(Event event) {
        this.getActionManager().run(this);
    }

    protected abstract void doRun(IProgressMonitor var1);

    protected void handle(Exception exception) {
        Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"handle", (Throwable)exception);
        Status status = new Status(4, CommonUIPlugin.getPluginId(), 3, String.valueOf(exception.getMessage()), (Throwable)exception);
        Log.log((Plugin)CommonUIPlugin.getDefault(), (IStatus)status);
        this.openErrorDialog((IStatus)status);
    }

    protected void openErrorDialog(IStatus status) {
        ErrorDialog.openError((Shell)this.getWorkbenchPart().getSite().getShell(), (String)this.getLabel(), null, (IStatus)status);
    }

    protected void handleWidgetEvent(Event e) {
        switch (e.type) {
            case 12: {
                this.handleWidgetDispose(e);
            }
        }
    }

    protected void handleWidgetDispose(Event e) {
        this.dispose();
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected boolean isOperationHistoryListener() {
        return false;
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoContext partContext;
        IUndoableOperation operation;
        int type = event.getEventType();
        if ((type == 10 || type == 9 || type == 5 || type == 6 || type == 7 || type == 8) && (operation = event.getOperation()) != null && (partContext = this.getUndoContext()) != null && operation.hasContext(partContext)) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    AbstractContributionItem.this.update();
                }
            });
        }
    }

    protected ISelection getSelection() {
        ISelection selection = null;
        ISelectionProvider selectionProvider = this.getWorkbenchPart().getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selection = selectionProvider.getSelection();
        }
        return selection != null ? selection : StructuredSelection.EMPTY;
    }

    protected IStructuredSelection getStructuredSelection() {
        StructuredSelection selection = null;
        ISelectionProvider selectionProvider = this.getWorkbenchPart().getSite().getSelectionProvider();
        if (selectionProvider != null && selectionProvider.getSelection() instanceof IStructuredSelection) {
            selection = (IStructuredSelection)selectionProvider.getSelection();
        }
        return selection != null ? selection : StructuredSelection.EMPTY;
    }

    protected Listener getItemListener() {
        return this.itemListener;
    }

    public IActionWithProgress.WorkIndicatorType getWorkIndicatorType() {
        return IActionWithProgress.WorkIndicatorType.BUSY;
    }

    public boolean isRunnable() {
        return this.isEnabled();
    }

    public void run(IProgressMonitor progressMonitor) {
        if (this.isSetup() || !this.needsSetup()) {
            try {
                this.doRun(progressMonitor);
            }
            catch (Exception e) {
                this.handle(e);
            }
        } else {
            throw new IllegalStateException("action must be setup before it is run");
        }
        this.setSetup(false);
    }

    public boolean setup() {
        this.setSetup(true);
        return true;
    }

    public boolean isSetup() {
        return this.setup;
    }

    protected void setSetup(boolean setup) {
        this.setup = setup;
    }

    protected boolean needsSetup() {
        return false;
    }
}

