/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen.ui;

import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeLiteFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FigureGeneratorOptionsDialog
extends TitleAreaDialog {
    private Button useMapModeButton;
    private Button useRuntimeFiguresButton;
    private boolean useMapMode;
    private boolean useRuntimeFigures;
    private String title;

    public FigureGeneratorOptionsDialog(Shell parentShell, String dialogTitle, boolean initialUseRuntimeFigures, boolean initialUseMapMode) {
        super(parentShell);
        this.title = dialogTitle;
        this.useMapMode = initialUseMapMode;
        this.useRuntimeFigures = initialUseRuntimeFigures;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        this.createControls(result);
        this.setTitle("Generator Model Options");
        this.warnLiteVerstionDoesNotSupportMapMode();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void createControls(Composite result) {
        this.useMapModeButton = new Button(result, 32);
        this.useMapModeButton.setText("Use &IMapMode");
        this.useMapModeButton.setSelection(this.useMapMode);
        this.useMapModeButton.setLayoutData((Object)new GridData(36));
        this.useRuntimeFiguresButton = new Button(result, 32);
        this.useRuntimeFiguresButton.setText("&Utilize enhanced features of GMF runtime");
        this.useRuntimeFiguresButton.setSelection(this.useRuntimeFigures);
        this.useRuntimeFiguresButton.setLayoutData((Object)new GridData(36));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FigureGeneratorOptionsDialog.this.warnLiteVerstionDoesNotSupportMapMode();
            }

            public void widgetSelected(SelectionEvent e) {
                FigureGeneratorOptionsDialog.this.warnLiteVerstionDoesNotSupportMapMode();
            }
        };
        this.useMapModeButton.addSelectionListener(selectionListener);
        this.useRuntimeFiguresButton.addSelectionListener(selectionListener);
        this.useMapModeButton.setSelection(this.useMapMode);
        this.useRuntimeFiguresButton.setSelection(this.useRuntimeFigures);
    }

    protected void warnLiteVerstionDoesNotSupportMapMode() {
        if (!this.useRuntimeFiguresButton.getSelection() && this.useMapModeButton.getSelection()) {
            this.setMessage("It is not recommended to use IMapMode for pure-GEF diagram editors", 1);
        } else {
            this.setMessage(null);
        }
    }

    protected void okPressed() {
        this.useRuntimeFigures = this.useRuntimeFiguresButton.getSelection();
        this.useMapMode = this.useMapModeButton.getSelection();
        super.okPressed();
    }

    public FigureQualifiedNameSwitch getFigureQualifiedNameSwitch() {
        if (this.useRuntimeFigures) {
            return new RuntimeFQNSwitch();
        }
        return new RuntimeLiteFQNSwitch();
    }

    public MapModeCodeGenStrategy getMapModeCodeGenStrategy() {
        if (this.useMapMode) {
            return new MapModeCodeGenStrategy.RuntimeUnspecifiedMapMode();
        }
        return new MapModeCodeGenStrategy.StaticIdentityMapMode();
    }

    public boolean isUseMapMode() {
        return this.useMapMode;
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

