/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.dispatch;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.codegen.dispatch.Dispatcher;
import org.eclipse.gmf.internal.codegen.dispatch.EmitterFactory;
import org.eclipse.gmf.internal.codegen.dispatch.KeyChain;
import org.eclipse.gmf.internal.codegen.dispatch.KeyMap;
import org.eclipse.gmf.internal.codegen.dispatch.NoSuchTemplateException;
import org.osgi.framework.Bundle;

public class DispatcherImpl
implements Dispatcher {
    private final EmitterFactory myFactory;
    private final KeyMap myKeyMap;
    protected final TraceFacility traceFacility;
    private final boolean shouldTraceMissedTemplates;

    public DispatcherImpl(EmitterFactory factory, KeyMap keyMap) {
        this.myFactory = factory;
        this.myKeyMap = keyMap;
        this.traceFacility = new TraceFacility("org.eclipse.gmf.common");
        this.shouldTraceMissedTemplates = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.gmf.common/templates/missed/log"));
    }

    public String dispatch(Object key, Object argument) {
        StringBuffer errors;
        block8: {
            try {
                errors = new StringBuffer();
                KeyChain it = this.myKeyMap.map(key);
                while (it.hasNext()) {
                    Object nextKey = it.next();
                    if (!this.myFactory.checkEmitter(nextKey)) continue;
                    try {
                        JETEmitter em = this.myFactory.acquireEmitter(nextKey);
                        return em.generate((IProgressMonitor)new NullProgressMonitor(), new Object[]{argument});
                    }
                    catch (NoSuchTemplateException ex) {
                        this.traceFacility.error("Template for key '" + nextKey + "' failed", ex);
                        errors.append(DispatcherImpl.formatError(ex));
                        errors.append("\n");
                    }
                    catch (UnexpectedBehaviourException ex) {
                        this.traceFacility.error("Template for key '" + nextKey + "' failed", ex);
                        errors.append(DispatcherImpl.formatError(ex));
                        errors.append("\n");
                    }
                }
                if (errors.length() != 0) break block8;
                if (this.shouldTraceMissedTemplates) {
                    String msg = "No suitable template found for '" + key + "'";
                    this.traceFacility.warn(msg, null);
                    return "// " + msg;
                }
                return "";
            }
            catch (JETException ex) {
                this.traceFacility.error(ex.getMessage(), (Exception)((Object)ex));
                return "ERROR: " + DispatcherImpl.formatError((Exception)((Object)ex));
            }
        }
        return errors.toString();
    }

    private static String formatError(Exception ex) {
        return String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage();
    }

    private static class TraceFacility {
        private final ILog traceFacility;

        public TraceFacility(String pluginID) {
            this.traceFacility = Platform.getLog((Bundle)Platform.getBundle((String)pluginID));
        }

        public void error(String message, Exception ex) {
            this.log(4, message, ex);
        }

        public void warn(String message, Exception ex) {
            this.log(2, message, ex);
        }

        public String getPluginID() {
            return this.traceFacility.getBundle().getSymbolicName();
        }

        private void log(int severity, String message, Exception ex) {
            this.traceFacility.log((IStatus)new Status(severity, this.getPluginID(), 0, message, (Throwable)ex));
        }
    }
}

