/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.inactive;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.eclipse.gmf.internal.xpand.Activator;

public class StreamDecoder {
    public static final Charset LEGACY_ENCODING = Charset.forName("ISO-8859-1");
    private final InputStream myInputStream;
    private final Charset myDefaultEncoding;
    private Reader myResult;
    private Charset myEncoding;

    public StreamDecoder(InputStream is, Charset defaultEncoding) {
        assert (is != null);
        this.myInputStream = StreamDecoder.ensureMarkSupported(is);
        this.myDefaultEncoding = defaultEncoding;
    }

    public Reader getReader() {
        if (this.myResult == null) {
            this.myResult = this.createReader(this.myInputStream, this.getEncoding());
        }
        return this.myResult;
    }

    public Charset getEncoding() {
        if (this.myEncoding == null) {
            this.myEncoding = this.detectEncoding(this.myInputStream);
        }
        return this.myEncoding;
    }

    protected Charset detectEncoding(InputStream is) {
        assert (is.markSupported());
        is.mark(1024);
        try {
            int b1 = is.read();
            int b2 = is.read();
            if (b1 == -1 || b2 == -1) {
                Charset charset = this.myDefaultEncoding;
                return charset;
            }
            if (b1 == 254 && b2 == 255) {
                Charset charset = Charset.forName("UTF-16BE");
                return charset;
            }
            if (b1 == 255 && b2 == 254) {
                Charset charset = Charset.forName("UTF-16LE");
                return charset;
            }
            int b3 = is.read();
            if (b3 == -1) {
                Charset charset = this.myDefaultEncoding;
                return charset;
            }
            if (b1 == 239 && b2 == 187 && b3 == 191) {
                Charset charset = Charset.forName("UTF-8");
                return charset;
            }
            is.reset();
            boolean foundC2BB = false;
            boolean foundC2AB = false;
            boolean foundBB = false;
            boolean foundAB = false;
            boolean foundC2 = false;
            int i = 1024;
            while (i > 0) {
                int b = is.read();
                if (b == -1) break;
                if (!foundAB && !foundC2AB) {
                    foundAB = b == 171;
                    boolean bl = foundC2AB = foundC2 && foundAB;
                }
                if (!foundBB && !foundC2BB) {
                    foundBB = b == 187;
                    foundC2BB = foundC2 && foundBB;
                }
                foundC2 = b == 194;
                --i;
            }
            if (foundC2AB && foundC2BB) {
                Charset charset = Charset.forName("UTF-8");
                return charset;
            }
            if (foundAB && foundBB) {
                Charset charset = LEGACY_ENCODING;
                return charset;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                is.reset();
            }
            catch (IOException ex) {
                Activator.logError(ex);
            }
        }
        return this.myDefaultEncoding;
    }

    protected Reader createReader(InputStream is, Charset encoding) {
        return encoding != null ? new InputStreamReader(is, encoding) : new InputStreamReader(is);
    }

    public static InputStream ensureMarkSupported(InputStream is) {
        return is.markSupported() ? is : new BufferedInputStream(is);
    }
}

