/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.parser;

import java.util.List;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.expression.ast.StringLiteral;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.expression.parser.ExpressionFactory;
import org.eclipse.gmf.internal.xpand.xtend.ast.CreateExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExpressionExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.ExtensionFile;
import org.eclipse.gmf.internal.xpand.xtend.ast.ImportStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.JavaExtensionStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.WorkflowSlotExtensionStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFactory
extends ExpressionFactory {
    public ExtensionFactory(String string) {
        super(string);
    }

    public ExtensionFile createExtensionFile(List<SyntaxElement> nsimports, List<SyntaxElement> extimports, List<SyntaxElement> extensions) {
        return this.handle(new ExtensionFile(0, -1, 1, nsimports, extimports, extensions));
    }

    public ImportStatement createNsImport(IToken s, IToken e, StringLiteral st) {
        return this.handle(new ImportStatement(ExtensionFactory.start(s), ExtensionFactory.end(e), ExtensionFactory.line(s), st.getValue()));
    }

    public ImportStatement createExtensionFileImport(IToken s, IToken e, Identifier t, IToken exported) {
        return this.handle(new ImportStatement(ExtensionFactory.start(s), ExtensionFactory.end(e), ExtensionFactory.line(s), t, exported != null));
    }

    public JavaExtensionStatement createJavaExtension(IToken name, IToken endSemi, Identifier type, List<DeclaredParameter> params, Identifier fqn, List<Identifier> javaParamTypes, IToken cached, IToken isPrivate, Identifier instanceSlot) {
        String txt = fqn.getValue();
        int index = txt.lastIndexOf(46);
        String typeName = txt.substring(0, index);
        String methodName = txt.substring(index + 1);
        int start = ExtensionFactory.getExtensionStart(cached, type, name);
        int line = ExtensionFactory.getExtensionLine(cached, type, name);
        Identifier javaMethod = new Identifier(fqn.getStart() + index + 1, fqn.getEnd(), fqn.getLine(), methodName);
        Identifier javaType = new Identifier(fqn.getStart(), fqn.getStart() + index, fqn.getLine(), typeName);
        return this.handle(new JavaExtensionStatement(start, ExtensionFactory.end(endSemi), line, this.createIdentifier(name), params, type, javaType, javaMethod, javaParamTypes, cached != null, isPrivate != null, instanceSlot));
    }

    public WorkflowSlotExtensionStatement createWorkflowSlotExtension(IToken name, IToken e, Identifier type, List<DeclaredParameter> params, Identifier slotName, IToken cached, IToken priv) {
        int start = ExtensionFactory.getExtensionStart(cached, type, name);
        int line = ExtensionFactory.getExtensionLine(cached, type, name);
        return this.handle(new WorkflowSlotExtensionStatement(start, ExtensionFactory.end(e), line, this.createIdentifier(name), params, type, slotName, cached != null, priv != null));
    }

    protected static int getExtensionStart(IToken resentful, Identifier type, IToken name) {
        int start = ExtensionFactory.start(name);
        if (resentful != null) {
            start = ExtensionFactory.start(resentful);
        } else if (type != null) {
            start = type.getStart();
        }
        return start;
    }

    protected static int getExtensionLine(IToken resentful, Identifier type, IToken name) {
        int line = ExtensionFactory.line(name);
        if (resentful != null) {
            line = ExtensionFactory.line(resentful);
        } else if (type != null) {
            line = type.getLine();
        }
        return line;
    }

    public ExpressionExtensionStatement createExpressionExtension(IToken name, IToken e, Identifier returnType, List<DeclaredParameter> params, Expression expr, IToken cached, IToken priv) {
        int start = ExtensionFactory.getExtensionStart(cached, returnType, name);
        int line = ExtensionFactory.getExtensionLine(cached, returnType, name);
        return this.handle(new ExpressionExtensionStatement(start, ExtensionFactory.end(e), line, this.createIdentifier(name), returnType, params, expr, cached != null, priv != null));
    }

    public Extension createCreateExtension(IToken create, IToken e, Identifier returnType, IToken rtn, IToken name, List<DeclaredParameter> params, Expression expr, IToken priv) {
        int start = ExtensionFactory.start(create);
        int line = ExtensionFactory.line(create);
        if (priv != null) {
            start = ExtensionFactory.start(priv);
            line = ExtensionFactory.line(priv);
        }
        return this.handle(new CreateExtensionStatement(start, ExtensionFactory.end(e), line, this.createIdentifier(name), returnType, rtn != null ? this.createIdentifier(rtn) : null, params, expr, priv != null));
    }
}

