/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;
import org.eclipse.gmf.internal.xpand.util.DefinitionSignature;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeXtendResource
implements XtendResource {
    private final XtendResource[] myResources;
    private final List<Extension> myCachedExtensions;

    public CompositeXtendResource(ResourceManager manager, XtendResource[] resources) {
        this.myResources = resources;
        this.myCachedExtensions = new ArrayList<Extension>();
        HashSet<DefinitionSignature> signatures = new HashSet<DefinitionSignature>();
        ExecutionContext context = ContextFactory.createXtendContext(manager);
        XtendResource[] xtendResourceArray = this.myResources;
        int n = this.myResources.length;
        int n2 = 0;
        while (n2 < n) {
            XtendResource nextResource = xtendResourceArray[n2];
            this.mergeExtensions(context, nextResource.getExtensions(), this.myCachedExtensions, signatures);
            ++n2;
        }
    }

    private void mergeExtensions(ExecutionContext context, List<Extension> extensions, List<Extension> collector, Set<DefinitionSignature> usedSignatures) {
        for (Extension nextExtension : extensions) {
            DefinitionSignature signature;
            if (context.currentResource() != nextExtension.getExtensionFile()) {
                context = context.cloneWithResource(nextExtension.getExtensionFile());
            }
            if ((signature = DefinitionSignature.create(context, nextExtension)) == null || usedSignatures.contains(signature)) continue;
            usedSignatures.add(signature);
            collector.add(nextExtension);
        }
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        XtendResource[] xtendResourceArray = this.myResources;
        int n = this.myResources.length;
        int n2 = 0;
        while (n2 < n) {
            XtendResource nextResource = xtendResourceArray[n2];
            nextResource.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public List<Extension> getExtensions() {
        return this.myCachedExtensions;
    }

    @Override
    public String[] getImportedExtensions() {
        ArrayList result = new ArrayList();
        XtendResource[] xtendResourceArray = this.myResources;
        int n = this.myResources.length;
        int n2 = 0;
        while (n2 < n) {
            XtendResource nextResource = xtendResourceArray[n2];
            result.addAll(Arrays.asList(nextResource.getImportedNamespaces()));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String[] getImportedNamespaces() {
        ArrayList result = new ArrayList();
        XtendResource[] xtendResourceArray = this.myResources;
        int n = this.myResources.length;
        int n2 = 0;
        while (n2 < n) {
            XtendResource nextResource = xtendResourceArray[n2];
            result.addAll(Arrays.asList(nextResource.getImportedExtensions()));
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public List<Extension> getPublicExtensions(ResourceManager resourceManager) {
        ArrayList<Extension> publicExtensions = new ArrayList<Extension>();
        HashSet<DefinitionSignature> signatures = new HashSet<DefinitionSignature>();
        ExecutionContext context = ContextFactory.createXtendContext(resourceManager);
        XtendResource[] xtendResourceArray = this.myResources;
        int n = this.myResources.length;
        int n2 = 0;
        while (n2 < n) {
            XtendResource nextResource = xtendResourceArray[n2];
            this.mergeExtensions(context, nextResource.getPublicExtensions(resourceManager), publicExtensions, signatures);
            ++n2;
        }
        return publicExtensions;
    }
}

