/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.parser;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lpg.lpgjavaruntime.LexParser;
import lpg.lpgjavaruntime.LexStream;
import lpg.lpgjavaruntime.LpgLexStream;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.ParseTable;
import lpg.lpgjavaruntime.PrsStream;
import lpg.lpgjavaruntime.RuleAction;
import lpg.lpgjavaruntime.TokenStream;
import org.eclipse.gmf.internal.xpand.parser.XpandKWLexer;
import org.eclipse.gmf.internal.xpand.parser.XpandLexerprs;
import org.eclipse.gmf.internal.xpand.parser.XpandLexersym;
import org.eclipse.gmf.internal.xpand.parser.XpandParsersym;
import org.eclipse.gmf.internal.xpand.util.ParserException;

public class XpandLexer
extends LpgLexStream
implements XpandParsersym,
XpandLexersym,
RuleAction {
    private static ParseTable prs = new XpandLexerprs();
    private PrsStream prsStream;
    private final LexParser lexParser = new LexParser((TokenStream)this, prs, (RuleAction)this);
    private final List<ParserException.ErrorLocationInfo> errors = new LinkedList<ParserException.ErrorLocationInfo>();
    private XpandKWLexer kwLexer;
    private static final int ECLIPSE_TAB_VALUE = 4;
    public static final int[] tokenKind = new int[]{101, 101, 101, 101, 101, 101, 101, 101, 101, 88, 98, 101, 89, 99, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101, 65, 75, 73, 94, 95, 90, 67, 74, 86, 87, 72, 84, 82, 85, 69, 71, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 68, 97, 83, 30, 70, 81, 91, 23, 24, 25, 14, 1, 26, 48, 49, 50, 51, 52, 53, 27, 28, 54, 55, 56, 29, 57, 58, 59, 60, 61, 62, 63, 64, 79, 76, 80, 96, 47, 92, 15, 12, 16, 17, 18, 13, 31, 32, 33, 34, 35, 36, 37, 19, 38, 39, 40, 20, 41, 21, 22, 42, 43, 44, 45, 46, 77, 66, 78, 93, 102, 104};

    public PrsStream getPrsStream() {
        return this.prsStream;
    }

    public int getToken(int i) {
        return this.lexParser.getToken(i);
    }

    public int getRhsFirstTokenIndex(int i) {
        return this.lexParser.getFirstToken(i);
    }

    public int getRhsLastTokenIndex(int i) {
        return this.lexParser.getLastToken(i);
    }

    public int getLeftSpan() {
        return this.lexParser.getFirstToken();
    }

    public int getRightSpan() {
        return this.lexParser.getLastToken();
    }

    public XpandLexer(String filename, int tab) throws IOException {
        super(filename, tab);
    }

    public XpandLexer(char[] input_chars, String filename, int tab) {
        super(input_chars, filename, tab);
    }

    public XpandLexer(char[] input_chars, String filename) {
        this(input_chars, filename, 1);
    }

    public XpandLexer() {
    }

    public String[] orderedExportedSymbols() {
        return XpandParsersym.orderedTerminalSymbols;
    }

    public LexStream getLexStream() {
        return this;
    }

    public void lexer(PrsStream prsStream) {
        this.lexer(null, prsStream);
    }

    public void lexer(Monitor monitor, PrsStream prsStream) {
        if (this.getInputChars() == null) {
            throw new NullPointerException("LexStream was not initialized");
        }
        this.prsStream = prsStream;
        this.resetErrors();
        prsStream.makeToken(0, 0, 0);
        this.lexParser.parseCharacters(monitor);
        int i = this.getStreamIndex();
        prsStream.makeToken(i, i, 41);
        prsStream.setStreamLength(prsStream.getSize());
    }

    public ParserException.ErrorLocationInfo[] getErrors() {
        return this.errors.toArray(new ParserException.ErrorLocationInfo[this.errors.size()]);
    }

    private void resetErrors() {
        this.errors.clear();
    }

    public void reportError(int errorCode, String locationInfo, int leftToken, int rightToken, String tokenText) {
        int leftTokenLine = this.getLine(leftToken);
        int leftTokenColumn = this.getColumn(leftToken);
        int rightTokenLine = this.getEndLine(rightToken);
        int rightTokenColumn = this.getEndColumn(rightToken);
        String msg = String.valueOf(tokenText) + errorMsgText[errorCode];
        this.errors.add(new ParserException.ErrorLocationInfo(msg, leftTokenLine, leftTokenColumn, rightTokenLine, rightTokenColumn));
    }

    public void reportError(int errorCode, String locationInfo, String tokenText) {
        try {
            Matcher m = Pattern.compile("(?:[^:]+::)*[^:]+:(\\d+):(\\d+):(\\d+):(\\d+):.*").matcher(locationInfo);
            boolean t = m.matches();
            assert (t);
            int leftTokenLine = this.getLine(Integer.parseInt(m.group(1)));
            int leftTokenColumn = this.getColumn(Integer.parseInt(m.group(2)));
            int rightTokenLine = this.getEndLine(Integer.parseInt(m.group(3)));
            int rightTokenColumn = this.getEndColumn(Integer.parseInt(m.group(4)));
            String msg = String.valueOf(tokenText) + errorMsgText[errorCode];
            this.errors.add(new ParserException.ErrorLocationInfo(msg, leftTokenLine, leftTokenColumn, rightTokenLine, rightTokenColumn));
        }
        catch (Throwable throwable) {
            this.errors.add(new ParserException.ErrorLocationInfo(String.valueOf(tokenText) + errorMsgText[errorCode]));
        }
    }

    public int[] getKeywordKinds() {
        return this.kwLexer.getKeywordKinds();
    }

    public XpandLexer(String filename) throws IOException {
        this(filename, 4);
        this.kwLexer = new XpandKWLexer(this.getInputChars(), 1);
    }

    public void initialize(char[] content, String filename) {
        super.initialize(content, filename);
        if (this.kwLexer == null) {
            this.kwLexer = new XpandKWLexer(this.getInputChars(), 1);
        } else {
            this.kwLexer.setInputChars(this.getInputChars());
        }
    }

    final void makeToken(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        this.makeToken(startOffset, endOffset, kind);
    }

    final void makeComment(int kind) {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        super.getPrsStream().makeAdjunct(startOffset, endOffset, kind);
    }

    final void skipToken() {
    }

    final void checkForKeyWord() {
        int startOffset = this.getLeftSpan();
        int endOffset = this.getRightSpan();
        int kwKind = this.kwLexer.lexer(startOffset, endOffset);
        this.makeToken(startOffset, endOffset, kwKind);
    }

    public final int getKind(int i) {
        char c;
        char c2 = c = i >= this.getStreamLength() ? (char)'\uffff' : (char)this.getCharValue(i);
        return c < '\u0080' ? tokenKind[c] : (c == '\uffff' ? 104 : XpandLexer.getNonAsciiKind(c));
    }

    private static final int getNonAsciiKind(char c) {
        if (c == '\u00ab') {
            return 103;
        }
        if (c == '\u00bb') {
            return 100;
        }
        return 102;
    }

    public void ruleAction(int ruleNumber) {
        switch (ruleNumber) {
            case 1: {
                this.checkForKeyWord();
                break;
            }
            case 2: {
                this.makeToken(9);
                break;
            }
            case 3: {
                this.makeToken(9);
                break;
            }
            case 4: {
                this.makeToken(18);
                break;
            }
            case 5: {
                this.makeToken(this.getRhsFirstTokenIndex(1), this.getRhsLastTokenIndex(1), 18);
                this.makeToken(this.getRhsFirstTokenIndex(2), this.getRhsLastTokenIndex(2), 35);
                this.makeToken(this.getRhsFirstTokenIndex(3), this.getRhsLastTokenIndex(3), 1);
                break;
            }
            case 6: {
                this.makeToken(19);
                break;
            }
            case 7: {
                this.makeToken(34);
                break;
            }
            case 8: {
                this.makeToken(6);
                break;
            }
            case 9: {
                this.makeToken(29);
                break;
            }
            case 10: {
                this.makeToken(58);
                break;
            }
            case 11: {
                this.makeToken(49);
                break;
            }
            case 12: {
                this.makeToken(50);
                break;
            }
            case 13: {
                this.makeToken(8);
                break;
            }
            case 14: {
                this.makeToken(2);
                break;
            }
            case 15: {
                this.makeToken(7);
                break;
            }
            case 16: {
                this.makeToken(56);
                break;
            }
            case 17: {
                this.makeToken(57);
                break;
            }
            case 18: {
                this.makeToken(52);
                break;
            }
            case 19: {
                this.makeToken(54);
                break;
            }
            case 20: {
                this.makeToken(55);
                break;
            }
            case 21: {
                this.makeToken(53);
                break;
            }
            case 22: {
                this.makeToken(46);
                break;
            }
            case 23: {
                this.makeToken(47);
                break;
            }
            case 24: {
                this.makeToken(17);
                break;
            }
            case 25: {
                this.makeToken(32);
                break;
            }
            case 26: {
                this.makeToken(48);
                break;
            }
            case 27: {
                this.makeToken(59);
                break;
            }
            case 28: {
                this.makeToken(33);
                break;
            }
            case 29: {
                this.makeToken(30);
                break;
            }
            case 30: {
                this.makeToken(28);
                break;
            }
            case 31: {
                this.makeToken(35);
                break;
            }
            case 32: {
                this.makeToken(51);
                break;
            }
            case 33: {
                this.makeToken(45);
                break;
            }
            case 34: {
                this.skipToken();
                break;
            }
            case 35: {
                this.skipToken();
                break;
            }
            case 36: {
                this.skipToken();
                break;
            }
            case 225: {
                this.makeToken(81);
                break;
            }
            case 226: {
                this.makeToken(24);
                break;
            }
            case 236: {
                this.skipToken();
                break;
            }
        }
    }
}

