/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.migration.ui;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.OawBuilder;
import org.eclipse.gmf.internal.xpand.migration.ExpressionMigrationFacade;
import org.eclipse.gmf.internal.xpand.migration.ui.AbstractMigrationVisitor;
import org.eclipse.gmf.internal.xpand.migration.ui.BuildPropertiesManager;
import org.eclipse.gmf.internal.xpand.migration.ui.MigrationVisitor;
import org.eclipse.gmf.internal.xpand.migration.ui.ResourceCountingVisitor;
import org.eclipse.gmf.internal.xpand.util.OawMarkerManager;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateXpandProject
extends WorkspaceModifyOperation {
    private static final String DEFAULT_TEMPLATES_FOLDER = "templates";
    public static final String MIGRATED_ROOT_EXTENSION = "migrated";
    private static final String PLUGIN_CLOSING_TAG = "</plugin>";
    private static final String PLUGIN_OPENNING_TAG = "<plugin>";
    private static final String LF = ExpressionMigrationFacade.LF;
    private static final String PLUGIN_XML_CHARSET = "UTF8";
    private static final String PLUGIN_XML_FILE_NAME = "plugin.xml";
    private static final int BIG_NUMBER = 100;
    private static final String NATIVE_EXTENSIONS_SRC_FOLDER = ".qvtlib";
    private static final String NEW_BUILDER_ID = "org.eclipse.gmf.xpand.xpandBuilder";
    private static final String QVT_BUILDER_ID = "org.eclipse.m2m.qvt.oml.project.QVTOBuilder";
    private static final String QVT_BUIDLER_SRC_CONTAINER_ARG = "src_container";
    private static final String TRANSFORMATION_NATURE_ID = "org.eclipse.m2m.qvt.oml.project.QVTONature";
    private RootManager rootManager;
    private IProject selectedProject;
    private BuildPropertiesManager buildPropertiesManager;

    private static IProgressMonitor createSubProgressMonitor(IProgressMonitor monitor, String taskName, int numberOfTicks) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException("Process was canceled");
        }
        SubProgressMonitor spm = new SubProgressMonitor(monitor, numberOfTicks);
        if (taskName != null) {
            spm.setTaskName(taskName);
        }
        return spm;
    }

    public MigrateXpandProject(IProject project) {
        this.selectedProject = project;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.setTaskName("Migrating Xpand project");
        List<Object> xpandRoots = new ArrayList<IFolder>(this.getRootManager().getXpandRootFolders());
        if (xpandRoots.isEmpty()) {
            xpandRoots = Collections.singletonList(this.getSelectedProject());
        }
        monitor.beginTask("Migrating Xpand project", xpandRoots.size() + 100 * xpandRoots.size() + 4);
        int totalNumberOfSteps = 0;
        for (IContainer iContainer : xpandRoots) {
            totalNumberOfSteps += 2 + this.getNumberOfSteps(iContainer, MigrateXpandProject.createSubProgressMonitor(monitor, "Counting xpand resources in: " + iContainer.getName(), 1));
        }
        IProgressMonitor iProgressMonitor = MigrateXpandProject.createSubProgressMonitor(monitor, "Migrating all available xpand root folders", 100 * xpandRoots.size());
        iProgressMonitor.beginTask("Migrating all available xpand root folders", totalNumberOfSteps);
        ArrayList<CharSequence> nativeLibraryDeclarations = new ArrayList<CharSequence>();
        ArrayList<List<IPath>> newXpandRootEntries = new ArrayList<List<IPath>>();
        for (IContainer iContainer : xpandRoots) {
            newXpandRootEntries.add(this.migrateXpandRoot(iContainer, nativeLibraryDeclarations, iProgressMonitor));
        }
        this.registerNativeLibraries(nativeLibraryDeclarations, MigrateXpandProject.createSubProgressMonitor(monitor, "Registering native libraries", 1));
        this.switchToNewXpandBuilder(newXpandRootEntries, MigrateXpandProject.createSubProgressMonitor(monitor, "Registering new Xpand builder for the project", 1));
        this.updateXpandRootFile(newXpandRootEntries, MigrateXpandProject.createSubProgressMonitor(monitor, "Saving modified Xpand roots information", 1));
        this.getBuildPropertiesManager().save(MigrateXpandProject.createSubProgressMonitor(monitor, "Saving build.properties", 1));
        OawMarkerManager.deleteMarkers((IResource)this.getSelectedProject());
        this.buildPropertiesManager = null;
    }

    private void updateXpandRootFile(List<List<IPath>> newXpandRootEntries, IProgressMonitor monitor) throws InvocationTargetException, CoreException {
        monitor.beginTask("Saving modified Xpand roots information", 2);
        StringBuilder sb = new StringBuilder();
        for (List<IPath> rootEntry : newXpandRootEntries) {
            int i = 0;
            while (i < rootEntry.size()) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(rootEntry.get(i).toString());
                ++i;
            }
            sb.append(ExpressionMigrationFacade.LF);
        }
        monitor.worked(1);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.setTaskName("Saving Xpand root file");
        IFile xpandRootFile = this.getSelectedProject().getFile(RootManager.PROJECT_RELATIVE_PATH_TO_CONFIG_FILE);
        try {
            if (xpandRootFile.exists()) {
                xpandRootFile.setContents((InputStream)new ByteArrayInputStream(sb.toString().getBytes(xpandRootFile.getCharset())), 3, (IProgressMonitor)subMonitor);
            } else {
                xpandRootFile.create((InputStream)new ByteArrayInputStream(sb.toString().getBytes(xpandRootFile.getParent().getDefaultCharset())), true, (IProgressMonitor)subMonitor);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void switchToNewXpandBuilder(List<List<IPath>> newXpandRootEntries, IProgressMonitor monitor) throws CoreException, InterruptedException {
        monitor.beginTask("Registering new Xpand builder for the project", 2);
        IProjectDescription pd = this.getSelectedProject().getDescription();
        ArrayList<ICommand> newBuildCommands = new ArrayList<ICommand>();
        ICommand[] buildCommands = pd.getBuildSpec();
        boolean addNewXpandBuilder = true;
        boolean addQVTBuilder = true;
        int i = 0;
        while (i < buildCommands.length) {
            String builderName = buildCommands[i].getBuilderName();
            if (!OawBuilder.getBUILDER_ID().equals(builderName)) {
                if (NEW_BUILDER_ID.equals(builderName)) {
                    addNewXpandBuilder = false;
                }
                if (QVT_BUILDER_ID.equals(builderName)) {
                    addQVTBuilder = false;
                }
                newBuildCommands.add(buildCommands[i]);
            }
            ++i;
        }
        if (addQVTBuilder) {
            ICommand newCommand = pd.newCommand();
            newCommand.setBuilderName(QVT_BUILDER_ID);
            if (newXpandRootEntries.size() > 0) {
                List<IPath> firstEntry = newXpandRootEntries.get(0);
                assert (firstEntry.size() > 0);
                IPath mainIPath = firstEntry.get(0);
                if (!mainIPath.isAbsolute()) {
                    HashMap<String, String> arguments = newCommand.getArguments();
                    if (arguments == null) {
                        arguments = new HashMap<String, String>();
                    }
                    arguments.put(QVT_BUIDLER_SRC_CONTAINER_ARG, mainIPath.toString());
                    newCommand.setArguments(arguments);
                }
            }
            newBuildCommands.add(newCommand);
        }
        if (addNewXpandBuilder) {
            ICommand newCommand = pd.newCommand();
            newCommand.setBuilderName(NEW_BUILDER_ID);
            newBuildCommands.add(newCommand);
        }
        pd.setBuildSpec(newBuildCommands.toArray(new ICommand[newBuildCommands.size()]));
        ArrayList<String> newNatureIDs = new ArrayList<String>(Arrays.asList(pd.getNatureIds()));
        if (!newNatureIDs.contains(TRANSFORMATION_NATURE_ID)) {
            newNatureIDs.add(TRANSFORMATION_NATURE_ID);
            pd.setNatureIds(newNatureIDs.toArray(new String[newNatureIDs.size()]));
        }
        OawMarkerManager.deleteMarkers((IResource)this.getSelectedProject());
        monitor.worked(1);
        this.getSelectedProject().setDescription(pd, MigrateXpandProject.createSubProgressMonitor(monitor, "Saving modified project description", 1));
    }

    private void registerNativeLibraries(List<CharSequence> nativeLibraryDeclarations, IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        int insertPosition;
        if (nativeLibraryDeclarations.size() == 0) {
            progressMonitor.done();
            return;
        }
        progressMonitor.beginTask("Registering native libraries", 2);
        IFile pluginXml = this.getSelectedProject().getFile(PLUGIN_XML_FILE_NAME);
        StringBuilder pluginXmlContent = new StringBuilder();
        if (pluginXml.exists()) {
            BufferedInputStream is = new BufferedInputStream(pluginXml.getContents());
            try {
                int ch = ((InputStream)is).read();
                while (ch != -1) {
                    if (progressMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    pluginXmlContent.append((char)ch);
                    ch = ((InputStream)is).read();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            insertPosition = pluginXmlContent.lastIndexOf(PLUGIN_CLOSING_TAG);
            if (insertPosition < 0) {
                throw new InvocationTargetException(new Exception("Incorrect plugin.xml file - </plugin> tag was not found"));
            }
        } else {
            pluginXmlContent.append(PLUGIN_OPENNING_TAG);
            pluginXmlContent.append(LF);
            insertPosition = pluginXmlContent.length();
            pluginXmlContent.append(PLUGIN_CLOSING_TAG);
        }
        progressMonitor.worked(1);
        pluginXmlContent.insert(insertPosition, this.getNativeLibraryExtensionPoint(nativeLibraryDeclarations));
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pluginXmlContent.toString().getBytes(PLUGIN_XML_CHARSET));
            IProgressMonitor subProgressMonitor = MigrateXpandProject.createSubProgressMonitor(progressMonitor, "Saving new plugin.xmlcontent", 1);
            if (pluginXml.exists()) {
                pluginXml.setContents((InputStream)inputStream, 3, subProgressMonitor);
            } else {
                pluginXml.create((InputStream)inputStream, true, subProgressMonitor);
                this.getBuildPropertiesManager().addBinInclude((IResource)pluginXml);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InvocationTargetException(e);
        }
    }

    private StringBuilder getNativeLibraryExtensionPoint(List<CharSequence> nativeLibraryDeclarations) {
        StringBuilder result = new StringBuilder("\t<extension point=\"org.eclipse.m2m.qvt.oml.javaBlackboxUnits\">");
        result.append(LF);
        for (CharSequence declaration : nativeLibraryDeclarations) {
            result.append("\t\t");
            result.append(declaration);
        }
        result.append("\t</extension>");
        return result.append(LF);
    }

    private List<IPath> migrateXpandRoot(IContainer rootContainer, List<CharSequence> nativeLibraryDeclarations, IProgressMonitor progressMonitor) throws InterruptedException, CoreException, InvocationTargetException {
        IFolder templatesOutputFolder = this.getTemplatesOutputFolder(rootContainer, MigrateXpandProject.createSubProgressMonitor(progressMonitor, "Calculating new templates root folder name", 1));
        IFolder nativeExtensionsRoot = this.getNativeExtensionsSourceRoot(rootContainer, MigrateXpandProject.createSubProgressMonitor(progressMonitor, "Creating new source rolot for native extensions", 1));
        MigrationVisitor visitor = new MigrationVisitor(rootContainer, templatesOutputFolder, nativeExtensionsRoot, this.getSelectedProject(), this.getRootManager(), this.getBuildPropertiesManager(), progressMonitor);
        this.acceptVisitor((IResource)rootContainer, visitor);
        visitor.done();
        nativeLibraryDeclarations.addAll(visitor.getNativeLibraryDeclarations());
        this.getBuildPropertiesManager().addBinInclude((IResource)templatesOutputFolder);
        return this.getRootManager().getMigratedXpandRootEntry(rootContainer, templatesOutputFolder);
    }

    private int getNumberOfSteps(IContainer rootContainer, IProgressMonitor progressMonitor) throws CoreException, InterruptedException, InvocationTargetException {
        progressMonitor.beginTask("Counting xpand resources in: " + rootContainer.getName(), 1);
        ResourceCountingVisitor counter = new ResourceCountingVisitor(progressMonitor);
        this.acceptVisitor((IResource)rootContainer, counter);
        progressMonitor.done();
        return counter.getNumberOfSteps();
    }

    private void acceptVisitor(IResource resource, AbstractMigrationVisitor visitor) throws InterruptedException, CoreException, InvocationTargetException {
        try {
            resource.accept((IResourceVisitor)visitor);
        }
        catch (CoreException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw (InterruptedException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new InvocationTargetException(e.getCause());
            }
            throw e;
        }
    }

    private IFolder getTemplatesOutputFolder(IContainer rootContainer, IProgressMonitor progressMonitor) {
        Path relativePathBasis;
        IContainer parent;
        assert (rootContainer instanceof IFolder || rootContainer instanceof IProject);
        progressMonitor.beginTask("Calculating new templates root folder name", 1);
        if (rootContainer instanceof IFolder) {
            parent = rootContainer.getParent();
            relativePathBasis = rootContainer.getProjectRelativePath().removeFirstSegments(parent.getProjectRelativePath().segmentCount());
        } else {
            parent = rootContainer;
            relativePathBasis = new Path(DEFAULT_TEMPLATES_FOLDER);
        }
        IPath relativePath = relativePathBasis.addFileExtension(MIGRATED_ROOT_EXTENSION);
        int i = 1;
        while (parent.getFolder(relativePath).exists()) {
            relativePath = relativePathBasis.addFileExtension(MIGRATED_ROOT_EXTENSION + i);
            ++i;
        }
        progressMonitor.done();
        return parent.getFolder(relativePath);
    }

    private IFolder getNativeExtensionsSourceRoot(IContainer rootContainer, IProgressMonitor progressMonitor) throws CoreException, InterruptedException {
        assert (rootContainer instanceof IFolder || rootContainer instanceof IProject);
        progressMonitor.beginTask("Calculating source root for native extensions", 1);
        String baseFolderName = rootContainer instanceof IFolder ? rootContainer.getName() : DEFAULT_TEMPLATES_FOLDER;
        String folderName = String.valueOf(baseFolderName) + NATIVE_EXTENSIONS_SRC_FOLDER;
        int i = 1;
        while (this.getSelectedProject().getFolder(folderName).exists()) {
            folderName = String.valueOf(baseFolderName) + NATIVE_EXTENSIONS_SRC_FOLDER + i;
            ++i;
        }
        progressMonitor.done();
        return this.getSelectedProject().getFolder(folderName);
    }

    private IProject getSelectedProject() {
        return this.selectedProject;
    }

    private RootManager getRootManager() {
        if (this.rootManager == null) {
            this.rootManager = new RootManager(this.getSelectedProject());
        }
        return this.rootManager;
    }

    private BuildPropertiesManager getBuildPropertiesManager() {
        if (this.buildPropertiesManager == null) {
            this.buildPropertiesManager = new BuildPropertiesManager(this.getSelectedProject());
        }
        return this.buildPropertiesManager;
    }
}

