/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.ast.Advice;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandAdvice;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;
import org.eclipse.gmf.internal.xpand.util.DefinitionSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeXpandResource
implements XpandResource {
    private final XpandResource[] myDefinitions;
    private final XpandResource[] myAdvices;
    private XpandAdvice[] myCachedAdvices;
    private XpandDefinition[] myCachedDefinitions;
    private String[] myImportedNamespaces;
    private String[] myImportedExtensions;
    private static final XpandResource[] NO_RESOURCES = new XpandResource[0];
    private static final Advice[] NO_ADVICE = new Advice[0];

    public CompositeXpandResource(ResourceManager manager, XpandResource[] definitions, XpandResource[] advices) {
        this.myDefinitions = definitions;
        this.myAdvices = advices == null ? NO_RESOURCES : advices;
        ArrayList<XpandDefinition> allDefinitions = new ArrayList<XpandDefinition>();
        HashSet<DefinitionSignature> signatures = new HashSet<DefinitionSignature>();
        XpandExecutionContext context = ContextFactory.createXpandContext(manager);
        this.mergeDefinitions(context, this.myAdvices, allDefinitions, signatures);
        this.mergeDefinitions(context, this.myDefinitions, allDefinitions, signatures);
        this.myCachedDefinitions = allDefinitions.toArray(new XpandDefinition[allDefinitions.size()]);
        if (advices != null) {
            ArrayList<XpandAdvice> allAdvices = new ArrayList<XpandAdvice>();
            this.collectAdvices(this.myAdvices, allAdvices);
            this.myCachedAdvices = allAdvices.toArray(new XpandAdvice[allAdvices.size()]);
        } else {
            this.myCachedAdvices = NO_ADVICE;
        }
    }

    public XpandResource getFirstDefinition() {
        return this.myDefinitions.length == 0 ? null : this.myDefinitions[0];
    }

    private void mergeDefinitions(XpandExecutionContext context, XpandResource[] resources, List<XpandDefinition> collector, Set<DefinitionSignature> usedSignatures) {
        int i = 0;
        while (i < resources.length) {
            XpandDefinition[] definitions;
            XpandResource nextResource = resources[i];
            context = (XpandExecutionContext)context.cloneWithResource(nextResource);
            XpandDefinition[] xpandDefinitionArray = definitions = nextResource.getDefinitions();
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                XpandDefinition nextDefinition = xpandDefinitionArray[n2];
                DefinitionSignature signature = DefinitionSignature.create((ExecutionContext)context, nextDefinition);
                if (signature != null && !usedSignatures.contains(signature)) {
                    usedSignatures.add(signature);
                    collector.add(nextDefinition);
                }
                ++n2;
            }
            ++i;
        }
    }

    private void collectAdvices(XpandResource[] resources, List<XpandAdvice> collector) {
        int i = resources.length - 1;
        while (i >= 0) {
            XpandAdvice[] advices;
            XpandResource nextResource = resources[i];
            XpandAdvice[] xpandAdviceArray = advices = nextResource.getAdvices();
            int n = advices.length;
            int n2 = 0;
            while (n2 < n) {
                XpandAdvice nextAdvice = xpandAdviceArray[n2];
                collector.add(nextAdvice);
                ++n2;
            }
            --i;
        }
    }

    @Override
    public XpandAdvice[] getAdvices() {
        return this.myCachedAdvices;
    }

    @Override
    public XpandDefinition[] getDefinitions() {
        return this.myCachedDefinitions;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.myDefinitions[0].getFullyQualifiedName();
    }

    @Override
    public String[] getImportedExtensions() {
        if (this.myImportedExtensions == null) {
            String nextImport;
            int n;
            int n2;
            String[] stringArray;
            XpandResource nextResource;
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            XpandResource[] xpandResourceArray = this.myDefinitions;
            int n3 = this.myDefinitions.length;
            int n4 = 0;
            while (n4 < n3) {
                nextResource = xpandResourceArray[n4];
                stringArray = nextResource.getImportedExtensions();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    nextImport = stringArray[n];
                    result.add(nextImport);
                    ++n;
                }
                ++n4;
            }
            xpandResourceArray = this.myAdvices;
            n3 = this.myAdvices.length;
            n4 = 0;
            while (n4 < n3) {
                nextResource = xpandResourceArray[n4];
                stringArray = nextResource.getImportedExtensions();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    nextImport = stringArray[n];
                    result.add(nextImport);
                    ++n;
                }
                ++n4;
            }
            this.myImportedExtensions = result.toArray(new String[result.size()]);
        }
        return this.myImportedExtensions;
    }

    @Override
    public String[] getImportedNamespaces() {
        if (this.myImportedNamespaces == null) {
            String nextImport;
            int n;
            int n2;
            String[] stringArray;
            XpandResource nextResource;
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            XpandResource[] xpandResourceArray = this.myDefinitions;
            int n3 = this.myDefinitions.length;
            int n4 = 0;
            while (n4 < n3) {
                nextResource = xpandResourceArray[n4];
                stringArray = nextResource.getImportedNamespaces();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    nextImport = stringArray[n];
                    result.add(nextImport);
                    ++n;
                }
                ++n4;
            }
            xpandResourceArray = this.myAdvices;
            n3 = this.myAdvices.length;
            n4 = 0;
            while (n4 < n3) {
                nextResource = xpandResourceArray[n4];
                stringArray = nextResource.getImportedNamespaces();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    nextImport = stringArray[n];
                    result.add(nextImport);
                    ++n;
                }
                ++n4;
            }
            this.myImportedNamespaces = result.toArray(new String[result.size()]);
        }
        return this.myImportedNamespaces;
    }

    @Override
    public void analyze(XpandExecutionContext ctx, Set<AnalysationIssue> issues) {
        XpandResource next;
        XpandResource[] xpandResourceArray = this.myDefinitions;
        int n = this.myDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            next = xpandResourceArray[n2];
            next.analyze(ctx, issues);
            ++n2;
        }
        xpandResourceArray = this.myAdvices;
        n = this.myAdvices.length;
        n2 = 0;
        while (n2 < n) {
            next = xpandResourceArray[n2];
            next.analyze(ctx, issues);
            ++n2;
        }
    }
}

