/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.xpand;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.BundleUnitResolver;

public class TestsResourceManager
extends ResourceManagerImpl
implements ResourceManager {
    private InputStream loadFile(String fullyQualifiedName, String fileExt) {
        String resName = String.valueOf(fullyQualifiedName.replaceAll("::", "/")) + "." + fileExt;
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resName);
    }

    protected void handleParserException(ParserException ex) {
        ex.printStackTrace();
    }

    protected Reader[] resolveMultiple(String fullyQualifiedName, String extension) throws IOException {
        InputStream inputStream = this.loadFile(fullyQualifiedName, extension);
        if (inputStream == null) {
            throw new FileNotFoundException(fullyQualifiedName);
        }
        return new Reader[]{new InputStreamReader(inputStream, Charset.forName("ISO-8859-1"))};
    }

    protected boolean shouldCache() {
        return false;
    }

    protected String resolveCFileFullPath(String fullyQualifiedName, String fileExtension) {
        return String.valueOf(fullyQualifiedName) + "." + fileExtension;
    }

    protected UnitResolver getQVTUnitResolver() {
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(".");
        return BundleUnitResolver.createResolver(Collections.singletonList(resource), (boolean)true);
    }
}

