/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.edit.parts.decorations;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.lite.edit.parts.decorations.AbstractDecorationManager;

public class ConnectionDecorationManager
extends AbstractDecorationManager {
    public ConnectionDecorationManager(Connection decorationParent) {
        super((IFigure)decorationParent);
    }

    protected Object getConstraint(String key, IFigure decoration) {
        return new DecorationLocator(this.getDecorationPosition(key));
    }

    protected DecorationPosition getDecorationPosition(String key) {
        return DecorationPosition.CENTER;
    }

    private class DecorationLocator
    implements Locator {
        private final DecorationPosition myPosition;

        public DecorationLocator(DecorationPosition position) {
            this.myPosition = position;
        }

        public void relocate(IFigure target) {
            Point pt;
            Dimension size = target.getPreferredSize();
            Connection connection = (Connection)ConnectionDecorationManager.this.getDecorationParent();
            switch (this.myPosition) {
                case SOURCE: {
                    pt = connection.getPoints().getFirstPoint();
                    break;
                }
                case CENTER: {
                    pt = connection.getPoints().getMidpoint();
                    break;
                }
                case TARGET: {
                    pt = connection.getPoints().getLastPoint();
                    break;
                }
                default: {
                    pt = connection.getPoints().getMidpoint();
                }
            }
            target.setBounds(new Rectangle(pt, size));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DecorationPosition {
        SOURCE,
        CENTER,
        TARGET;

    }
}

