/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.AbstractDeleteFromAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteFromModelAction
extends AbstractDeleteFromAction {
    public DeleteFromModelAction(IWorkbenchPart part) {
        super(part);
    }

    public DeleteFromModelAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    protected boolean calculateEnabled() {
        List operationSet = this.getOperationSet();
        if (operationSet.isEmpty()) {
            return false;
        }
        Request request = this.getTargetRequest();
        for (EditPart editPart : operationSet) {
            if (editPart instanceof IGraphicalEditPart) {
                IGraphicalEditPart gEditPart = (IGraphicalEditPart)editPart;
                if (!gEditPart.isEditModeEnabled()) {
                    return false;
                }
                View view = (View)gEditPart.getModel();
                EObject container = view.eContainer();
                EObject element = ViewUtil.resolveSemanticElement((View)view);
                if (element != null && !element.eIsProxy() && !(element instanceof Diagram) && (!(view instanceof Diagram) || container != null && container instanceof View)) continue;
                return false;
            }
            Command curCommand = editPart.getCommand(request);
            if (curCommand != null && curCommand.canExecute()) continue;
            return false;
        }
        return true;
    }

    public void init() {
        super.init();
        this.setId("deleteFromModelAction");
        this.setText(DiagramUIMessages.DiagramEditor_Delete_from_Model);
        this.setToolTipText(DiagramUIMessages.DiagramEditor_Delete_from_ModelToolTip);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
    }

    protected Command getCommand(Request request) {
        List operationSet = this.getOperationSet();
        Iterator editParts = operationSet.iterator();
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(this.getEditingDomain(), this.getCommandLabel());
        while (editParts.hasNext()) {
            Command curCommand;
            EditPart editPart = (EditPart)editParts.next();
            if (editPart instanceof IGraphicalEditPart) {
                IGraphicalEditPart gEditPart = (IGraphicalEditPart)editPart;
                View view = (View)gEditPart.getModel();
                EObject container = view.eContainer();
                EObject element = ViewUtil.resolveSemanticElement((View)view);
                if (element instanceof Diagram || view instanceof Diagram && (container == null || !(container instanceof View))) {
                    return null;
                }
            }
            if ((curCommand = editPart.getCommand(request)) == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty() || command.size() != operationSet.size()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    protected String getCommandLabel() {
        return DiagramUIMessages.DiagramEditor_Delete_from_Model;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        Command command = this.getCommand();
        if (command == null || !command.canExecute()) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIMessages.DeleteFromModelAction_ErrorDialog_Title, (String)DiagramUIMessages.DeleteFromModelAction_ErrorDialog_Text);
        }
        this.execute(this.getCommand(), progressMonitor);
    }
}

