/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui;

import java.lang.ref.WeakReference;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DiagramEventBrokerThreadSafe
extends DiagramEventBroker {
    WeakReference editingDomainRef;

    public DiagramEventBrokerThreadSafe(TransactionalEditingDomain editingDomain) {
        this.editingDomainRef = new WeakReference<TransactionalEditingDomain>(editingDomain);
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.shouldSynchronizeWithMainThread(event)) {
            final ResourceSetChangeEvent eventToHandle = event;
            TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)this.editingDomainRef.get();
            if (editingDomain != null) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)editingDomain.createPrivilegedRunnable(new Runnable(){

                    public void run() {
                        DiagramEventBrokerThreadSafe.this.internal_resourceSetChanged(eventToHandle);
                    }
                }));
                return;
            }
        }
        super.resourceSetChanged(event);
    }

    private boolean shouldSynchronizeWithMainThread(ResourceSetChangeEvent event) {
        return Display.getCurrent() == null;
    }

    private void internal_resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
    }
}

