/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterState;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.JPSOptionsDialog;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintDestination;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

class PrinterBlock
extends DialogBlock {
    private final DataBindingContext bindings;
    private final PrintOptions options;
    private List<PrintDestination> destinations = new ArrayList<PrintDestination>();
    private ComboViewer combo;
    private Label resultStatusLabel;
    private Label resultTypeLabel;
    private Label resultWhereLabel;
    private Label resultCommentLabel;

    PrinterBlock(DialogBlock.IDialogUnitConverter dluConverter, DataBindingContext bindings, PrintOptions options) {
        super(dluConverter);
        this.bindings = bindings;
        this.options = options;
    }

    public Control createContents(Composite parent) {
        Realm realm = this.bindings.getValidationRealm();
        Group result = this.group(parent, DiagramUIPrintingMessages.JPSPrintDialog_Printer);
        PrinterBlock.layout((Composite)result, 3);
        this.label((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_Name);
        this.combo = this.combo((Composite)result);
        this.layoutFillHorizontal(this.combo.getControl());
        Button propertiesButton = this.button((Composite)result, DiagramUIPrintingMessages.JPSPrintDialog_Properties);
        propertiesButton.setEnabled(true);
        propertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrinterBlock.this.openPrintOptionsDialog();
            }
        });
        IObservableValue destination = BeansObservables.observeValue((Realm)realm, (Object)this.options, (String)PrintOptions.PROPERTY_DESTINATION);
        this.bindings.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.combo), destination, null, null);
        this.init();
        return result;
    }

    private void handlePrinterSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        PrintDestination destination;
        StructuredSelection selection = (StructuredSelection)selectionChangedEvent.getSelection();
        if (selection != null && (destination = (PrintDestination)selection.getFirstElement()) != null) {
            String printerName = destination.getName();
            HashPrintServiceAttributeSet attributes = new HashPrintServiceAttributeSet(new PrinterName(printerName, Locale.getDefault()));
            PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, attributes);
            PrintService printService = services[0];
            PrintServiceAttributeSet printServiceAttributes = printService.getAttributes();
            PrinterState printerState = (PrinterState)printServiceAttributes.get(PrinterState.class);
            PrinterLocation printerLocation = (PrinterLocation)printServiceAttributes.get(PrinterLocation.class);
            PrinterMakeAndModel printerMakeAndModel = (PrinterMakeAndModel)printServiceAttributes.get(PrinterMakeAndModel.class);
            PrinterMessageFromOperator printerComment = (PrinterMessageFromOperator)printServiceAttributes.get(PrinterMessageFromOperator.class);
            if (printerState != null) {
                this.resultStatusLabel.setText(printerState.getName());
            }
            if (printerLocation != null) {
                this.resultWhereLabel.setText(printerLocation.getName());
            }
            if (printerComment != null) {
                this.resultCommentLabel.setText(printerComment.getName());
            }
            if (printerMakeAndModel != null) {
                this.resultTypeLabel.setText(printerMakeAndModel.getName());
            }
        }
    }

    private void init() {
        PrintService[] printServices = PrintServiceLookup.lookupPrintServices(null, null);
        PrintService defaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService[] printServiceArray = printServices;
        int n = printServices.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printService = printServiceArray[n2];
            this.destinations.add(new PrintDestination(printService.getName()));
            ++n2;
        }
        PrintDestination defaultPrintDestination = this.getPrinterByName(defaultPrintService.getName());
        this.combo.setContentProvider((IContentProvider)new PrinterContentProvider());
        this.combo.setLabelProvider((IBaseLabelProvider)new PrinterLabelProvider());
        this.initializePrinterCombo(defaultPrintDestination);
    }

    private void initializePrinterCombo(PrintDestination selection) {
        this.combo.setInput(this.destinations);
        this.combo.setSelection((ISelection)new StructuredSelection((Object)selection));
    }

    private PrintDestination getPrinterByName(String name) {
        PrintDestination result = null;
        for (PrintDestination printDestination : this.destinations) {
            if (!printDestination.getName().equals(name)) continue;
            result = printDestination;
            break;
        }
        return result;
    }

    private void openPrintOptionsDialog() {
        JPSOptionsDialog dlg = new JPSOptionsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.bindings, this.options);
        dlg.open();
    }

    public void dispose() {
    }

    private class PrinterContentProvider
    implements IStructuredContentProvider {
        private PrinterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return PrinterBlock.this.destinations.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class PrinterLabelProvider
    extends LabelProvider {
        private PrinterLabelProvider() {
        }

        public String getText(Object element) {
            return ((PrintDestination)element).getName();
        }
    }
}

