/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;

public class GeoShape3DRectangleFigure
extends GeoShapeFigure
implements IPolygonAnchorableFigure {
    public GeoShape3DRectangleFigure(int width, int height, int spacing) {
        super(width, height, spacing);
    }

    protected void paintFigure(Graphics g) {
        List points = this.computePoints(this.getBounds());
        PointList outline = new PointList();
        int index = 0;
        while (index < 6) {
            outline.addPoint((Point)points.get(index));
            ++index;
        }
        Point p2 = (Point)points.get(1);
        Point p4 = (Point)points.get(3);
        Point p6 = (Point)points.get(5);
        Point p7 = (Point)points.get(6);
        g.fillPolygon(outline);
        g.setLineStyle(this.getLineStyle());
        g.setLineWidth(this.getLineWidth());
        g.drawPolygon(outline);
        g.drawLine(p6, p7);
        g.drawLine(p7, p4);
        g.drawLine(p7, p2);
    }

    private List computePoints(Rectangle rect) {
        ArrayList<Point> toReturn = new ArrayList<Point>();
        int scaleWidth = (int)((double)rect.width * 0.25);
        int scaleHeight = (int)((double)rect.height * 0.25);
        Rectangle r1 = new Rectangle(rect.x, rect.y, rect.width - scaleWidth, rect.height - scaleHeight);
        Rectangle r2 = new Rectangle(r1.x + scaleWidth, r1.y + scaleHeight, r1.width, r1.height);
        Point p1 = new Point(r1.x, r1.y);
        Point p2 = new Point(r1.x + r1.width, r1.y);
        Point p3 = new Point(r2.x + r2.width - 1, r2.y);
        Point p4 = new Point(p3.x, r2.y + r2.height - 1);
        Point p5 = new Point(r2.x, p4.y);
        Point p6 = new Point(r1.x, r1.y + r1.height);
        Point p7 = new Point(p2.x, p6.y);
        toReturn.add(p1);
        toReturn.add(p2);
        toReturn.add(p3);
        toReturn.add(p4);
        toReturn.add(p5);
        toReturn.add(p6);
        toReturn.add(p7);
        return toReturn;
    }

    public PointList getPolygonPoints() {
        List points = this.computePoints(this.getBounds());
        PointList outline = new PointList();
        int index = 0;
        while (index < 6) {
            outline.addPoint((Point)points.get(index));
            ++index;
        }
        outline.addPoint((Point)points.get(0));
        return outline;
    }
}

