/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.map.editor.part.GMFMapVisualIDRegistry;
import org.eclipse.gmf.map.editor.providers.GMFMapElementTypes;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class MappingCanonicalEditPolicy
extends CanonicalConnectionEditPolicy {
    private Collection myLinkDescriptors = new LinkedList();
    private Map myEObject2ViewMap = new HashMap();

    protected List getSemanticChildrenList() {
        CanvasMapping nextValue2;
        LinkedList<CanvasMapping> result = new LinkedList<CanvasMapping>();
        EObject modelObject = ((View)this.getHost().getModel()).getElement();
        View viewObject = (View)this.getHost().getModel();
        int nodeVID = GMFMapVisualIDRegistry.getNodeVisualID(viewObject, (EObject)(nextValue2 = ((Mapping)modelObject).getDiagram()));
        if (2001 == nodeVID) {
            result.add(nextValue2);
        }
        for (CanvasMapping nextValue2 : ((Mapping)modelObject).getLinks()) {
            nodeVID = GMFMapVisualIDRegistry.getNodeVisualID(viewObject, (EObject)nextValue2);
            if (2002 != nodeVID) continue;
            result.add(nextValue2);
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return view.isSetElement() && view.getElement() != null && view.getElement().eIsProxy();
    }

    protected String getDefaultFactoryHint() {
        return null;
    }

    protected List getSemanticConnectionsList() {
        return Collections.EMPTY_LIST;
    }

    protected EObject getSourceElement(EObject relationship) {
        return null;
    }

    protected EObject getTargetElement(EObject relationship) {
        return null;
    }

    protected boolean shouldIncludeConnection(Edge connector, Collection children) {
        return false;
    }

    protected void refreshSemantic() {
        LinkedList createdViews = new LinkedList();
        createdViews.addAll(this.refreshSemanticChildren());
        createdViews.addAll(this.refreshPhantoms());
        LinkedList createdConnectionViews = new LinkedList();
        createdConnectionViews.addAll(this.refreshSemanticConnections());
        createdConnectionViews.addAll(this.refreshConnections());
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Collection refreshPhantoms() {
        LinkedList<EObject> phantomNodes = new LinkedList<EObject>();
        EObject diagramModelObject = ((View)this.getHost().getModel()).getElement();
        Diagram diagram = this.getDiagram();
        Resource resource = diagramModelObject.eResource();
        for (EObject nextResourceObject : resource.getContents()) {
            if (nextResourceObject == diagramModelObject) continue;
            int nodeVID = GMFMapVisualIDRegistry.getNodeVisualID((View)diagram, nextResourceObject);
            switch (nodeVID) {
                case 2003: {
                    phantomNodes.add(nextResourceObject);
                }
            }
        }
        for (View nextView : this.getDiagram().getChildren()) {
            EObject nextViewElement = nextView.getElement();
            if (!phantomNodes.contains(nextViewElement)) continue;
            phantomNodes.remove(nextViewElement);
        }
        return this.createPhantomNodes(phantomNodes);
    }

    private Collection createPhantomNodes(Collection nodes) {
        CreateViewRequest request;
        if (nodes.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CreateViewRequest.ViewDescriptor> descriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (EObject element : nodes) {
            CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor(element);
            descriptors.add(descriptor);
        }
        Diagram diagram = this.getDiagram();
        EditPart diagramEditPart = this.getDiagramEditPart();
        Command cmd = diagramEditPart.getCommand((Request)(request = this.getCreateViewRequest(descriptors)));
        if (cmd == null) {
            CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
            for (CreateViewRequest.ViewDescriptor descriptor : descriptors) {
                CreateCommand createCommand = new CreateCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), descriptor, (View)diagram);
                cc.compose((IUndoableOperation)createCommand);
            }
            cmd = new ICommandProxy((ICommand)cc);
        }
        List adapters = Collections.EMPTY_LIST;
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)diagramEditPart).getNotationView())).execute();
            this.executeCommand(cmd);
            adapters = (List)request.getNewObject();
        }
        diagramEditPart.refresh();
        return adapters;
    }

    private EditPart getDiagramEditPart() {
        return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(this.getDiagram());
    }

    private Collection refreshConnections() {
        try {
            this.collectAllLinks((View)this.getDiagram());
            LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
            Iterator diagramLinks = existingLinks.iterator();
            while (diagramLinks.hasNext()) {
                Edge nextDiagramLink = (Edge)diagramLinks.next();
                EObject diagramLinkObject = nextDiagramLink.getElement();
                EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
                EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
                int diagramLinkVisualID = GMFMapVisualIDRegistry.getVisualID((View)nextDiagramLink);
                Iterator modelLinkDescriptors = this.myLinkDescriptors.iterator();
                while (modelLinkDescriptors.hasNext()) {
                    LinkDescriptor nextLinkDescriptor = (LinkDescriptor)modelLinkDescriptors.next();
                    if (diagramLinkObject != nextLinkDescriptor.getLinkElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                    diagramLinks.remove();
                    modelLinkDescriptors.remove();
                }
            }
            this.deleteViews(existingLinks.iterator());
            Collection collection = this.createConnections(this.myLinkDescriptors);
            return collection;
        }
        finally {
            this.myLinkDescriptors.clear();
            this.myEObject2ViewMap.clear();
        }
    }

    private void collectAllLinks(View view) {
        EObject modelElement = view.getElement();
        int diagramElementVisualID = GMFMapVisualIDRegistry.getVisualID(view);
        switch (diagramElementVisualID) {
            case 1000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 3001: 
            case 3002: 
            case 3003: 
            case 3004: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: {
                this.myEObject2ViewMap.put(modelElement, view);
                this.storeLinks(modelElement, this.getDiagram());
            }
        }
        for (View childView : view.getChildren()) {
            this.collectAllLinks(childView);
        }
    }

    private Collection createConnections(Collection linkDescriptors) {
        if (linkDescriptors.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (LinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPartFor(nextLinkDescriptor.getSource());
            EditPart targetEditPart = this.getEditPartFor(nextLinkDescriptor.getDestination());
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), null, -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPartFor(EObject modelElement) {
        View view = (View)this.myEObject2ViewMap.get(modelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    private void storeLinks(EObject container, Diagram diagram) {
        EClass containerMetaclass = container.eClass();
        this.storeFeatureModelFacetLinks(container, containerMetaclass, diagram);
        this.storeTypeModelFacetLinks(container, containerMetaclass);
    }

    private void storeTypeModelFacetLinks(EObject container, EClass containerMetaclass) {
    }

    private void storeFeatureModelFacetLinks(EObject container, EClass containerMetaclass, Diagram diagram) {
        NodeMapping nextDestination;
        if (GMFMapPackage.eINSTANCE.getTopNodeReference().isSuperTypeOf(containerMetaclass) && 2003 == GMFMapVisualIDRegistry.getNodeVisualID((View)diagram, (EObject)(nextDestination = ((TopNodeReference)container).getOwnedChild()))) {
            this.myLinkDescriptors.add(new LinkDescriptor(container, (EObject)nextDestination, GMFMapElementTypes.TopNodeReferenceOwnedChild_4001, 4001));
        }
        if (GMFMapPackage.eINSTANCE.getChildReference().isSuperTypeOf(containerMetaclass) && 2003 == GMFMapVisualIDRegistry.getNodeVisualID((View)diagram, (EObject)(nextDestination = ((ChildReference)container).getOwnedChild()))) {
            this.myLinkDescriptors.add(new LinkDescriptor(container, (EObject)nextDestination, GMFMapElementTypes.ChildReferenceOwnedChild_4004, 4004));
        }
        if (GMFMapPackage.eINSTANCE.getChildReference().isSuperTypeOf(containerMetaclass)) {
            nextDestination = ((ChildReference)container).getReferencedChild();
            this.myLinkDescriptors.add(new LinkDescriptor(container, (EObject)nextDestination, GMFMapElementTypes.ChildReferenceReferencedChild_4002, 4002));
        }
        if (GMFMapPackage.eINSTANCE.getCompartmentMapping().isSuperTypeOf(containerMetaclass)) {
            for (EObject nextDestination2 : ((CompartmentMapping)container).getChildren()) {
                this.myLinkDescriptors.add(new LinkDescriptor(container, nextDestination2, GMFMapElementTypes.CompartmentMappingChildren_4003, 4003));
            }
        }
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private class LinkDescriptor {
        private EObject mySource;
        private EObject myDestination;
        private EObject myLinkElement;
        private int myVisualID;
        private IAdaptable mySemanticAdapter;

        protected LinkDescriptor(EObject source, EObject destination, EObject linkElement, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = linkElement;
            this.mySemanticAdapter = new EObjectAdapter(linkElement);
        }

        protected LinkDescriptor(EObject source, EObject destination, IElementType elementType, int linkVID) {
            this(source, destination, linkVID);
            this.myLinkElement = null;
            final IElementType elementTypeCopy = elementType;
            this.mySemanticAdapter = new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (IElementType.class.equals((Object)adapter)) {
                        return elementTypeCopy;
                    }
                    return null;
                }
            };
        }

        private LinkDescriptor(EObject source, EObject destination, int linkVID) {
            this.mySource = source;
            this.myDestination = destination;
            this.myVisualID = linkVID;
        }

        protected EObject getSource() {
            return this.mySource;
        }

        protected EObject getDestination() {
            return this.myDestination;
        }

        protected EObject getLinkElement() {
            return this.myLinkElement;
        }

        protected int getVisualID() {
            return this.myVisualID;
        }

        protected IAdaptable getSemanticAdapter() {
            return this.mySemanticAdapter;
        }
    }
}

