/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.properties.PropertyMerger;
import org.eclipse.gmf.internal.common.codegen.ManifestFileMerge;
import org.eclipse.gmf.internal.common.codegen.PluginXMLTextMerger;
import org.eclipse.gmf.internal.common.codegen.TaggedTextMerger;
import org.eclipse.gmf.internal.common.codegen.TextMerger;

public class DefaultTextMerger
extends TextMerger {
    protected static final String TAG = "gmf generator persistent region";
    protected static final String BEGIN_TAG = "gmf generator persistent region begin";
    protected static final String END_TAG = "gmf generator persistent region end";
    private final JControlModel myControlModel;
    private final TaggedTextMerger myXmlMerger;
    private final PluginXMLTextMerger myPluginXmlMerger;
    private final ManifestFileMerge myManifestMerge;

    public DefaultTextMerger(JControlModel jModel) {
        assert (jModel != null);
        this.myControlModel = jModel;
        this.myXmlMerger = new TaggedTextMerger("<!-- gmf generator persistent region begin -->", "<!-- gmf generator persistent region end -->");
        this.myPluginXmlMerger = new PluginXMLTextMerger("gmfgen", "generated", "true");
        this.myManifestMerge = new ManifestFileMerge();
    }

    public String mergeJava(String oldText, String newText) {
        if (this.getJControlModel() == null || !this.getJControlModel().canMerge()) {
            return super.mergeJava(oldText, newText);
        }
        JMerger jMerge = new JMerger(this.getJControlModel());
        jMerge.setSourceCompilationUnit(jMerge.createCompilationUnitForContents(newText));
        jMerge.setTargetCompilationUnit(jMerge.createCompilationUnitForContents(oldText));
        jMerge.merge();
        return jMerge.getTargetCompilationUnitContents();
    }

    public String mergeProperties(String oldText, String newText) {
        PropertyMerger propertyMerger = new PropertyMerger();
        propertyMerger.setSourceProperties(newText);
        propertyMerger.setTargetProperties(oldText);
        propertyMerger.merge();
        return propertyMerger.getTargetProperties();
    }

    public String mergeXML(String oldText, String newText) {
        return this.myXmlMerger.process(oldText, newText);
    }

    public String mergePluginXML(String oldText, String newText) {
        if (this.myPluginXmlMerger.isRecognizedDocument(oldText)) {
            return this.myPluginXmlMerger.process(oldText, newText);
        }
        return this.mergeXML(oldText, newText);
    }

    public String mergeManifestMF(String oldText, String newText) {
        return this.myManifestMerge.process(oldText, newText);
    }

    private JControlModel getJControlModel() {
        return this.myControlModel;
    }
}

