/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.util.Generator;
import org.eclipse.gmf.internal.bridge.transform.ValidationHelper;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.internal.codegen.popup.actions.DiagnosticsDialog;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.internal.common.migrate.ModelLoadHelper;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class ExecuteTemplatesOperation {
    private static final String ASK_OK = "ask_ok";
    private String name;
    private Shell shell;
    private URI genModelURI;
    private GenEditorGenerator myGenModel;

    public String getName() {
        if (this.name == null) {
            return "Execute Templates";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Shell getShell() {
        if (this.shell == null) {
            return Display.getDefault().getActiveShell();
        }
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    public URI getGenModelURI() {
        return this.genModelURI;
    }

    public void setGenModelURI(URI uri) {
        this.genModelURI = uri;
    }

    public void run() {
        if (this.getGenModelURI() == null) {
            return;
        }
        Diagnostic loadStatus = this.loadGenModel();
        if (!this.canProcessGMFGenModel(loadStatus)) {
            return;
        }
        assert (this.getGenModel() != null);
        Diagnostic isGenModelValid = this.validateGenModel();
        if (!ValidationHelper.isOK((Diagnostic)isGenModelValid)) {
            String msg = CodeGenUIPlugin.getBundleString("generatecode.badsrc");
            if (DiagnosticsDialog.openProceedCancel(this.getShell(), this.getName(), msg, isGenModelValid) == 1) {
                return;
            }
        }
        if (!PlatformUI.getWorkbench().saveAllEditors(true)) {
            return;
        }
        final Job job = new Job(this.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IStatus s = ExecuteTemplatesOperation.this.run(monitor);
                    if (!s.isOK()) {
                        return s;
                    }
                    return new Status(0, s.getPlugin(), CodeGenUIPlugin.getBundleString("generatecode.ok"));
                }
                catch (InterruptedException interruptedException) {
                    return Status.CANCEL_STATUS;
                }
            }

            public boolean belongsTo(Object family) {
                if (family instanceof Job) {
                    return family.getClass().equals(((Object)((Object)this)).getClass());
                }
                return false;
            }
        };
        job.setUser(true);
        job.setProperty(IProgressConstants.KEEPONE_PROPERTY, (Object)true);
        job.setProperty(IProgressConstants.ACTION_PROPERTY, (Object)new Action(){

            public void run() {
                IStatus runStatus = job.getResult();
                if (runStatus == null) {
                    return;
                }
                if (runStatus.isOK()) {
                    ExecuteTemplatesOperation.this.showOk(true);
                } else if (runStatus.matches(4)) {
                    ErrorDialog.openError((Shell)ExecuteTemplatesOperation.this.getShell(), (String)ExecuteTemplatesOperation.this.getName(), (String)CodeGenUIPlugin.getBundleString("generatecode.err"), (IStatus)runStatus);
                } else if (runStatus.matches(2)) {
                    ErrorDialog.openError((Shell)ExecuteTemplatesOperation.this.getShell(), (String)ExecuteTemplatesOperation.this.getName(), (String)CodeGenUIPlugin.getBundleString("generatecode.warn"), (IStatus)runStatus);
                } else if (runStatus.matches(1)) {
                    ErrorDialog.openError((Shell)ExecuteTemplatesOperation.this.getShell(), (String)ExecuteTemplatesOperation.this.getName(), (String)CodeGenUIPlugin.getBundleString("generatecode.info"), (IStatus)runStatus);
                }
            }
        });
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ExecuteTemplatesOperation.this.unloadGenModel();
                IStatus runStatus = event.getResult();
                if (runStatus.isOK() && Boolean.TRUE.equals(event.getJob().getProperty(IProgressConstants.PROPERTY_IN_DIALOG))) {
                    ExecuteTemplatesOperation.this.showOk(false);
                } else if (runStatus.matches(4)) {
                    CodeGenUIPlugin.getDefault().getLog().log(runStatus);
                }
            }
        });
        job.schedule();
    }

    protected void showOk(boolean force) {
        final boolean neverShowAgain = "always".equals(ExecuteTemplatesOperation.getPreferences().getString(ASK_OK));
        if (force || !neverShowAgain) {
            final String okMsg = CodeGenUIPlugin.getBundleString("generatecode.ok");
            final String neverMsg = CodeGenUIPlugin.getBundleString("generatecode.neveragain");
            Runnable r = new Runnable(){

                public void run() {
                    MessageDialogWithToggle dlg = MessageDialogWithToggle.openInformation((Shell)ExecuteTemplatesOperation.this.getShell(), (String)ExecuteTemplatesOperation.this.getName(), (String)okMsg, (String)neverMsg, (boolean)neverShowAgain, (IPreferenceStore)ExecuteTemplatesOperation.getPreferences(), (String)ExecuteTemplatesOperation.ASK_OK);
                    if (!dlg.getToggleState()) {
                        ExecuteTemplatesOperation.getPreferences().setValue(ExecuteTemplatesOperation.ASK_OK, "prompt");
                    }
                }
            };
            if (Display.getCurrent() != null) {
                r.run();
            } else {
                Display.getDefault().asyncExec(r);
            }
        }
    }

    private boolean canProcessGMFGenModel(Diagnostic loadStatus) {
        if (!ValidationHelper.isOK((Diagnostic)loadStatus)) {
            boolean disableProceed;
            boolean bl = disableProceed = this.myGenModel == null;
            if (1 == DiagnosticsDialog.openProceedCancel(this.getShell(), this.getName(), null, loadStatus, disableProceed)) {
                return false;
            }
        }
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) throws InterruptedException {
        GeneratorBase g = this.createGenerator();
        g.run(monitor);
        return g.getRunStatus();
    }

    protected GeneratorBase createGenerator() {
        return new Generator(this.getGenModel(), CodeGenUIPlugin.getDefault().getEmitters(this.getGenModel()));
    }

    protected final GenEditorGenerator getGenModel() {
        return this.myGenModel;
    }

    private Diagnostic loadGenModel() {
        ResourceSetImpl srcResSet = new ResourceSetImpl();
        srcResSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        Activator.fillWorkspaceMetaModelsMap((EPackage.Registry)srcResSet.getPackageRegistry());
        ModelLoadHelper loadHelper = new ModelLoadHelper((ResourceSet)srcResSet, this.getGenModelURI());
        EObject root = loadHelper.getContentsRoot();
        if (root instanceof GenDiagram) {
            this.myGenModel = ((GenDiagram)root).getEditorGen();
        } else if (root instanceof GenEditorGenerator) {
            this.myGenModel = (GenEditorGenerator)root;
        }
        if (this.myGenModel != null && this.myGenModel.getDomainGenModel() != null) {
            this.myGenModel.getDomainGenModel().reconcile();
        }
        return ValidationHelper.createResourceProblemMarkers((Diagnostic)loadHelper.getDiagnostics());
    }

    private void unloadGenModel() {
        if (this.myGenModel != null && this.myGenModel.eResource() != null) {
            this.myGenModel.eResource().unload();
        }
        this.myGenModel = null;
    }

    private Diagnostic validateGenModel() {
        return ValidationHelper.validate((EObject)this.getGenModel(), (boolean)true);
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }
}

