/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.naming.gen;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenContainerBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.internal.bridge.naming.AbstractGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.ClassGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.DefaultGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.DesignGenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.GenNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.gen.GenNamingMediator;
import org.eclipse.gmf.internal.common.IncrementalNamesDispenser;
import org.eclipse.gmf.internal.common.NamesDispenser;

public class GenNamingMediatorImpl
implements GenNamingMediator {
    private final GMFGenPackage M = GMFGenPackage.eINSTANCE;
    private Mode mode;
    private NamesDispenser dispenser;
    private GenNamingStrategy viewFactory;
    private GenNamingStrategy editPart;
    private GenNamingStrategy itemSemanticPolicy;
    private GenNamingStrategy canonicalPolicy;
    private GenNamingStrategy nodeGraphicalPolicy;
    private GenNamingStrategy editHelper;
    private GenNamingStrategy editHelperAdvice;
    private GenNamingStrategy linkCreateCommand;
    private GenNamingStrategy nodeCreateCommand;
    private GenNamingStrategy linkReorientCommand;

    public GenNamingMediatorImpl() {
        this((NamesDispenser)new IncrementalNamesDispenser());
    }

    public GenNamingMediatorImpl(NamesDispenser dispenser) {
        this.dispenser = dispenser;
        this.mode = Mode.DISPENSE_NAMES;
        this.setViewFactory(this.createNamingStrategy("ViewFactory"));
        this.setEditPart(this.createNamingStrategy("EditPart"));
        this.setItemSemanticPolicy(this.createNamingStrategy("ItemSemanticEditPolicy"));
        this.setCanonicalPolicy(this.createNamingStrategy("CanonicalEditPolicy"));
        this.setNodeGraphicalPolicy(this.createNamingStrategy("GraphicalNodeEditPolicy"));
        this.setEditHelper(this.createNamingStrategy("EditHelper"));
        this.setEditHelperAdvice(this.createNamingStrategy("EditHelperAdvice"));
        this.setLinkCreateCommand(this.createNamingStrategy("CreateCommand"));
        this.setNodeCreateCommand(this.createNamingStrategy("CreateCommand"));
        this.setLinkReorientCommand(this.createNamingStrategy("ReorientCommand"));
    }

    protected GenNamingStrategy createNamingStrategy(String suffixPart) {
        AbstractGenNamingStrategy pns = new DefaultGenNamingStrategy(null, null, null, null);
        pns = new DesignGenNamingStrategy(null, null, pns, null);
        pns = new ClassGenNamingStrategy(null, null, pns, null);
        AbstractGenNamingStrategy ns = new DefaultGenNamingStrategy(suffixPart, this.dispenser, null, pns);
        ns = new DesignGenNamingStrategy(suffixPart, this.dispenser, ns, pns);
        ns = new ClassGenNamingStrategy(suffixPart, this.dispenser, ns, pns);
        return ns;
    }

    public void reset() {
        if (this.dispenser != null) {
            this.dispenser.clear();
        }
    }

    public final Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    protected void feedName(EObject element, EAttribute feature, GenNamingStrategy strategy, EObject refElement) {
        switch (this.getMode()) {
            case COLLECT_NAMES: {
                if (!element.eIsSet((EStructuralFeature)feature)) break;
                this.dispenser.add((String)element.eGet((EStructuralFeature)feature));
                break;
            }
            case DISPENSE_NAMES: {
                if (element.eIsSet((EStructuralFeature)feature)) break;
                element.eSet((EStructuralFeature)feature, (Object)this.getName(refElement, strategy));
            }
        }
    }

    protected void feedName(EObject element, EAttribute feature, GenNamingStrategy strategy) {
        this.feedName(element, feature, strategy, element);
    }

    public void feed(GenDiagram element) {
        this.dispenser.add(element.getBaseExternalNodeLabelEditPartClassName());
        this.dispenser.add(element.getBaseItemSemanticEditPolicyClassName());
        this.dispenser.add(element.getBaseGraphicalNodeEditPolicyClassName());
        this.dispenser.add(element.getBaseEditHelperClassName());
        this.feedContainer((GenContainerBase)element);
    }

    public void feed(GenNode element) {
        this.feedContainer((GenContainerBase)element);
        this.feedName((EObject)element, this.M.getGenNode_GraphicalNodeEditPolicyClassName(), this.getNodeGraphicalPolicy());
        this.feedName((EObject)element, this.M.getGenNode_CreateCommandClassName(), this.getNodeCreateCommand());
    }

    public void feed(GenCompartment element) {
        this.feedContainer((GenContainerBase)element);
    }

    public void feed(GenLink element) {
        this.feedCommon((GenCommonBase)element);
        this.feedName((EObject)element, this.M.getGenLink_CreateCommandClassName(), this.getLinkCreateCommand());
        this.feedName((EObject)element, this.M.getGenLink_ReorientCommandClassName(), this.getLinkReorientCommand());
    }

    public void feed(GenLabel element) {
        this.feedCommon((GenCommonBase)element);
    }

    protected void feedContainer(GenContainerBase element) {
        this.feedCommon((GenCommonBase)element);
        this.feedName((EObject)element, this.M.getGenContainerBase_CanonicalEditPolicyClassName(), this.getCanonicalPolicy());
    }

    protected void feedCommon(GenCommonBase element) {
        this.feedName((EObject)element, this.M.getGenCommonBase_NotationViewFactoryClassName(), this.getViewFactory());
        this.feedName((EObject)element, this.M.getGenCommonBase_EditPartClassName(), this.getEditPart());
        this.feedName((EObject)element, this.M.getGenCommonBase_ItemSemanticEditPolicyClassName(), this.getItemSemanticPolicy());
        if (element.getElementType() instanceof MetamodelType) {
            MetamodelType type = (MetamodelType)element.getElementType();
            this.feedName((EObject)type, this.M.getMetamodelType_EditHelperClassName(), this.getEditHelper(), (EObject)element);
        }
    }

    protected String getName(EObject element, GenNamingStrategy strategy) {
        if (element instanceof GenDiagram) {
            return strategy.get((GenDiagram)element);
        }
        if (element instanceof GenNode) {
            return strategy.get((GenNode)element);
        }
        if (element instanceof GenCompartment) {
            return strategy.get((GenCompartment)element);
        }
        if (element instanceof GenLink) {
            return strategy.get((GenLink)element);
        }
        if (element instanceof GenLabel) {
            return strategy.get((GenLabel)element);
        }
        throw new IllegalArgumentException();
    }

    public void traverse(GenEditorGenerator gen) {
        GenDiagram diagram = gen.getDiagram();
        this.feed(diagram);
        for (GenNode node : diagram.getTopLevelNodes()) {
            this.feed(node);
            for (GenLabel label : node.getLabels()) {
                this.feed(label);
            }
        }
        for (GenNode node : diagram.getChildNodes()) {
            this.feed(node);
            for (GenLabel label : node.getLabels()) {
                this.feed(label);
            }
        }
        for (GenNode node : diagram.getCompartments()) {
            this.feed((GenCompartment)node);
        }
        for (GenLink link : diagram.getLinks()) {
            this.feed(link);
            for (GenLabel label : link.getLabels()) {
                this.feed(label);
            }
        }
    }

    public GenNamingStrategy getViewFactory() {
        return this.viewFactory;
    }

    public void setViewFactory(GenNamingStrategy viewFactory) {
        this.viewFactory = viewFactory;
    }

    public GenNamingStrategy getEditPart() {
        return this.editPart;
    }

    public void setEditPart(GenNamingStrategy editPart) {
        this.editPart = editPart;
    }

    public GenNamingStrategy getItemSemanticPolicy() {
        return this.itemSemanticPolicy;
    }

    public void setItemSemanticPolicy(GenNamingStrategy itemSemanticPolicy) {
        this.itemSemanticPolicy = itemSemanticPolicy;
    }

    public GenNamingStrategy getCanonicalPolicy() {
        return this.canonicalPolicy;
    }

    public void setCanonicalPolicy(GenNamingStrategy canonicalPolicy) {
        this.canonicalPolicy = canonicalPolicy;
    }

    public GenNamingStrategy getNodeGraphicalPolicy() {
        return this.nodeGraphicalPolicy;
    }

    public void setNodeGraphicalPolicy(GenNamingStrategy nodeGraphicalPolicy) {
        this.nodeGraphicalPolicy = nodeGraphicalPolicy;
    }

    public GenNamingStrategy getEditHelper() {
        return this.editHelper;
    }

    public void setEditHelper(GenNamingStrategy editHelper) {
        this.editHelper = editHelper;
    }

    public GenNamingStrategy getEditHelperAdvice() {
        return this.editHelperAdvice;
    }

    public void setEditHelperAdvice(GenNamingStrategy editHelperAdvice) {
        this.editHelperAdvice = editHelperAdvice;
    }

    public GenNamingStrategy getLinkCreateCommand() {
        return this.linkCreateCommand;
    }

    public void setLinkCreateCommand(GenNamingStrategy linkCreateCommand) {
        this.linkCreateCommand = linkCreateCommand;
    }

    public GenNamingStrategy getNodeCreateCommand() {
        return this.nodeCreateCommand;
    }

    public void setNodeCreateCommand(GenNamingStrategy nodeCreateCommand) {
        this.nodeCreateCommand = nodeCreateCommand;
    }

    public GenNamingStrategy getLinkReorientCommand() {
        return this.linkReorientCommand;
    }

    public void setLinkReorientCommand(GenNamingStrategy linkReorientCommand) {
        this.linkReorientCommand = linkReorientCommand;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        COLLECT_NAMES,
        DISPENSE_NAMES;

    }
}

