/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import junit.framework.TestCase;
import org.eclipse.gmf.tests.NeedsSetup;
import org.eclipse.gmf.tests.setup.SessionSetup;

public abstract class ConfiguredTestCase
extends TestCase
implements NeedsSetup {
    private SessionSetup mySessionSetup;

    protected ConfiguredTestCase(String name) {
        super(name);
    }

    public final void configure(SessionSetup sessionSetup) {
        ConfiguredTestCase.assertNotNull((Object)sessionSetup);
        this.mySessionSetup = sessionSetup;
        this.mySessionSetup.oneUp();
    }

    protected final SessionSetup getSetup() {
        return this.mySessionSetup;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.mySessionSetup == null) {
            this.mySessionSetup = this.createDefaultSetup();
        }
        ConfiguredTestCase.assertNotNull((String)("Test " + this.getName() + " needs session setup"), (Object)this.mySessionSetup);
    }

    protected SessionSetup createDefaultSetup() {
        return SessionSetup.newInstance();
    }

    protected void tearDown() throws Exception {
        this.mySessionSetup.oneDown();
        super.tearDown();
    }
}

