/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.CircuitEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.AndGate;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Circuit;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.ContainerElement;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticPackage;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Terminal;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.util.LogicSemanticType;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ICanonicalShapeCompartmentLayout;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.ZoomContributionItem;
import org.eclipse.gmf.runtime.diagram.ui.render.actions.CopyToImageAction;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractDiagramTests;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorSite;

public class LogicDiagramTests
extends AbstractDiagramTests {
    public LogicDiagramTests(String arg0) {
        super(arg0);
    }

    public static Test suite() {
        return new TestSuite(LogicDiagramTests.class);
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getLogicTestFixture() {
        return (LogicTestFixture)this.getTestFixture();
    }

    protected void setUp() throws Exception {
        EditPart firstEP;
        super.setUp();
        List children = this.getTestFixture().getDiagramEditPart().getChildren();
        if (children.isEmpty()) {
            LogicDiagramTests.assertFalse((boolean)true);
        }
        if ((firstEP = (EditPart)children.get(0)) instanceof CircuitEditPart) {
            CircuitEditPart circuitEditPart = (CircuitEditPart)firstEP;
            IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
            Point pos = circuitEditPart.getFigure().getBounds().getBottomRight();
            circuitEditPart.getFigure().translateToAbsolute((Translatable)pos);
            pos.translate(100, 100);
            LEDEditPart ledEP2 = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, pos, (IGraphicalEditPart)this.getDiagramEditPart());
            Terminal term1 = (Terminal)((Circuit)circuitEditPart.getNotationView().getElement()).getOutputTerminals().get(0);
            TerminalEditPart tep1 = null;
            ListIterator li = circuitEditPart.getChildren().listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                if (!gep.getNotationView().getElement().equals(term1)) continue;
                tep1 = (TerminalEditPart)gep;
            }
            Terminal term2 = (Terminal)((LED)ledEP2.getNotationView().getElement()).getInputTerminals().get(0);
            TerminalEditPart tep2 = null;
            li = ledEP2.getChildren().listIterator();
            while (li.hasNext()) {
                IGraphicalEditPart gep = (IGraphicalEditPart)li.next();
                if (!gep.getNotationView().getElement().equals(term2)) continue;
                tep2 = (TerminalEditPart)gep;
            }
            IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
            this.getLogicTestFixture().createConnectorUsingTool((IGraphicalEditPart)tep1, (IGraphicalEditPart)tep2, typeWire);
            IGraphicalEditPart logicCompartment = circuitEditPart.getChildBySemanticHint("LogicCompartment");
            Rectangle rect = new Rectangle(logicCompartment.getFigure().getBounds());
            logicCompartment.getFigure().translateToAbsolute((Translatable)rect);
            CreateRequest request = this.getLogicTestFixture().getCreationRequest(typeLED);
            request.setLocation(rect.getCenter());
            Command cmd = logicCompartment.getCommand((Request)request);
            this.getCommandStack().execute(cmd);
            LogicDiagramTests.assertEquals((String)"Unexpected LED count.", (int)1, (int)logicCompartment.getChildren().size());
        }
    }

    public void testZoomDoesntDirtyDiagram() throws Exception {
        this.getTestFixture().openDiagram();
        ZoomManager zoomManager = this.getZoomManager();
        LogicDiagramTests.assertTrue((zoomManager != null ? 1 : 0) != 0);
        this.saveDiagram();
        if (zoomManager.canZoomIn()) {
            zoomManager.setZoom(zoomManager.getNextZoomLevel());
        } else {
            zoomManager.setZoom(zoomManager.getPreviousZoomLevel());
        }
        LogicDiagramTests.assertTrue((!this.isDirty() ? 1 : 0) != 0);
    }

    public void testSelectAllInContext() throws Exception {
        List children = this.getTestFixture().getDiagramEditPart().getChildren();
        if (children.isEmpty()) {
            LogicDiagramTests.assertFalse((boolean)true);
        }
        CircuitEditPart circuitEP = null;
        ListIterator li = children.listIterator();
        while (li.hasNext()) {
            EditPart ep = (EditPart)li.next();
            if (!(ep instanceof CircuitEditPart)) continue;
            circuitEP = (CircuitEditPart)ep;
            IGraphicalEditPart logicCompartment = circuitEP.getChildBySemanticHint("LogicCompartment");
            List shapes = this.getSelectableShapesIn(logicCompartment);
            ArrayList all = new ArrayList();
            all.addAll(shapes);
            this.selectAll(logicCompartment, shapes);
        }
        List connectors = this.getConnectors();
        List shapes = this.getSelectableShapesIn(this.getDrawSurfaceEditPart());
        ArrayList all = new ArrayList();
        all.addAll(connectors);
        all.addAll(shapes);
        this.selectAll((IGraphicalEditPart)circuitEP, all);
    }

    public void testZoomToolbarEnablement() throws Exception {
        this.getTestFixture().openDiagram();
        IContributionItem[] items = ((IEditorSite)this.getDiagramWorkbenchPart().getSite()).getActionBars().getToolBarManager().getItems();
        boolean foundIt = false;
        int i = 0;
        while (i < items.length) {
            IContributionItem item = items[i];
            if (item instanceof ZoomContributionItem) {
                foundIt = true;
                LogicDiagramTests.assertTrue((boolean)item.isEnabled());
            }
            ++i;
        }
        LogicDiagramTests.assertTrue((boolean)foundIt);
    }

    public void testDeleteFromModel() throws Exception {
        this.getTestFixture().openDiagram();
        LEDEditPart editPartToDelete = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(LogicSemanticType.LED, new Point(0, 0), (IGraphicalEditPart)this.getDiagramEditPart());
        List primaryEditParts = this.getDiagramEditPart().getPrimaryEditParts();
        LogicDiagramTests.assertTrue((boolean)primaryEditParts.contains(editPartToDelete));
        EObject semanticElement = (EObject)editPartToDelete.getAdapter(EObject.class);
        EObject semanticContainer = semanticElement.eContainer();
        EditPartViewer rootViewer = this.getDiagramEditPart().getRoot().getViewer();
        rootViewer.deselectAll();
        rootViewer.select((EditPart)editPartToDelete);
        ((IPreferenceStore)this.getDiagramEditPart().getDiagramPreferencesHint().getPreferenceStore()).setValue("Global.promptOnDelFromModel", false);
        Event e = new Event();
        e.character = (char)4;
        e.keyCode = 100;
        e.stateMask = 262144;
        e.widget = editPartToDelete.getViewer().getControl();
        SelectionTool tool = new SelectionTool();
        tool.setEditDomain((EditDomain)this.getDiagramWorkbenchPart().getDiagramEditDomain());
        tool.activate();
        tool.keyDown(new KeyEvent(e), rootViewer);
        primaryEditParts = this.getDiagramEditPart().getPrimaryEditParts();
        LogicDiagramTests.assertFalse((String)"Primary edit part not deleted.", (boolean)primaryEditParts.contains(editPartToDelete));
        LogicDiagramTests.assertFalse((String)"Semantic element not deleted.", (boolean)semanticContainer.eContents().contains((Object)semanticElement));
    }

    public void testCopyToImageActionEnablement() throws Exception {
        this.getTestFixture().openDiagram();
        List children = this.getTestFixture().getDiagramEditPart().getChildren();
        CircuitEditPart circuitEP = null;
        ListIterator li = children.listIterator();
        while (li.hasNext()) {
            Object ep = li.next();
            if (!(ep instanceof CircuitEditPart)) continue;
            circuitEP = (CircuitEditPart)ep;
        }
        LogicDiagramTests.assertNotNull(circuitEP);
        CopyToImageAction action = new CopyToImageAction(this.getWorkbenchPage());
        action.init();
        EditPartViewer viewer = this.getDiagramEditPart().getRoot().getViewer();
        viewer.deselectAll();
        viewer.select((EditPart)this.getDiagramEditPart());
        this.flushEventQueue();
        LogicDiagramTests.assertTrue((boolean)action.isEnabled());
        viewer.deselectAll();
        viewer.select((EditPart)circuitEP);
        this.flushEventQueue();
        LogicDiagramTests.assertTrue((boolean)action.isEnabled());
    }

    public void test_drop_modalContextThread() throws Exception {
        this.getTestFixture().openDiagram();
        final DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        AbstractTransactionalCommand andCommand = new AbstractTransactionalCommand(this.getTestFixture().getEditingDomain(), "Create AND Gate", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                AndGate newElement = (AndGate)SemanticPackage.eINSTANCE.getEFactoryInstance().create(SemanticPackage.eINSTANCE.getAndGate());
                ContainerElement semanticElement = (ContainerElement)diagramEditPart.resolveSemanticElement();
                semanticElement.getChildren().add((Object)newElement);
                return CommandResult.newOKCommandResult((Object)newElement);
            }
        };
        andCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        AndGate andGate = (AndGate)andCommand.getCommandResult().getReturnValue();
        List primaryEditParts = diagramEditPart.getPrimaryEditParts();
        int initialEditPartCount = primaryEditParts.size();
        Point dropLocation = ICanonicalShapeCompartmentLayout.UNDEFINED.getLocation();
        DropObjectsRequest request = new DropObjectsRequest();
        request.setObjects(Collections.singletonList(andGate));
        request.setAllowedDetail(1);
        request.setLocation(dropLocation);
        Command command = diagramEditPart.getCommand((Request)request);
        final CommandProxy proxy = new CommandProxy(command);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)proxy, monitor, null);
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        new ProgressMonitorDialog(null).run(true, true, runnable);
        primaryEditParts = this.getDiagramEditPart().getPrimaryEditParts();
        LogicDiagramTests.assertTrue((String)"Size of primary edit parts should have increased.", (primaryEditParts.size() > initialEditPartCount ? 1 : 0) != 0);
        IGraphicalEditPart andGateEditPart = null;
        for (IGraphicalEditPart nextEditPart : primaryEditParts) {
            if (!andGate.equals(nextEditPart.resolveSemanticElement())) continue;
            andGateEditPart = nextEditPart;
            break;
        }
        LogicDiagramTests.assertNotNull((String)"Expected a new edit part for the AND gate", andGateEditPart);
    }
}

