/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.requests.TargetRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.ActionFilterService;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionLabelsEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PropertyHandlerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ToggleCanonicalModeCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IContainedEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.SanpToHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ConnectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ConnectionLineSegEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.TreeConnectionBendpointEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.editpolicy.EditPolicyService;
import org.eclipse.gmf.runtime.diagram.ui.internal.type.NotationTypeUtil;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.figures.ConnectionLayerEx;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ForestRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.gef.ui.internal.l10n.Cursors;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.SelectConnectionEditPartTracker;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.JumpLinkStatus;
import org.eclipse.gmf.runtime.notation.JumpLinkType;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.Smoothness;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IActionFilter;

public abstract class ConnectionEditPart
extends AbstractConnectionEditPart
implements IGraphicalEditPart,
PropertyChangeListener,
IContainedEditPart,
IPrimaryEditPart,
NotificationListener {
    private Map listenerFilters;
    private String elementGuid;
    private boolean isEditable = true;
    protected AccessibleEditPart accessibleEP;
    private TransactionalEditingDomain editingDomain;
    private FontData cachedFontData;
    private Boolean semanticConnection;
    private static volatile int GETCOMMAND_RECURSIVE_COUNT = 0;
    private static Set _disableCanonicalEditPolicyList = new HashSet();
    protected static final String[] appearanceProperties;

    static {
        ConnectionEditPart.registerAdapters();
        appearanceProperties = new String[]{Properties.ID_FONTNAME, Properties.ID_FONTSIZE, Properties.ID_FONTBOLD, Properties.ID_FONTITALIC, Properties.ID_FONTCOLOR, Properties.ID_LINECOLOR};
    }

    protected Command getPropertyChangeCommand(Object property, Object oldValue, Object newValue) {
        return null;
    }

    protected void addChild(EditPart child, int index) {
        super.addChild(child, index);
        if (child instanceof GraphicalEditPart) {
            GraphicalEditPart gEP = (GraphicalEditPart)child;
            boolean editMode = this.isEditModeEnabled();
            if (editMode != gEP.isEditModeEnabled()) {
                if (editMode) {
                    gEP.enableEditMode();
                } else {
                    gEP.disableEditMode();
                }
            }
        }
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        this.addNotationalListeners();
        EObject semanticProxy = ((View)this.getModel()).getElement();
        EObject semanticElement = EMFCoreUtil.resolve((TransactionalEditingDomain)this.getEditingDomain(), (EObject)semanticProxy);
        if (semanticElement != null) {
            this.addSemanticListeners();
        } else if (semanticProxy != null) {
            this.addListenerFilter("SemanticProxy", this, semanticProxy);
        }
        super.activate();
    }

    protected void addListenerFilter(String filterId, NotificationListener listener, EObject element) {
        if (element == null) {
            return;
        }
        assert (filterId != null);
        assert (listener != null);
        if (this.listenerFilters == null) {
            this.listenerFilters = new HashMap();
        }
        this.getDiagramEventBroker().addNotificationListener(element, listener);
        this.listenerFilters.put(filterId, new Object[]{element, listener});
    }

    protected void addListenerFilter(String filterId, NotificationListener listener, EObject element, EStructuralFeature feature) {
        if (element == null) {
            return;
        }
        assert (filterId != null);
        assert (listener != null);
        if (this.listenerFilters == null) {
            this.listenerFilters = new HashMap();
        }
        this.getDiagramEventBroker().addNotificationListener(element, feature, listener);
        this.listenerFilters.put(filterId, new Object[]{element, feature, listener});
    }

    protected final EditPart createChild(Object model) {
        return EditPartService.getInstance().createGraphicEditPart((View)model);
    }

    protected final org.eclipse.gef.ConnectionEditPart createConnection(Object connectionView) {
        return (org.eclipse.gef.ConnectionEditPart)this.createChild(connectionView);
    }

    protected final void createEditPolicies() {
        this.createDefaultEditPolicies();
        EditPolicyService.getInstance().createEditPolicies((EditPart)this);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SemanticEditPolicy());
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new PropertyHandlerEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy());
        this.installBendpointEditPolicy();
        this.installEditPolicy("DecorationPolicy", (EditPolicy)new DecorationEditPolicy());
        this.installEditPolicy("ConnectionLabelsPolicy", (EditPolicy)new ConnectionLabelsEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        boolean wasActive = this.isActive();
        super.deactivate();
        if (this.listenerFilters != null && wasActive != this.isActive()) {
            Iterator i = this.listenerFilters.keySet().iterator();
            while (i.hasNext()) {
                Object[] obj = (Object[])this.listenerFilters.get(i.next());
                if (obj.length > 2) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)obj[0], (Object)((EStructuralFeature)obj[1]), (NotificationListener)obj[2]);
                    continue;
                }
                this.getDiagramEventBroker().removeNotificationListener((EObject)obj[0], (NotificationListener)obj[1]);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.cachedFontData != null) {
            this.getResourceManager().destroyFont(FontDescriptor.createFrom((FontData)this.cachedFontData));
            this.cachedFontData = null;
        }
    }

    protected void executeCommand(Command command) {
        this.getEditDomain().getCommandStack().execute(command);
    }

    private static void registerAdapters() {
        Platform.getAdapterManager().registerAdapters(new IAdapterFactory(){

            public Object getAdapter(Object adaptableObject, Class adapterType) {
                IGraphicalEditPart gep = (IGraphicalEditPart)adaptableObject;
                if (adapterType == IActionFilter.class) {
                    return ActionFilterService.getInstance();
                }
                if (adapterType == View.class) {
                    return gep.getModel();
                }
                return null;
            }

            public Class[] getAdapterList() {
                return new Class[]{IActionFilter.class, View.class};
            }
        }, IGraphicalEditPart.class);
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                private String getSemanticName() {
                    EObject semanticElement = ConnectionEditPart.this.resolveSemanticElement();
                    if (semanticElement != null) {
                        String name = semanticElement.getClass().getName();
                        int startIndex = name.lastIndexOf(46) + 1;
                        int endIndex = name.lastIndexOf("Impl");
                        return name.substring(startIndex, endIndex);
                    }
                    return DiagramUIMessages.Accessible_Connection_Label;
                }

                public void getName(AccessibleEvent e) {
                    EditPart sourceEP = ConnectionEditPart.this.getSource();
                    EditPart targetEP = ConnectionEditPart.this.getTarget();
                    String connectionName = this.getSemanticName();
                    String sourceName = null;
                    if (sourceEP != null) {
                        AccessibleEditPart aEP = (AccessibleEditPart)sourceEP.getAdapter(AccessibleEditPart.class);
                        AccessibleEvent event = new AccessibleEvent((Object)this);
                        aEP.getName(event);
                        sourceName = event.result;
                    }
                    String targetName = null;
                    if (targetEP != null) {
                        AccessibleEditPart aEP = (AccessibleEditPart)targetEP.getAdapter(AccessibleEditPart.class);
                        AccessibleEvent event = new AccessibleEvent((Object)this);
                        aEP.getName(event);
                        targetName = event.result;
                    }
                    e.result = sourceName != null && targetName != null ? NLS.bind((String)DiagramUIMessages.Accessible_Connection_From_Source_To_Target, (Object[])new Object[]{connectionName, sourceName, targetName}) : (sourceName != null ? NLS.bind((String)DiagramUIMessages.Accessible_Connection_From_Source, (Object[])new Object[]{connectionName, sourceName}) : (targetName != null ? NLS.bind((String)DiagramUIMessages.Accessible_Connection_To_Target, (Object[])new Object[]{connectionName, targetName}) : connectionName));
                }
            };
        }
        return this.accessibleEP;
    }

    public Object getAdapter(Class key) {
        Object adapter = Platform.getAdapterManager().getAdapter((Object)this, key);
        if (adapter != null) {
            return adapter;
        }
        if (key == SnapToHelper.class) {
            return SanpToHelperUtil.getSnapHelper(this);
        }
        Object model = this.getModel();
        if (View.class.isAssignableFrom(key) && key.isInstance(model)) {
            return model;
        }
        if (model != null && model instanceof View) {
            EObject semanticObject = ViewUtil.resolveSemanticElement((View)((View)model));
            if (key.isInstance(semanticObject)) {
                return semanticObject;
            }
            if (key.isInstance(model)) {
                return model;
            }
        }
        return super.getAdapter(key);
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        View view;
        if (this.getModel() != null && (view = ViewUtil.getChildBySemanticHint((View)((View)this.getModel()), (String)semanticHint)) != null) {
            return (IGraphicalEditPart)this.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    public Command getCommand(Request _request) {
        if (!this.isEditModeEnabled()) {
            return UnexecutableCommand.INSTANCE;
        }
        Command cmd = null;
        try {
            ++GETCOMMAND_RECURSIVE_COUNT;
            final Request request = _request;
            try {
                cmd = (Command)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                    public void run() {
                        this.setResult(ConnectionEditPart.super.getCommand(request));
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getCommand", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getCommand", (Throwable)e);
            }
            if (cmd != null) {
                _disableCanonicalEditPolicyList.addAll(this.disableCanonicalFor(_request));
            }
            if (--GETCOMMAND_RECURSIVE_COUNT == 0 && cmd != null && !_disableCanonicalEditPolicyList.isEmpty()) {
                CompoundCommand cc = new CompoundCommand();
                cc.setLabel(cmd.getLabel());
                ToggleCanonicalModeCommand tcmd = ToggleCanonicalModeCommand.getToggleCanonicalModeCommand(_disableCanonicalEditPolicyList, false);
                cc.add((Command)tcmd);
                cc.add(cmd);
                ToggleCanonicalModeCommand tcmd2 = ToggleCanonicalModeCommand.getToggleCanonicalModeCommand(tcmd, true);
                if (tcmd2 != null) {
                    tcmd2.setDomain(this.getEditingDomain());
                }
                cc.add((Command)tcmd2);
                _disableCanonicalEditPolicyList.clear();
                return cc.unwrap();
            }
        }
        catch (RuntimeException t) {
            GETCOMMAND_RECURSIVE_COUNT = 0;
            throw t;
        }
        return cmd;
    }

    protected Collection disableCanonicalFor(Request request) {
        CreateConnectionRequest ccvr;
        HashSet<ConnectionEditPart> hosts = new HashSet<ConnectionEditPart>();
        if (request instanceof EditCommandRequestWrapper || request instanceof TargetRequest || request instanceof DropRequest) {
            hosts.add(this);
            hosts.add((ConnectionEditPart)this.getParent());
        }
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnect = (ReconnectRequest)request;
            hosts.add(this);
            hosts.add((ConnectionEditPart)this.getParent());
            if (reconnect.getTarget() != null) {
                EditPart target = reconnect.getTarget();
                this.addEditPartAndParent(hosts, target);
            }
            if (reconnect.getConnectionEditPart() != null) {
                org.eclipse.gef.ConnectionEditPart connectionEditPart = reconnect.getConnectionEditPart();
                if (connectionEditPart.getSource() != null) {
                    EditPart srcEP = connectionEditPart.getSource();
                    this.addEditPartAndParent(hosts, srcEP);
                }
                if (connectionEditPart.getTarget() != null) {
                    EditPart trgEP = connectionEditPart.getTarget();
                    this.addEditPartAndParent(hosts, trgEP);
                }
            }
        }
        if (request instanceof CreateConnectionRequest) {
            ccvr = (CreateConnectionRequest)request;
            hosts.add(this);
            hosts.add((ConnectionEditPart)this.getParent());
            if (ccvr.getSourceEditPart() != null) {
                hosts.add((ConnectionEditPart)ccvr.getSourceEditPart());
                hosts.add((ConnectionEditPart)ccvr.getSourceEditPart().getParent());
            }
            if (ccvr.getTargetEditPart() != null) {
                hosts.add((ConnectionEditPart)ccvr.getTargetEditPart());
                hosts.add((ConnectionEditPart)ccvr.getTargetEditPart().getParent());
            }
        }
        if (request instanceof GroupRequest) {
            List parts = ((GroupRequest)request).getEditParts();
            hosts.add(this);
            hosts.add((ConnectionEditPart)this.getParent());
            Iterator editparts = parts == null ? Collections.EMPTY_LIST.iterator() : parts.iterator();
            while (editparts.hasNext()) {
                EditPart ep = (EditPart)editparts.next();
                this.addEditPartAndParent(hosts, ep);
            }
        }
        if (this instanceof IBorderItemEditPart && request instanceof CreateConnectionViewRequest) {
            ccvr = (CreateConnectionViewRequest)request;
            if (ccvr.getSourceEditPart() instanceof IBorderItemEditPart) {
                hosts.add((ConnectionEditPart)ccvr.getSourceEditPart().getParent().getParent());
            }
            if (ccvr.getTargetEditPart() instanceof IBorderItemEditPart) {
                hosts.add((ConnectionEditPart)ccvr.getTargetEditPart().getParent().getParent());
            }
        }
        return hosts;
    }

    private void addEditPartAndParent(Set hosts, EditPart editPart) {
        hosts.add(editPart);
        hosts.add(editPart.getParent());
    }

    protected Diagram getDiagramView() {
        return (Diagram)this.getRoot().getContents().getModel();
    }

    public View getPrimaryView() {
        ConnectionEditPart parent = this;
        while (parent != null) {
            if (parent instanceof IPrimaryEditPart) {
                return (View)parent.getModel();
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected EditDomain getEditDomain() {
        return this.getRoot().getViewer().getEditDomain();
    }

    public IDiagramEditDomain getDiagramEditDomain() {
        return (IDiagramEditDomain)this.getEditDomain();
    }

    protected List getModelChildren() {
        return ((View)this.getModel()).getChildren();
    }

    public Object getStructuralFeatureValue(EStructuralFeature feature) {
        return ViewUtil.getStructuralFeatureValue((View)((View)this.getModel()), (EStructuralFeature)feature);
    }

    public EObject resolveSemanticElement() {
        EObject eObj = ((View)this.getModel()).getElement();
        if (eObj == null) {
            return null;
        }
        if (!eObj.eIsProxy()) {
            return eObj;
        }
        try {
            return (EObject)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(ViewUtil.resolveSemanticElement((View)((View)ConnectionEditPart.this.getModel())));
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"resolveSemanticElement", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"resolveSemanticElement", (Throwable)e);
            return null;
        }
    }

    public TopGraphicEditPart getTopGraphicEditPart() {
        ConnectionEditPart editPart = this;
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof TopGraphicEditPart) {
                return (TopGraphicEditPart)((Object)editPart);
            }
            editPart = editPart.getParent();
        }
        return null;
    }

    public View getNotationView() {
        Object model = this.getModel();
        if (model instanceof View) {
            return (View)model;
        }
        return null;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (this.isActive()) {
            this.handlePropertyChangeEvent(event);
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("connectionRouter")) {
            this.installRouter();
        }
    }

    public void reactivateSemanticModel() {
        this.removeSemanticListeners();
        if (this.resolveSemanticElement() != null) {
            this.addSemanticListeners();
        }
        this.refresh();
    }

    public EditPart findEditPart(EditPart epBegin, EObject theElement) {
        EObject el;
        if (theElement == null) {
            return null;
        }
        ConnectionEditPart epStart = null;
        epStart = epBegin == null ? this : epBegin;
        View view = (View)epStart.getAdapter(View.class);
        if (view != null && (el = ViewUtil.resolveSemanticElement((View)view)) != null && el.equals(theElement)) {
            return epStart;
        }
        ListIterator childLI = epStart.getChildren().listIterator();
        while (childLI.hasNext()) {
            EditPart epChild = (EditPart)childLI.next();
            EditPart elementEP = this.findEditPart(epChild, theElement);
            if (elementEP == null) continue;
            return elementEP;
        }
        return null;
    }

    protected void refreshForegroundColor() {
        LineStyle style = (LineStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.LINE_STYLE);
        if (style != null) {
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getLineColor())));
        }
    }

    protected void refreshVisibility() {
        this.setVisibility(((View)this.getModel()).isVisible());
    }

    protected void removeListenerFilter(String filterId) {
        if (this.listenerFilters == null) {
            return;
        }
        Object[] objects = (Object[])this.listenerFilters.get(filterId);
        if (objects == null) {
            return;
        }
        if (objects.length > 2) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)objects[0], (Object)((EStructuralFeature)objects[1]), (NotificationListener)objects[2]);
        } else {
            this.getDiagramEventBroker().removeNotificationListener((EObject)objects[0], (NotificationListener)objects[1]);
        }
        this.listenerFilters.remove(filterId);
    }

    protected void setForegroundColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    public void setStructuralFeatureValue(EStructuralFeature feature, Object value) {
        ViewUtil.setStructuralFeatureValue((View)((View)this.getModel()), (EStructuralFeature)feature, (Object)value);
    }

    protected void setVisibility(boolean vis) {
        if (!vis && this.getSelected() != 0) {
            this.getViewer().deselect((EditPart)this);
        }
        this.getFigure().setVisible(vis);
        this.getFigure().revalidate();
    }

    protected void addNotationalListeners() {
        this.addListenerFilter("View", this, (EObject)((View)this.getModel()));
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    protected void addSemanticListeners() {
        this.addListenerFilter("SemanticModel", this, this.resolveSemanticElement());
    }

    protected void removeNotationalListeners() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        this.removeListenerFilter("View");
    }

    protected void removeSemanticListeners() {
        this.removeListenerFilter("SemanticModel");
    }

    public void addNotify() {
        super.addNotify();
        this.installRouter();
    }

    public ConnectionEditPart(View view) {
        this.setModel(view);
    }

    protected abstract Connection createConnectionFigure();

    protected final IFigure createFigure() {
        return this.createConnectionFigure();
    }

    public void refresh() {
        if (this.getSource() != null && this.getTarget() != null) {
            try {
                this.getEditingDomain().runExclusive(new Runnable(){

                    public void run() {
                        ConnectionEditPart.super.refresh();
                        AbstractEditPart.EditPolicyIterator i = ConnectionEditPart.this.getEditPolicyIterator();
                        while (i.hasNext()) {
                            EditPolicy policy = i.next();
                            if (!(policy instanceof GraphicalEditPolicyEx)) continue;
                            ((GraphicalEditPolicyEx)policy).refresh();
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"refresh", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"refresh", (Throwable)e);
            }
        }
    }

    protected Edge getEdge() {
        return (Edge)this.getModel();
    }

    public DragTracker getDragTracker(Request req) {
        return new SelectConnectionEditPartTracker((org.eclipse.gef.ConnectionEditPart)this);
    }

    protected Object getModelSource() {
        return this.getEdge().getSource();
    }

    protected Object getModelTarget() {
        return this.getEdge().getTarget();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null && cLayer instanceof ConnectionLayerEx) {
            ConnectionLayerEx cLayerEx = (ConnectionLayerEx)cLayer;
            Routing routing = style.getRouting();
            if (Routing.MANUAL_LITERAL == routing) {
                this.getConnectionFigure().setConnectionRouter(cLayerEx.getObliqueRouter());
            } else if (Routing.RECTILINEAR_LITERAL == routing) {
                this.getConnectionFigure().setConnectionRouter(cLayerEx.getRectilinearRouter());
            } else if (Routing.TREE_LITERAL == routing) {
                this.getConnectionFigure().setConnectionRouter(cLayerEx.getTreeRouter());
            }
        }
        this.refreshRouterChange();
    }

    protected void refreshBendpoints() {
        RelativeBendpoints bendpoints = (RelativeBendpoints)this.getEdge().getBendpoints();
        List modelConstraint = bendpoints.getPoints();
        ArrayList<RelativeBendpoint> figureConstraint = new ArrayList<RelativeBendpoint>();
        int i = 0;
        while (i < modelConstraint.size()) {
            org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint wbp = (org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint)modelConstraint.get(i);
            RelativeBendpoint rbp = new RelativeBendpoint(this.getConnectionFigure());
            rbp.setRelativeDimensions(new Dimension(wbp.getSourceX(), wbp.getSourceY()), new Dimension(wbp.getTargetX(), wbp.getTargetY()));
            rbp.setWeight((float)(i + 1) / ((float)modelConstraint.size() + 1.0f));
            figureConstraint.add(rbp);
            ++i;
        }
        this.getConnectionFigure().setRoutingConstraint(figureConstraint);
    }

    private void installBendpointEditPolicy() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ForestRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new TreeConnectionBendpointEditPolicy());
        } else if (this.getConnectionFigure().getConnectionRouter() instanceof OrthogonalRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionLineSegEditPolicy());
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ConnectionBendpointEditPolicy());
        }
        EditPartUtil.synchronizeRunnableToMainThread(this, new Runnable(){

            public void run() {
                if (ConnectionEditPart.this.getConnectionFigure().getConnectionRouter() instanceof ForestRouter) {
                    ConnectionEditPart.this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_MOVE);
                } else if (ConnectionEditPart.this.getConnectionFigure().getConnectionRouter() instanceof OrthogonalRouter) {
                    ConnectionEditPart.this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_MOVE);
                } else {
                    ConnectionEditPart.this.getConnectionFigure().setCursor(Cursors.CURSOR_SEG_ADD);
                }
            }
        });
    }

    protected void refreshRouterChange() {
        this.refreshBendpoints();
        this.installBendpointEditPolicy();
    }

    protected void refreshSmoothness() {
        Connection connection = this.getConnectionFigure();
        if (!(connection instanceof PolylineConnectionEx)) {
            return;
        }
        PolylineConnectionEx poly = (PolylineConnectionEx)connection;
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null) {
            Smoothness smoothness = style.getSmoothness();
            if (Smoothness.LESS_LITERAL == smoothness) {
                poly.setSmoothness(16);
            } else if (Smoothness.NORMAL_LITERAL == smoothness) {
                poly.setSmoothness(32);
            } else if (Smoothness.MORE_LITERAL == smoothness) {
                poly.setSmoothness(64);
            } else if (Smoothness.NONE_LITERAL == smoothness) {
                poly.setSmoothness(0);
            }
        }
    }

    protected void refreshJumplinks() {
        Connection connection = this.getConnectionFigure();
        if (!(connection instanceof PolylineConnectionEx)) {
            return;
        }
        PolylineConnectionEx poly = (PolylineConnectionEx)connection;
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        JumpLinkStatus status = JumpLinkStatus.NONE_LITERAL;
        JumpLinkType type = JumpLinkType.SEMICIRCLE_LITERAL;
        boolean reverse = false;
        if (style != null) {
            status = style.getJumpLinkStatus();
            type = style.getJumpLinkType();
            reverse = style.isJumpLinksReverse();
        }
        int jumpType = 0;
        if (JumpLinkStatus.BELOW_LITERAL == status) {
            jumpType = 16384;
        } else if (JumpLinkStatus.ABOVE_LITERAL == status) {
            jumpType = 32768;
        } else if (JumpLinkStatus.ALL_LITERAL == status) {
            jumpType = 49152;
        }
        boolean bCurved = type.equals(JumpLinkType.SEMICIRCLE_LITERAL);
        boolean bAngleIn = !type.equals(JumpLinkType.SQUARE_LITERAL);
        boolean bOnBottom = reverse;
        poly.setJumpLinks(jumpType != 0);
        poly.setJumpLinksStyles(jumpType, bCurved, bAngleIn, bOnBottom);
    }

    protected void refreshRoutingStyles() {
        Connection connection = this.getConnectionFigure();
        if (!(connection instanceof PolylineConnectionEx)) {
            return;
        }
        PolylineConnectionEx poly = (PolylineConnectionEx)connection;
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null) {
            boolean closestDistance = style.isClosestDistance();
            boolean avoidObstruction = style.isAvoidObstructions();
            poly.setRoutingStyles(closestDistance, avoidObstruction);
            if (avoidObstruction) {
                this.installEditPolicy("Connection Bendpoint Policy", null);
            } else {
                this.installBendpointEditPolicy();
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshVisibility();
        this.refreshForegroundColor();
        this.refreshRoutingStyles();
        this.refreshSmoothness();
        this.refreshJumplinks();
        this.refreshBendpoints();
        this.refreshFont();
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style != null) {
            this.setFont(new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0)));
        }
    }

    protected void setFont(FontData fontData) {
        if (this.cachedFontData != null && this.cachedFontData.equals((Object)fontData)) {
            return;
        }
        try {
            Font newFont = this.getResourceManager().createFont(FontDescriptor.createFrom((FontData)fontData));
            this.getFigure().setFont(newFont);
            this.getFigure().repaint();
            if (this.cachedFontData != null) {
                this.getResourceManager().destroyFont(FontDescriptor.createFrom((FontData)this.cachedFontData));
            }
            this.cachedFontData = fontData;
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"setFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"setFont", (Throwable)e);
        }
    }

    protected String[] getAppearancePropertyIDs() {
        return appearanceProperties;
    }

    public void performRequest(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        if ("direct edit" == request.getType()) {
            this.performDirectEditRequest(request);
        } else {
            Command command;
            EditPart targetEditPart = this.getTargetEditPart(request);
            if (targetEditPart != null && (command = targetEditPart.getCommand(request)) != null) {
                this.getDiagramEditDomain().getDiagramCommandStack().execute(command);
                return;
            }
        }
    }

    protected void performDirectEditRequest(Request request) {
        try {
            EditPart primaryChildEditPart = (EditPart)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    this.setResult(ConnectionEditPart.this.getPrimaryChildEditPart());
                }
            });
            if (primaryChildEditPart != null) {
                primaryChildEditPart.performRequest(request);
            }
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"performDirectEditRequest", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"performDirectEditRequest", (Throwable)e);
        }
    }

    public boolean understandsRequest(Request req) {
        return "direct edit" == req.getType() || super.understandsRequest(req);
    }

    protected void registerModel() {
        super.registerModel();
        EObject ref = ((View)this.getModel()).getElement();
        if (ref == null) {
            return;
        }
        this.elementGuid = EMFCoreUtil.getProxyID((EObject)ref);
        ((IDiagramGraphicalViewer)this.getViewer()).registerEditPartForElement(this.elementGuid, (EditPart)this);
    }

    protected void unregisterModel() {
        super.unregisterModel();
        ((IDiagramGraphicalViewer)this.getViewer()).unregisterEditPartForElement(this.elementGuid, (EditPart)this);
    }

    protected final void handleMajorSemanticChange() {
        if (this.getSource() instanceof GraphicalEditPart && this.getTarget() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)this.getSource()).refreshSourceConnection(this);
            ((GraphicalEditPart)this.getTarget()).refreshTargetConnection(this);
        }
    }

    final void refreshChild(GraphicalEditPart child) {
        this.removeChild((EditPart)child);
        this.refreshChildren();
    }

    public final boolean isCanonical() {
        return this.getEditPolicy("Canonical") != null;
    }

    public boolean isSelectable() {
        return this.getFigure().isVisible();
    }

    public void disableEditMode() {
        if (!this.isEditable) {
            return;
        }
        List l = this.getSourceConnections();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Object obj = l.get(i);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).disableEditMode();
            }
            ++i;
        }
        List c = this.getChildren();
        size = c.size();
        int i2 = 0;
        while (i2 < size) {
            Object obj = c.get(i2);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).disableEditMode();
            }
            ++i2;
        }
        this.isEditable = false;
    }

    public void enableEditMode() {
        if (this.isEditable) {
            return;
        }
        this.isEditable = true;
        List c = this.getChildren();
        int size = c.size();
        int i = 0;
        while (i < size) {
            Object obj = c.get(i);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).enableEditMode();
            }
            ++i;
        }
        List l = this.getSourceConnections();
        size = l.size();
        int i2 = 0;
        while (i2 < size) {
            Object obj = l.get(i2);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).enableEditMode();
            }
            ++i2;
        }
    }

    public boolean isEditModeEnabled() {
        if (EditPartUtil.isWriteTransactionInProgress(this, true, true)) {
            return false;
        }
        return this.isEditable;
    }

    public void showSourceFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.showSourceFeedback(request);
    }

    public void showTargetFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.showTargetFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.eraseSourceFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.eraseTargetFeedback(request);
    }

    public EditPart getPrimaryChildEditPart() {
        if (this.getChildren().size() > 0) {
            return (EditPart)this.getChildren().get(0);
        }
        return null;
    }

    public PreferencesHint getDiagramPreferencesHint() {
        RootEditPart root = this.getRoot();
        if (root instanceof IDiagramPreferenceSupport) {
            return ((IDiagramPreferenceSupport)root).getPreferencesHint();
        }
        return PreferencesHint.USE_DEFAULTS;
    }

    public void notifyChanged(Notification notification) {
        if (this.isActive()) {
            this.handleNotificationEvent(notification);
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.Literals.VIEW__PERSISTED_CHILDREN.equals(feature) || NotationPackage.Literals.VIEW__TRANSIENT_CHILDREN.equals(feature)) {
            this.refreshChildren();
        } else if (NotationPackage.Literals.VIEW__VISIBLE.equals(feature)) {
            Object notifier = event.getNotifier();
            if (notifier == this.getModel()) {
                this.setVisibility((Boolean)event.getNewValue());
            }
        } else if (NotationPackage.Literals.ROUTING_STYLE__ROUTING.equals(feature)) {
            this.installRouter();
        } else if (NotationPackage.Literals.ROUTING_STYLE__SMOOTHNESS.equals(feature) || NotationPackage.Literals.ROUTING_STYLE__AVOID_OBSTRUCTIONS.equals(feature) || NotationPackage.Literals.ROUTING_STYLE__CLOSEST_DISTANCE.equals(feature) || NotationPackage.Literals.ROUTING_STYLE__JUMP_LINK_STATUS.equals(feature) || NotationPackage.Literals.ROUTING_STYLE__JUMP_LINK_TYPE.equals(feature) || NotationPackage.Literals.ROUTING_STYLE__JUMP_LINKS_REVERSE.equals(feature)) {
            this.refreshVisuals();
        } else if (NotationPackage.Literals.LINE_STYLE__LINE_COLOR.equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.Literals.RELATIVE_BENDPOINTS__POINTS.equals(feature)) {
            this.refreshBendpoints();
        } else if (event.getFeature() == NotationPackage.Literals.VIEW__ELEMENT && (EObject)event.getNotifier() == this.getNotationView()) {
            this.handleMajorSemanticChange();
        } else if (event.getEventType() == 1003 && event.getNotifier() == ((View)this.getModel()).getElement()) {
            this.handleMajorSemanticChange();
        }
    }

    protected IMapMode getMapMode() {
        RootEditPart root = this.getRoot();
        if (root instanceof DiagramRootEditPart) {
            DiagramRootEditPart dgrmRoot = (DiagramRootEditPart)root;
            return dgrmRoot.getMapMode();
        }
        return MapModeUtil.getMapMode();
    }

    public TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = TransactionUtil.getEditingDomain((Object)this.getModel());
            if (this.editingDomain == null) {
                this.editingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagramView());
            }
        }
        return this.editingDomain;
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        Object preferenceStore = this.getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore) {
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.lineColor"));
            }
            if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.fontColor"));
            }
        }
        return this.getStructuralFeatureValue(feature);
    }

    protected ResourceManager getResourceManager() {
        EditPartViewer viewer = this.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            return ((DiagramGraphicalViewer)viewer).getResourceManager();
        }
        return JFaceResources.getResources();
    }

    public boolean isSemanticConnection() {
        if (this.semanticConnection == null) {
            this.semanticConnection = this.getEdge() != null && (this.getEdge().getElement() != null || !NotationTypeUtil.hasNotationType((View)this.getEdge())) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.semanticConnection;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.semanticConnection = null;
    }
}

