/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.map.editor.part;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramEditorPlugin;
import org.eclipse.gmf.map.editor.part.GMFMapDiagramFileCreator;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class GMFMapDiagramEditorUtil {
    public static final URI createAndOpenDiagram(GMFMapDiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow window, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram) {
        IFile diagramFile = GMFMapDiagramEditorUtil.createNewDiagramFile(diagramFileCreator, containerPath, fileName, initialContents, kind, window.getShell(), progressMonitor);
        if (diagramFile != null && openEditor) {
            GMFMapDiagramEditorUtil.openDiagramEditor(window, diagramFile, saveDiagram, progressMonitor);
        }
        return URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString());
    }

    public static final IEditorPart openDiagramEditor(IWorkbenchWindow window, IFile file, boolean saveDiagram, IProgressMonitor progressMonitor) {
        IEditorPart editorPart = null;
        try {
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                editorPart = GMFMapDiagramEditorUtil.openDiagramEditor(page, file);
                if (saveDiagram) {
                    editorPart.doSave(progressMonitor);
                }
            }
            file.refreshLocal(0, null);
            return editorPart;
        }
        catch (Exception e) {
            GMFMapDiagramEditorPlugin.getInstance().logError("Error opening diagram", e);
            return null;
        }
    }

    public static final IEditorPart openDiagramEditor(IWorkbenchPage page, IFile file) throws PartInitException {
        return IDE.openEditor((IWorkbenchPage)page, (IFile)file);
    }

    public static final IFile createNewDiagramFile(final GMFMapDiagramFileCreator diagramFileCreator, IPath containerFullPath, String fileName, InputStream initialContents, String kind, Shell shell, IProgressMonitor progressMonitor) {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        ResourceSet resourceSet = editingDomain.getResourceSet();
        progressMonitor.beginTask("Creating diagram and model files", 3);
        final IFile diagramFile = diagramFileCreator.createNewFile(containerFullPath, fileName, initialContents, shell);
        final Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString()));
        ArrayList<IFile> affectedFiles = new ArrayList<IFile>();
        affectedFiles.add(diagramFile);
        IPath modelFileRelativePath = diagramFile.getFullPath().removeFileExtension().addFileExtension("gmfmap");
        IFile modelFile = diagramFile.getParent().getFile((IPath)new Path(modelFileRelativePath.lastSegment()));
        final Resource modelResource = resourceSet.createResource(URI.createPlatformResourceURI((String)modelFile.getFullPath().toString()));
        affectedFiles.add(modelFile);
        final String kindParam = kind;
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Creating diagram and model", affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Mapping model = diagramFileCreator.getWizard().createInitialModel();
                modelResource.getContents().add((Object)GMFMapDiagramEditorUtil.createInitialRoot(model));
                Diagram diagram = ViewService.createDiagram((EObject)model, (String)kindParam, (PreferencesHint)GMFMapDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (diagram != null) {
                    diagramResource.getContents().add((Object)diagram);
                    diagram.setName(diagramFile.getName());
                    diagram.setElement((EObject)model);
                }
                try {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("ENCODING", "UTF-8");
                    modelResource.save(options);
                    diagramResource.save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    GMFMapDiagramEditorPlugin.getInstance().logError("Unable to store model and diagram resources", e);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1), null);
        }
        catch (ExecutionException e) {
            GMFMapDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        try {
            modelFile.setCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (CoreException e) {
            GMFMapDiagramEditorPlugin.getInstance().logError("Unable to set charset for model file", e);
        }
        try {
            diagramFile.setCharset("UTF-8", (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        }
        catch (CoreException e) {
            GMFMapDiagramEditorPlugin.getInstance().logError("Unable to set charset for diagram file", e);
        }
        return diagramFile;
    }

    private static Mapping createInitialModel() {
        return GMFMapFactory.eINSTANCE.createMapping();
    }

    private static EObject createInitialRoot(Mapping model) {
        return model;
    }
}

