/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gmf.gmfgraph.ConnectionFigure;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalleryMirrorProcessor
extends GalleryProcessor {
    private final Map<FigureDescriptor, String> myFigure2FQN = new IdentityHashMap<FigureDescriptor, String>();
    private String myGeneratedBundle;

    public GalleryMirrorProcessor(FigureGallery[] input) {
        super(input);
    }

    @Override
    public void go(StandaloneGenerator.ProcessorCallback callback, StandaloneGenerator.Config config) throws InterruptedException {
        super.go(callback, config);
        this.myGeneratedBundle = config.getPluginID();
    }

    public FigureGallery convertFigureGallery() {
        FigureGallery result = GMFGraphFactory.eINSTANCE.createFigureGallery();
        result.setName("GeneratedGallery");
        result.setImplementationBundle(this.myGeneratedBundle);
        for (FigureDescriptor fd : this.myFigure2FQN.keySet()) {
            Figure nextOriginal = fd.getActualFigure();
            String nextConvertedFqn = this.myFigure2FQN.get(fd);
            CustomFigure custom = GalleryMirrorProcessor.createCustomFigure(nextOriginal);
            custom.setName(fd.getName());
            custom.setQualifiedClassName(nextConvertedFqn);
            result.getFigures().add((Object)custom);
        }
        return result;
    }

    public Map<FigureDescriptor, String> getGenerationInfo() {
        return Collections.unmodifiableMap(this.myFigure2FQN);
    }

    @Override
    protected void handle(FigureDescriptor next, String fqn) {
        this.myFigure2FQN.put(next, fqn);
    }

    static CustomFigure createCustomFigure(Figure original) {
        GMFGraphFactory factory = GMFGraphFactory.eINSTANCE;
        if (original instanceof DecorationFigure) {
            return factory.createCustomDecoration();
        }
        if (original instanceof ConnectionFigure) {
            return factory.createCustomConnection();
        }
        return factory.createCustomFigure();
    }
}

