/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.genmodel;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.gmf.codegen.gmfgen.ParentAssignedViewmap;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureDescriptor;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.RealFigure;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeLiteFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.eclipse.gmf.graphdef.codegen.MapModeCodeGenStrategy;
import org.eclipse.gmf.internal.bridge.genmodel.DefaultViewmapProducer;

public class InnerClassViewmapProducer
extends DefaultViewmapProducer {
    private final FigureGenerator figureGenerator;
    private final FigureQualifiedNameSwitch fqnSwitch;

    public InnerClassViewmapProducer() {
        this(null, MapModeCodeGenStrategy.DYNAMIC, null);
    }

    public InnerClassViewmapProducer(String runtimeToken, MapModeCodeGenStrategy mapModeCodeGenStrategy, URL[] dynamicFigureTemplates) {
        this.fqnSwitch = "lite".equalsIgnoreCase(runtimeToken) ? new RuntimeLiteFQNSwitch() : new RuntimeFQNSwitch();
        this.figureGenerator = new FigureGenerator(runtimeToken, null, mapModeCodeGenStrategy, null, true, dynamicFigureTemplates);
    }

    public Viewmap create(Node node) {
        if (node.getFigure() == null) {
            return super.create(node);
        }
        Viewmap viewmap = this.createViewmap(node.getFigure());
        this.setupResizeConstraints(viewmap, node);
        this.setupLayoutType(viewmap, node);
        this.setupDefaultSize(viewmap, node);
        return viewmap;
    }

    public Viewmap create(Connection link) {
        if (link.getFigure() == null) {
            return super.create(link);
        }
        return this.createViewmap(link.getFigure());
    }

    public Viewmap create(DiagramLabel diagramLabel) {
        if (diagramLabel.getFigure() == null) {
            return super.create(diagramLabel);
        }
        if (diagramLabel.getAccessor() == null) {
            return this.createViewmap(diagramLabel.getFigure());
        }
        return this.createViewmap(diagramLabel.getFigure(), diagramLabel.getAccessor());
    }

    public Viewmap create(Compartment compartment) {
        if (compartment.getFigure() == null) {
            return super.create(compartment);
        }
        if (compartment.getAccessor() == null) {
            return this.createViewmap(compartment.getFigure());
        }
        return this.createViewmap(compartment.getFigure(), compartment.getAccessor());
    }

    private Viewmap createViewmap(FigureDescriptor figureDescriptor) {
        FigureViewmap result;
        if (figureDescriptor.getActualFigure() == null) {
            throw new NullPointerException();
        }
        Figure figure = figureDescriptor.getActualFigure();
        if (figure instanceof RealFigure && InnerClassViewmapProducer.isBareInstance((RealFigure)figure)) {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName(this.figureGenerator.fqnSwitch(figure));
            result = v;
        } else {
            InnerClassViewmap v = GMFGenFactory.eINSTANCE.createInnerClassViewmap();
            v.setClassBody(this.figureGenerator.go(figureDescriptor));
            v.setClassName(InnerClassViewmapProducer.getCompilationUnitName(figureDescriptor));
            result = v;
        }
        this.setupPluginDependencies((Viewmap)result, figureDescriptor.getActualFigure());
        this.setupStyleAttributes((Viewmap)result, figureDescriptor.getActualFigure());
        return result;
    }

    private Viewmap createViewmap(FigureDescriptor owner, ChildAccess labelAccess) {
        ParentAssignedViewmap v = GMFGenFactory.eINSTANCE.createParentAssignedViewmap();
        v.setGetterName(labelAccess.getAccessor());
        v.setFigureQualifiedClassName(this.figureGenerator.fqnSwitch(labelAccess.getFigure()));
        this.setupStyleAttributes((Viewmap)v, labelAccess.getFigure());
        return v;
    }

    private void setupPluginDependencies(Viewmap viewmap, Figure figure) {
        FigureGallery gallery = InnerClassViewmapProducer.findAncestorFigureGallery(figure);
        if (gallery != null) {
            viewmap.getRequiredPluginIDs().addAll((Collection)Arrays.asList(this.fqnSwitch.getDependencies(gallery)));
        }
    }

    public static FigureGallery findAncestorFigureGallery(Figure figure) {
        Figure current = figure;
        EObject next;
        while ((next = current.eContainer()) != null) {
            if (next instanceof FigureGallery) {
                return (FigureGallery)next;
            }
            current = next;
        }
        return null;
    }

    private static String getCompilationUnitName(FigureDescriptor fd) {
        return CodeGenUtil.validJavaIdentifier((String)CodeGenUtil.capName((String)fd.getName()));
    }

    private static boolean isBareInstance(RealFigure figure) {
        if (!figure.getChildren().isEmpty()) {
            return false;
        }
        LinkedList featuresToCheck = new LinkedList(figure.eClass().getEAllStructuralFeatures());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getRealFigure_Name());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getRealFigure_Children());
        if (figure instanceof CustomFigure) {
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_QualifiedClassName());
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomFigure_CustomChildren());
        }
        for (EStructuralFeature next : featuresToCheck) {
            if (next.isDerived() || !figure.eIsSet(next)) continue;
            return false;
        }
        return true;
    }
}

