/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenMetricRule;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MetricRule;
import org.eclipse.gmf.mappings.NodeMapping;

public class History {
    private final Map<NodeMapping, GenTopLevelNode> myTopNodeMap = new HashMap<NodeMapping, GenTopLevelNode>();
    private final Map<NodeMapping, Set<GenChildNode>> myNodeMap = new HashMap<NodeMapping, Set<GenChildNode>>();
    private final Map<LinkMapping, GenLink> myLinkMap = new HashMap<LinkMapping, GenLink>();
    private final Map<MetricRule, GenMetricRule> myMetricMap = new HashMap<MetricRule, GenMetricRule>();

    public void log(NodeMapping nodeMap, GenTopLevelNode genNode) {
        assert (nodeMap != null && genNode != null && !this.myTopNodeMap.containsKey(nodeMap));
        this.myTopNodeMap.put(nodeMap, genNode);
    }

    public void log(NodeMapping nodeMap, GenChildNode genNode) {
        assert (nodeMap != null && genNode != null);
        Set<GenChildNode> genNodes = this.myNodeMap.get(nodeMap);
        if (genNodes == null) {
            genNodes = new HashSet<GenChildNode>();
            this.myNodeMap.put(nodeMap, genNodes);
        }
        genNodes.add(genNode);
    }

    public void log(LinkMapping linkMap, GenLink genLink) {
        assert (linkMap != null && genLink != null && !this.myLinkMap.containsKey(linkMap));
        this.myLinkMap.put(linkMap, genLink);
    }

    public void log(MetricRule metric, GenMetricRule genMetric) {
        assert (metric != null && genMetric != null);
        this.myMetricMap.put(metric, genMetric);
    }

    public GenMetricRule find(MetricRule metric) {
        assert (metric != null);
        return this.myMetricMap.get(metric);
    }

    public boolean isKnown(NodeMapping nodeMap) {
        return this.isKnownTopNode(nodeMap) || this.isKnownChildNode(nodeMap);
    }

    public boolean isKnownTopNode(NodeMapping nodeMap) {
        assert (nodeMap != null);
        return this.myTopNodeMap.containsKey(nodeMap);
    }

    public boolean isKnownChildNode(NodeMapping nodeMap) {
        assert (nodeMap != null);
        return this.myNodeMap.containsKey(nodeMap);
    }

    public boolean isKnown(LinkMapping linkMap) {
        assert (linkMap != null);
        return this.myLinkMap.containsKey(linkMap);
    }

    public GenChildNode[] findChildNodes(NodeMapping nodeMap) {
        assert (nodeMap != null);
        Set<GenChildNode> genNodes = this.myNodeMap.get(nodeMap);
        if (genNodes == null) {
            return new GenChildNode[0];
        }
        return genNodes.toArray(new GenChildNode[genNodes.size()]);
    }

    public GenTopLevelNode findTopNode(NodeMapping nodeMap) {
        assert (nodeMap != null);
        return this.myTopNodeMap.get(nodeMap);
    }

    public GenNode[] find(NodeMapping nodeMap) {
        GenNode[] genNodeArray;
        assert (nodeMap != null);
        GenTopLevelNode genNode = this.findTopNode(nodeMap);
        if (genNode != null) {
            GenNode[] genNodeArray2 = new GenNode[1];
            genNodeArray = genNodeArray2;
            genNodeArray2[0] = genNode;
        } else {
            genNodeArray = this.findChildNodes(nodeMap);
        }
        return genNodeArray;
    }

    public GenLink find(LinkMapping linkMap) {
        assert (linkMap != null);
        return this.myLinkMap.get(linkMap);
    }

    public void purge() {
        this.myTopNodeMap.clear();
        this.myNodeMap.clear();
        this.myLinkMap.clear();
        this.myMetricMap.clear();
    }
}

