/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.part;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.ecore.part.EcoreDiagramEditorUtil;
import org.eclipse.gmf.ecore.part.EcoreVisualIDRegistry;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class EcoreNewDiagramFileWizard
extends Wizard {
    private TransactionalEditingDomain myEditingDomain;
    private WizardNewFileCreationPage myFileCreationPage;
    private IFile mySelectedModelFile;
    private IWorkbenchPage myWorkbenchPage;
    private IStructuredSelection mySelection;
    private EObject myDiagramRoot;

    public EcoreNewDiagramFileWizard(IFile selectedModelFile, IWorkbenchPage workbenchPage, IStructuredSelection selection, EObject diagramRoot, TransactionalEditingDomain editingDomain) {
        assert (selectedModelFile != null) : "Null selectedModelFile in EcoreNewDiagramFileWizard constructor";
        assert (workbenchPage != null) : "Null workbenchPage in EcoreNewDiagramFileWizard constructor";
        assert (selection != null) : "Null selection in EcoreNewDiagramFileWizard constructor";
        assert (diagramRoot != null) : "Null diagramRoot in EcoreNewDiagramFileWizard constructor";
        assert (editingDomain != null) : "Null editingDomain in EcoreNewDiagramFileWizard constructor";
        this.mySelectedModelFile = selectedModelFile;
        this.myWorkbenchPage = workbenchPage;
        this.mySelection = selection;
        this.myDiagramRoot = diagramRoot;
        this.myEditingDomain = editingDomain;
    }

    public void addPages() {
        this.myFileCreationPage = new WizardNewFileCreationPage("Initialize new Ecore diagram file", this.mySelection){

            public void createControl(Composite parent) {
                super.createControl(parent);
                IContainer parentContainer = EcoreNewDiagramFileWizard.this.mySelectedModelFile.getParent();
                String originalFileName = EcoreNewDiagramFileWizard.this.mySelectedModelFile.getProjectRelativePath().removeFileExtension().lastSegment();
                String fileExtension = ".ecore_diagram";
                String fileName = String.valueOf(originalFileName) + fileExtension;
                int i = 1;
                while (parentContainer.getFile((IPath)new Path(fileName)).exists()) {
                    fileName = String.valueOf(originalFileName) + i + fileExtension;
                    ++i;
                }
                this.setFileName(fileName);
            }
        };
        this.myFileCreationPage.setTitle("Diagram file");
        this.myFileCreationPage.setDescription("Create new diagram based on Ecore model content");
        this.addPage((IWizardPage)this.myFileCreationPage);
        this.addPage((IWizardPage)new RootElementSelectorPage());
    }

    public boolean performFinish() {
        IFile diagramFile = this.myFileCreationPage.createNewFile();
        try {
            diagramFile.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to set charset for diagram file", e);
        }
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString(), (boolean)true));
        LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
        affectedFiles.add(this.mySelectedModelFile);
        affectedFiles.add(diagramFile);
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(this.myEditingDomain, "Initializing diagram contents", affectedFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                int diagramVID = EcoreVisualIDRegistry.getDiagramVisualID(EcoreNewDiagramFileWizard.this.myDiagramRoot);
                if (diagramVID != 1000) {
                    return CommandResult.newErrorCommandResult((String)"Incorrect model object stored as a root resource object");
                }
                Diagram diagram = ViewService.createDiagram((EObject)EcoreNewDiagramFileWizard.this.myDiagramRoot, (String)"Ecore", (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                diagramResource.getContents().add((Object)diagram);
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
            diagramResource.save(Collections.EMPTY_MAP);
            EcoreDiagramEditorUtil.openDiagram(diagramResource);
        }
        catch (ExecutionException e) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
        }
        catch (IOException ex) {
            EcoreDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramFile.getFullPath().toString(), ex);
        }
        catch (PartInitException ex) {
            EcoreDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
        }
        return true;
    }

    private class RootElementSelectorPage
    extends WizardPage
    implements ISelectionChangedListener {
        protected RootElementSelectorPage() {
            super("Select diagram root element");
            this.setTitle("Diagram root element");
            this.setDescription("Select semantic model element to be depicted on diagram");
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite topLevel = new Composite(parent, 0);
            topLevel.setLayout((Layout)new GridLayout());
            topLevel.setLayoutData((Object)new GridData(272));
            topLevel.setFont(parent.getFont());
            this.setControl((Control)topLevel);
            this.createModelBrowser(topLevel);
            this.setPageComplete(this.validatePage());
        }

        private void createModelBrowser(Composite parent) {
            Composite panel = new Composite(parent, 0);
            panel.setLayoutData((Object)new GridData(1808));
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            panel.setLayout((Layout)layout);
            Label label = new Label(panel, 0);
            label.setText("Select diagram root element:");
            label.setLayoutData((Object)new GridData(32));
            TreeViewer treeViewer = new TreeViewer(panel, 2820);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = 300;
            layoutData.widthHint = 300;
            treeViewer.getTree().setLayoutData((Object)layoutData);
            treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(EcoreDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()));
            treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(EcoreDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()));
            treeViewer.setInput((Object)EcoreNewDiagramFileWizard.this.myDiagramRoot.eResource());
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)EcoreNewDiagramFileWizard.this.myDiagramRoot));
            treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            EcoreNewDiagramFileWizard.this.myDiagramRoot = null;
            if (event.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)event.getSelection()).size() == 1) {
                Object selectedElement = selection.getFirstElement();
                if (selectedElement instanceof IWrapperItemProvider) {
                    selectedElement = ((IWrapperItemProvider)selectedElement).getValue();
                }
                if (selectedElement instanceof FeatureMap.Entry) {
                    selectedElement = ((FeatureMap.Entry)selectedElement).getValue();
                }
                if (selectedElement instanceof EObject) {
                    EcoreNewDiagramFileWizard.this.myDiagramRoot = (EObject)selectedElement;
                }
            }
            this.setPageComplete(this.validatePage());
        }

        private boolean validatePage() {
            if (EcoreNewDiagramFileWizard.this.myDiagramRoot == null) {
                this.setErrorMessage("No diagram root element selected");
                return false;
            }
            boolean result = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(EcoreNewDiagramFileWizard.this.myDiagramRoot), "Ecore", EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(result ? null : "Invalid diagram root element was selected");
            return result;
        }
    }
}

