/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.dialogs.IShowRelatedElementsWithDetails;
import org.eclipse.gmf.runtime.common.ui.dialogs.SelectableElement;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsPreset;
import org.eclipse.gmf.runtime.common.ui.dialogs.ShowRelatedElementsPresetHelper;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIDebugOptions;
import org.eclipse.gmf.runtime.common.ui.internal.CommonUIPlugin;
import org.eclipse.gmf.runtime.common.ui.internal.l10n.CommonUIMessages;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ShowRelatedElementsPredefinedComposite
extends Composite {
    protected Button saveAs;
    protected Button delete;
    protected Button details;
    protected IShowRelatedElementsWithDetails showDetails;
    protected SelectableElement rootElement;
    protected boolean isDetails = false;
    protected org.eclipse.swt.widgets.List predefinedBox;
    protected List predefined = new ArrayList();
    protected List queries;
    protected final IDialogSettings dialogSettings = CommonUIPlugin.getDefault().getDialogSettings();
    public static int VIEWER_HEIGHT = 225;
    protected int viewerWidth = 175;
    private static int PRESET_NAME_LENGTH = 256;
    protected InputDialog saveAsDialog = new InputDialog(Display.getDefault().getActiveShell(), CommonUIMessages.ShowRelatedElementsPredefinedComposite_SaveAs_Title, CommonUIMessages.ShowRelatedElementsPredefinedComposite_ChooseName, "", new IInputValidator(){

        public String isValid(String newText) {
            if (ShowRelatedElementsPredefinedComposite.this.containsSpecialCharacter(newText) || newText.length() == 0) {
                return CommonUIMessages.ShowRelatedElementsPredefinedComposite_SpecialCharacter;
            }
            return null;
        }
    }){

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            Text text = this.getText();
            if (!$assertionsDisabled && text == null) {
                throw new AssertionError();
            }
            text.setTextLimit(30);
            text.setTextLimit(PRESET_NAME_LENGTH);
            return control;
        }
    };
    protected static final String SPECIAL_OPENING = "[";
    protected static final String SPECIAL_CLOSING = "]";
    protected static final String DIALOG_SETTINGS_KEY = "ShowRelatedElementsPresets";
    protected static final String DEFAULT_STRING;

    static {
        try {
            VIEWER_HEIGHT = Integer.parseInt(CommonUIMessages.ShowRelatedElementsDialog_VIEWER_HEIGHT);
        }
        catch (NumberFormatException e) {
            Trace.catching((Plugin)CommonUIPlugin.getDefault(), (String)CommonUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)CommonUIPlugin.getDefault())).getClass(), (String)"NumberFormatException", (Throwable)e);
            Log.error((Plugin)CommonUIPlugin.getDefault(), (int)5, (String)"Failed to parse Show Related Elements Composite's localized size", (Throwable)e);
        }
        DEFAULT_STRING = SPECIAL_OPENING + CommonUIMessages.ShowRelatedElementsPredefinedComposite_DefaultQuery + SPECIAL_CLOSING;
    }

    public ShowRelatedElementsPredefinedComposite(Composite parent, IShowRelatedElementsWithDetails sreWithDetails, SelectableElement root, List queriesList, int width, boolean detailsShown) {
        super(parent, 0);
        this.showDetails = sreWithDetails;
        this.rootElement = root;
        this.queries = queriesList;
        this.viewerWidth = width;
        this.isDetails = detailsShown;
        this.createContents();
    }

    private void setDetailsText() {
        assert (this.details != null);
        if (!this.isDetails) {
            this.details.setText(CommonUIMessages.ShowRelatedElementsPredefinedComposite_ShowDetails);
        } else {
            this.details.setText(CommonUIMessages.ShowRelatedElementsPredefinedComposite_HideDetails);
        }
    }

    protected void createContents() {
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout(1, false));
        new Label((Composite)this, 0).setText(CommonUIMessages.ShowRelatedElementsPredefinedComposite_CustomQuery);
        this.predefinedBox = new org.eclipse.swt.widgets.List((Composite)this, 2816);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = VIEWER_HEIGHT;
        gd.widthHint = this.viewerWidth;
        this.predefinedBox.setLayoutData((Object)gd);
        if (this.showDetails == null) {
            Composite buttons = new Composite((Composite)this, 0);
            buttons.setLayout((Layout)new GridLayout(2, true));
            gd = new GridData(72);
            gd.horizontalSpan = 2;
            buttons.setLayoutData((Object)gd);
            this.makePredefinedSettingsButtons(buttons);
        } else {
            Composite moreButtons = new Composite((Composite)this, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            moreButtons.setLayout((Layout)gridLayout);
            moreButtons.setLayoutData((Object)new GridData(776));
            Composite buttons = new Composite(moreButtons, 0);
            gridLayout = new GridLayout(2, true);
            gridLayout.marginWidth = 0;
            buttons.setLayout((Layout)gridLayout);
            buttons.setLayoutData((Object)new GridData(32));
            this.makePredefinedSettingsButtons(buttons);
            this.details = new Button(moreButtons, 8);
            this.setDetailsText();
            this.details.setLayoutData((Object)new GridData(640));
            this.details.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ShowRelatedElementsPredefinedComposite.this.isDetails = !ShowRelatedElementsPredefinedComposite.this.isDetails;
                    ShowRelatedElementsPredefinedComposite.this.saveAs.setEnabled(ShowRelatedElementsPredefinedComposite.this.isDetails);
                    ShowRelatedElementsPredefinedComposite.this.showDetails.showOrHideDetails();
                    ShowRelatedElementsPredefinedComposite.this.handlePredefinedBoxSelection();
                    ShowRelatedElementsPredefinedComposite.this.setDetailsText();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            gd = WindowUtil.makeButtonData(this.details);
            gd.horizontalAlignment = 3;
            gd.grabExcessHorizontalSpace = true;
            this.details.setLayoutData((Object)gd);
        }
        assert (this.delete != null);
        this.delete.setEnabled(false);
        this.contributeComposite(this);
        this.predefinedBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsPredefinedComposite.this.handlePredefinedBoxSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.contributeToList();
        this.predefinedBox.select(this.predefinedBox.getItemCount() - 1);
    }

    protected void handlePredefinedBoxSelection() {
        if (this.predefinedBox.getSelectionIndex() == this.predefinedBox.getItemCount() - 1) {
            if (this.showDetails != null) {
                this.showDetails.updateRelationships(null);
            }
            this.delete.setEnabled(false);
        } else if (this.predefinedBox.getSelectionIndex() != this.predefinedBox.getItemCount() - 1) {
            String string = this.predefinedBox.getSelection()[0];
            ShowRelatedElementsPreset preset = ShowRelatedElementsPresetHelper.findPresetFromList(this.predefined, string);
            if (preset == null) {
                preset = ShowRelatedElementsPresetHelper.findPresetFromList(this.queries, string.substring(0, string.indexOf(" " + DEFAULT_STRING)));
            }
            assert (preset != null);
            if (this.showDetails != null) {
                this.showDetails.updateRelationships(preset);
            }
            this.delete.setEnabled(!this.containsSpecialCharacter(string));
        }
    }

    protected void contributeToList() {
        this.predefined.clear();
        this.predefinedBox.removeAll();
        List readPresets = this.readPresets(null);
        this.predefined.addAll(readPresets);
        if (this.queries != null) {
            for (Object obj : this.queries) {
                assert (obj instanceof ShowRelatedElementsPreset);
                this.predefinedBox.add(((ShowRelatedElementsPreset)obj).getName() + " " + DEFAULT_STRING);
            }
        }
        for (Object obj : this.predefined) {
            assert (obj instanceof ShowRelatedElementsPreset);
            this.predefinedBox.add(((ShowRelatedElementsPreset)obj).getName());
        }
        this.predefinedBox.add(CommonUIMessages.ShowRelatedElementsPredefinedComposite_UserCustomQuery + " [" + CommonUIMessages.ShowRelatedElementsPredefinedComposite_DefaultQuery + SPECIAL_CLOSING);
    }

    protected boolean containsSpecialCharacter(String text) {
        return text.indexOf(":") != -1 || text.indexOf(",") != -1 || text.indexOf(SPECIAL_CLOSING) != -1 || text.indexOf(SPECIAL_OPENING) != -1;
    }

    protected List readPresets(String nameToIgnore) {
        return ShowRelatedElementsPresetHelper.readPresets(nameToIgnore, this.dialogSettings.getArray(DIALOG_SETTINGS_KEY), null);
    }

    protected String[] convertPresetsToString(List presets) {
        return ShowRelatedElementsPresetHelper.convertPresetsToString(presets, null);
    }

    protected void saveAs() {
        assert (this.showDetails != null);
        if (this.saveAsDialog.open() == 0) {
            List presets = this.readPresets(this.saveAsDialog.getValue());
            ShowRelatedElementsPreset newPreset = this.showDetails.getCurrentSettings();
            assert (newPreset != null);
            newPreset.setName(this.saveAsDialog.getValue());
            presets.add(newPreset);
            this.dialogSettings.put(DIALOG_SETTINGS_KEY, this.convertPresetsToString(presets));
            this.contributeToList();
            this.predefinedBox.select(this.predefinedBox.getItemCount() - 2);
            this.delete.setEnabled(true);
        }
    }

    protected void makePredefinedSettingsButtons(Composite buttons) {
        this.saveAs = new Button(buttons, 8);
        this.saveAs.setText(CommonUIMessages.ShowRelatedElementsPredefinedComposite_SaveAs);
        this.saveAs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsPredefinedComposite.this.saveAs();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.saveAs.setLayoutData((Object)WindowUtil.makeButtonData(this.saveAs));
        this.delete = new Button(buttons, 8);
        this.delete.setText(CommonUIMessages.ShowRelatedElementsPredefinedComposite_Delete);
        this.delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ShowRelatedElementsPredefinedComposite.this.delete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.delete.setLayoutData((Object)WindowUtil.makeButtonData(this.delete));
    }

    protected void delete() {
        assert (this.predefinedBox.getSelection().length != 0);
        String selectedText = this.predefinedBox.getSelection()[0];
        ShowRelatedElementsPreset preset = ShowRelatedElementsPresetHelper.findPresetFromList(this.predefined, selectedText);
        assert (selectedText.indexOf(SPECIAL_OPENING) == -1);
        assert (preset != null);
        this.predefined.remove(preset);
        this.predefinedBox.remove(this.predefinedBox.getSelectionIndex());
        this.dialogSettings.put(DIALOG_SETTINGS_KEY, this.convertPresetsToString(this.predefined));
        this.predefinedBox.setSelection(this.predefinedBox.getItemCount() - 1);
        this.delete.setEnabled(false);
        this.showDetails.updateRelationships(null);
    }

    protected void contributeComposite(Composite parent) {
    }

    protected void detailsChanged() {
        this.predefinedBox.select(this.predefinedBox.getItemCount() - 1);
    }
}

