/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceContentProvider;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceLabelProvider;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.CapabilityFilter;
import org.eclipse.ui.internal.dialogs.PreferenceBoldLabelProvider;
import org.eclipse.ui.internal.dialogs.PreferenceHistoryEntry;
import org.eclipse.ui.internal.dialogs.PreferenceNodeFilter;
import org.eclipse.ui.internal.dialogs.PreferencePageHistory;
import org.eclipse.ui.internal.dialogs.PreferencePatternFilter;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.wizards.preferences.PreferencesExportWizard;
import org.eclipse.ui.internal.wizards.preferences.PreferencesImportWizard;
import org.eclipse.ui.model.IContributionService;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class FilteredPreferenceDialog
extends PreferenceDialog
implements IWorkbenchPreferenceContainer {
    private static final int PAGE_MULTIPLIER = 9;
    private static final int INCREMENT = 10;
    protected PreferenceFilteredTree filteredTree;
    private Object pageData;
    IWorkingCopyManager workingCopyManager;
    private Collection<Job> updateJobs = new ArrayList<Job>();
    PreferencePageHistory history = new PreferencePageHistory(this);
    private Sash sash;
    private IHandlerActivation showViewHandler;
    private boolean locked;
    private Image importImage;
    private Image exportImage;
    private boolean keyScrollingEnabled = false;
    private Listener keyScrollingFilter = null;

    public FilteredPreferenceDialog(Shell parentShell, PreferenceManager manager) {
        super(parentShell, manager);
    }

    protected IPreferenceNode findNodeMatching(String nodeId) {
        IPreferenceNode node = super.findNodeMatching(nodeId);
        if (WorkbenchActivityHelper.filterItem(node)) {
            return null;
        }
        return node;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer tree;
        int styleBits = 4;
        if (!this.hasAtMostOnePage()) {
            this.filteredTree = new PreferenceFilteredTree(parent, styleBits, new PreferencePatternFilter());
            this.filteredTree.setBackground(parent.getDisplay().getSystemColor(25));
            tree = this.filteredTree.getViewer();
        } else {
            tree = new TreeViewer(parent, styleBits);
        }
        this.setContentAndLabelProviders(tree);
        tree.setInput((Object)this.getPreferenceManager());
        tree.addFilter((ViewerFilter)new CapabilityFilter());
        tree.addSelectionChangedListener(this::handleTreeSelectionChanged);
        super.addListeners(tree);
        return tree;
    }

    private boolean hasAtMostOnePage() {
        PreferenceContentProvider contentProvider = new PreferenceContentProvider();
        try {
            Object[] children = contentProvider.getElements((Object)this.getPreferenceManager());
            boolean bl = children.length == 0 || children.length == 1 && !contentProvider.hasChildren(children[0]);
            return bl;
        }
        finally {
            contentProvider.dispose();
        }
    }

    protected void setContentAndLabelProviders(TreeViewer treeViewer) {
        if (this.hasAtMostOnePage()) {
            treeViewer.setLabelProvider((IBaseLabelProvider)new PreferenceLabelProvider());
        } else {
            treeViewer.setLabelProvider((IBaseLabelProvider)new PreferenceBoldLabelProvider(this.filteredTree));
        }
        IContributionService cs = (IContributionService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IContributionService.class);
        treeViewer.setComparator((ViewerComparator)cs.getComparatorFor(this.getContributionType()));
        treeViewer.setContentProvider((IContentProvider)new PreferenceContentProvider());
    }

    protected String getContributionType() {
        return "preference";
    }

    protected void handleTreeSelectionChanged(SelectionChangedEvent event) {
    }

    protected Control createTreeAreaContents(Composite parent) {
        Composite leftArea = new Composite(parent, 0);
        leftArea.setBackground(parent.getDisplay().getSystemColor(25));
        leftArea.setFont(parent.getFont());
        GridLayout leftLayout = new GridLayout();
        leftLayout.numColumns = 1;
        leftLayout.marginHeight = 0;
        leftLayout.marginTop = 7;
        leftLayout.marginWidth = 7;
        leftLayout.horizontalSpacing = 0;
        leftLayout.verticalSpacing = 0;
        leftArea.setLayout((Layout)leftLayout);
        TreeViewer viewer = this.createTreeViewer(leftArea);
        this.setTreeViewer(viewer);
        this.updateTreeFont(JFaceResources.getDialogFont());
        GridData viewerData = new GridData(1808);
        viewer.getControl().getParent().setLayoutData((Object)viewerData);
        this.layoutTreeAreaControl((Control)leftArea);
        return leftArea;
    }

    public void showOnly(String[] filteredIds) {
        if (!this.hasAtMostOnePage()) {
            this.filteredTree.addFilter(new PreferenceNodeFilter(filteredIds));
        }
    }

    public void setPageData(Object pageData) {
        this.pageData = pageData;
    }

    protected void createPage(IPreferenceNode node) {
        super.createPage(node);
        if (this.pageData == null) {
            return;
        }
        IPreferencePage page = node.getPage();
        if (page instanceof PreferencePage) {
            ((PreferencePage)page).applyData(this.pageData);
        }
    }

    protected Control createHelpControl(Composite parent) {
        Control control = super.createHelpControl(parent);
        this.addButtonsToHelpControl(control);
        return control;
    }

    protected void addButtonsToHelpControl(Control control) {
        Composite parent = control.getParent();
        if (control instanceof ToolBar) {
            ToolBar toolBar = (ToolBar)control;
            ToolItem importButton = new ToolItem(toolBar, 8);
            this.importImage = WorkbenchImages.getImageDescriptor("IMG_PREF_IMPORT").createImage();
            importButton.setImage(this.importImage);
            importButton.setToolTipText(WorkbenchMessages.Preference_import);
            importButton.addListener(13, e -> this.openImportWizard(parent));
            ToolItem exportButton = new ToolItem(toolBar, 8);
            this.exportImage = WorkbenchImages.getImageDescriptor("IMG_PREF_EXPORT").createImage();
            exportButton.setImage(this.exportImage);
            exportButton.setToolTipText(WorkbenchMessages.Preference_export);
            exportButton.addListener(13, e -> this.openExportWizard(parent));
        } else if (control instanceof Link) {
            Composite linkParent = ((Link)control).getParent();
            Link importLink = new Link(linkParent, 524352);
            ++((GridLayout)parent.getLayout()).numColumns;
            importLink.setLayoutData((Object)new GridData(64));
            importLink.setText(" <a>" + WorkbenchMessages.Preference_import + "</a>");
            importLink.addListener(13, e -> this.openImportWizard(parent));
            Link exportLink = new Link(linkParent, 524352);
            ++((GridLayout)parent.getLayout()).numColumns;
            exportLink.setLayoutData((Object)new GridData(64));
            exportLink.setText(" <a>" + WorkbenchMessages.Preference_export + "</a>");
            exportLink.addListener(13, e -> this.openExportWizard(parent));
        }
    }

    private void openImportWizard(Composite parent) {
        PreferencesImportWizard importWizard = new PreferencesImportWizard();
        importWizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog wizardDialog = new WizardDialog(parent.getShell(), (IWizard)importWizard);
        wizardDialog.open();
        if (wizardDialog.getReturnCode() == 0) {
            parent.getShell().close();
        }
    }

    private void openExportWizard(Composite parent) {
        PreferencesExportWizard exportWizard = new PreferencesExportWizard();
        exportWizard.init(PlatformUI.getWorkbench(), null);
        WizardDialog wizardDialog = new WizardDialog(parent.getShell(), (IWizard)exportWizard);
        int dialogResponse = MessageDialog.open((int)5, (Shell)parent.getShell(), (String)WorkbenchMessages.PreferenceExportWarning_title, (String)WorkbenchMessages.PreferenceExportWarning_message, (int)0, (String[])new String[]{WorkbenchMessages.PreferenceExportWarning_applyAndContinue, WorkbenchMessages.PreferenceExportWarning_continue});
        if (dialogResponse == -1) {
            return;
        }
        if (dialogResponse == 0) {
            this.okPressed();
        }
        wizardDialog.open();
        if (dialogResponse == 1) {
            this.close();
        }
    }

    public IPreferencePage getCurrentPage() {
        return super.getCurrentPage();
    }

    @Override
    public boolean openPage(String pageId, Object data) {
        this.setPageData(data);
        this.setCurrentPageId(pageId);
        IPreferencePage page = this.getCurrentPage();
        if (page instanceof PreferencePage) {
            ((PreferencePage)page).applyData(data);
        }
        return true;
    }

    public final void setCurrentPageId(String preferencePageId) {
        IPreferenceNode node = this.findNodeMatching(preferencePageId);
        if (node != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
            this.showPage(node);
        }
    }

    @Override
    public IWorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyManager == null) {
            this.workingCopyManager = new WorkingCopyManager();
        }
        return this.workingCopyManager;
    }

    protected void okPressed() {
        super.okPressed();
        if (this.getReturnCode() == 2) {
            return;
        }
        if (this.workingCopyManager != null) {
            try {
                this.workingCopyManager.applyChanges();
            }
            catch (BackingStoreException e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = WorkbenchMessages.FilteredPreferenceDialog_PreferenceSaveFailed;
                }
                StatusUtil.handleStatus(String.valueOf(WorkbenchMessages.PreferencesExportDialog_ErrorDialogTitle) + ": " + msg, e, 2, this.getShell());
            }
        }
        this.updateJobs.forEach(Job::schedule);
    }

    @Override
    public void registerUpdateJob(Job job) {
        this.updateJobs.add(job);
    }

    Control getContainerToolBar(Composite composite) {
        final ToolBarManager historyManager = new ToolBarManager(0x800100);
        historyManager.createControl(composite);
        this.history.createHistoryControls(historyManager.getControl(), historyManager);
        Action popupMenuAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return WorkbenchImages.getImageDescriptor("IMG_LCL_VIEW_MENU");
            }

            public void run() {
                MenuManager manager = new MenuManager();
                manager.add((IAction)new Action(){

                    public void run() {
                        FilteredPreferenceDialog.this.sash.addFocusListener((FocusListener)new FocusAdapter(){

                            public void focusGained(FocusEvent e) {
                                FilteredPreferenceDialog.this.sash.setBackground(FilteredPreferenceDialog.this.sash.getDisplay().getSystemColor(26));
                            }

                            public void focusLost(FocusEvent e) {
                                FilteredPreferenceDialog.this.sash.setBackground(FilteredPreferenceDialog.this.sash.getDisplay().getSystemColor(25));
                            }
                        });
                        FilteredPreferenceDialog.this.sash.setFocus();
                    }

                    public String getText() {
                        return WorkbenchMessages.FilteredPreferenceDialog_Resize;
                    }
                });
                manager.add((IAction)new Action(){

                    public void run() {
                        FilteredPreferenceDialog.this.activeKeyScrolling();
                    }

                    public String getText() {
                        return WorkbenchMessages.FilteredPreferenceDialog_Key_Scrolling;
                    }
                });
                Menu menu = manager.createContextMenu((Control)FilteredPreferenceDialog.this.getShell());
                Rectangle bounds = historyManager.getControl().getBounds();
                Point topLeft = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
                topLeft = historyManager.getControl().toDisplay(topLeft);
                menu.setLocation(topLeft.x, topLeft.y);
                menu.setVisible(true);
            }
        };
        popupMenuAction.setToolTipText(WorkbenchMessages.FilteredPreferenceDialog_FilterToolTip);
        historyManager.add((IAction)popupMenuAction);
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.showViewHandler = service.activateHandler("org.eclipse.ui.window.showViewMenu", (IHandler)new ActionHandler((IAction)popupMenuAction), new ActiveShellExpression(this.getShell()));
        historyManager.update(false);
        return historyManager.getControl();
    }

    void activeKeyScrolling() {
        if (this.keyScrollingFilter == null) {
            Composite pageParent = this.getPageContainer().getParent();
            if (!(pageParent instanceof ScrolledComposite)) {
                return;
            }
            ScrolledComposite sc = (ScrolledComposite)pageParent;
            this.keyScrollingFilter = event -> {
                if (!this.keyScrollingEnabled || sc.isDisposed()) {
                    return;
                }
                switch (event.keyCode) {
                    case 0x1000002: {
                        sc.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y + 10);
                        break;
                    }
                    case 0x1000001: {
                        sc.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y - 10);
                        break;
                    }
                    case 0x1000003: {
                        sc.setOrigin(scrolledComposite.getOrigin().x - 10, scrolledComposite.getOrigin().y);
                        break;
                    }
                    case 0x1000004: {
                        sc.setOrigin(scrolledComposite.getOrigin().x + 10, scrolledComposite.getOrigin().y);
                        break;
                    }
                    case 0x1000006: {
                        sc.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y + 90);
                        break;
                    }
                    case 0x1000005: {
                        sc.setOrigin(scrolledComposite.getOrigin().x, scrolledComposite.getOrigin().y - 90);
                        break;
                    }
                    case 0x1000007: {
                        sc.setOrigin(0, 0);
                        break;
                    }
                    case 0x1000008: {
                        sc.setOrigin(0, scrolledComposite.getSize().y);
                        break;
                    }
                    default: {
                        this.keyScrollingEnabled = false;
                    }
                }
                event.type = 0;
                event.doit = false;
            };
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.addFilter(1, this.keyScrollingFilter);
            display.addFilter(31, this.keyScrollingFilter);
            sc.addDisposeListener(e -> this.removeKeyScrolling());
        }
        this.keyScrollingEnabled = true;
    }

    void removeKeyScrolling() {
        if (this.keyScrollingFilter != null) {
            this.keyScrollingEnabled = false;
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display != null) {
                display.removeFilter(1, this.keyScrollingFilter);
                display.removeFilter(31, this.keyScrollingFilter);
            }
            this.keyScrollingFilter = null;
        }
    }

    protected boolean showPage(IPreferenceNode node) {
        boolean success = super.showPage(node);
        if (success) {
            this.history.addHistoryEntry(new PreferenceHistoryEntry(node.getId(), node.getLabelText(), null));
        }
        return success;
    }

    public boolean close() {
        if (this.showViewHandler != null) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            service.deactivateHandler(this.showViewHandler);
            this.showViewHandler.getHandler().dispose();
            this.showViewHandler = null;
        }
        this.removeKeyScrolling();
        this.history.dispose();
        if (this.importImage != null) {
            this.importImage.dispose();
        }
        if (this.exportImage != null) {
            this.exportImage.dispose();
        }
        return super.close();
    }

    protected Composite createTitleArea(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        parentLayout.numColumns = 2;
        parentLayout.marginHeight = 0;
        parentLayout.marginTop = 7;
        parent.setLayout((Layout)parentLayout);
        Composite titleComposite = super.createTitleArea(parent);
        Composite toolbarArea = new Composite(parent, 0);
        GridLayout toolbarLayout = new GridLayout();
        toolbarLayout.marginHeight = 0;
        toolbarLayout.verticalSpacing = 0;
        toolbarArea.setLayout((Layout)toolbarLayout);
        toolbarArea.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        Control topBar = this.getContainerToolBar(toolbarArea);
        topBar.setLayoutData((Object)new GridData(0x1000008, 4, false, true));
        return titleComposite;
    }

    protected void selectSavedItem() {
        Text filterText;
        this.getTreeViewer().setInput((Object)this.getPreferenceManager());
        super.selectSavedItem();
        if (this.getTreeViewer().getTree().getItemCount() > 1 && (filterText = this.filteredTree.getFilterControl()) != null) {
            filterText.setFocus();
        }
    }

    protected void updateTreeFont(Font dialogFont) {
        if (this.hasAtMostOnePage()) {
            Tree composite = this.getTreeViewer().getTree();
            this.applyDialogFont((Control)composite, dialogFont);
        } else {
            this.applyDialogFont((Control)this.filteredTree, dialogFont);
        }
    }

    private void applyDialogFont(Control control, Font dialogFont) {
        control.setFont(dialogFont);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                this.applyDialogFont(element, dialogFont);
                ++n2;
            }
        }
    }

    protected Sash createSash(Composite composite, Control rightControl) {
        this.sash = super.createSash(composite, rightControl);
        return this.sash;
    }

    public void setLocked(boolean b) {
        this.locked = b;
    }

    protected class PreferenceFilteredTree
    extends FilteredTree {
        private ViewerFilter viewerFilter;
        private String cachedTitle;

        PreferenceFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
            super(parent, treeStyle, filter, true, true);
        }

        protected void addFilter(ViewerFilter filter) {
            this.viewerFilter = filter;
            this.getViewer().addFilter(filter);
            if (this.filterText != null) {
                this.setFilterText(WorkbenchMessages.FilteredTree_FilterMessage);
                this.textChanged();
            }
            this.cachedTitle = this.getShell().getText();
            this.getShell().setText(NLS.bind((String)WorkbenchMessages.FilteredTree_FilteredDialogTitle, (Object)this.cachedTitle));
        }

        @Override
        protected void clearText() {
            this.setFilterText("");
            if (!FilteredPreferenceDialog.this.locked && this.viewerFilter != null) {
                this.getViewer().removeFilter(this.viewerFilter);
                this.viewerFilter = null;
                this.getShell().setText(this.cachedTitle);
            }
            this.textChanged();
        }
    }
}

