/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.FilterManager;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.ReadWriteValidatorImpl;
import org.eclipse.emf.transaction.impl.TransactionValidator;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.util.ConditionalRedoCommand;
import org.eclipse.emf.transaction.util.TriggerCommand;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.impl.WorkspaceCommandStackImpl;
import org.eclipse.gmf.runtime.diagram.core.internal.listener.NotationSemProc;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;

public class DiagramEditingDomainFactory
extends GMFEditingDomainFactory {
    static final TriggerCommand NOOP_TRIGGER = new TriggerCommand(Collections.singletonList(new AbstractCommand(){

        protected boolean prepare() {
            return true;
        }

        public void execute() {
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
        }

        public void redo() {
        }
    }));
    private static DiagramEditingDomainFactory instance = new DiagramEditingDomainFactory();

    public static WorkspaceEditingDomainFactory getInstance() {
        return instance;
    }

    protected void configure(TransactionalEditingDomain domain) {
        super.configure(domain);
        domain.addResourceSetListener((ResourceSetListener)new NotationSemProc());
    }

    public TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain result = this.createEditingDomain(OperationHistoryFactory.getOperationHistory());
        return result;
    }

    public TransactionalEditingDomain createEditingDomain(IOperationHistory history) {
        WorkspaceCommandStackImpl stack = new WorkspaceCommandStackImpl(history);
        DiagramEditingDomain result = new DiagramEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (TransactionalCommandStack)stack);
        this.mapResourceSet((TransactionalEditingDomain)result);
        this.configure((TransactionalEditingDomain)result);
        return result;
    }

    public TransactionalEditingDomain createEditingDomain(ResourceSet rset) {
        TransactionalEditingDomain result = this.createEditingDomain(rset, OperationHistoryFactory.getOperationHistory());
        return result;
    }

    public TransactionalEditingDomain createEditingDomain(ResourceSet rset, IOperationHistory history) {
        WorkspaceCommandStackImpl stack = new WorkspaceCommandStackImpl(history);
        DiagramEditingDomain result = new DiagramEditingDomain((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), (TransactionalCommandStack)stack, rset);
        this.mapResourceSet((TransactionalEditingDomain)result);
        this.configure((TransactionalEditingDomain)result);
        return result;
    }

    protected static class DiagramEditingDomain
    extends TransactionalEditingDomainImpl {
        private InternalTransaction originatingTransaction = null;
        private DiagramEventBroker deb = null;
        private ResourceSetListener debWrapper = null;

        public void addResourceSetListener(ResourceSetListener l) {
            if (DiagramEventBroker.class.isInstance(l)) {
                assert (this.deb == null);
                this.deb = (DiagramEventBroker)l;
                this.debWrapper = new ResourceSetListenerImpl(){

                    public boolean isAggregatePrecommitListener() {
                        return DiagramEditingDomain.this.deb.isAggregatePrecommitListener();
                    }

                    public boolean isPrecommitOnly() {
                        return true;
                    }

                    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                        return DiagramEditingDomain.this.deb.transactionAboutToCommit(event);
                    }

                    public void resourceSetChanged(ResourceSetChangeEvent event) {
                        DiagramEditingDomain.this.deb.resourceSetChanged(event);
                    }

                    public NotificationFilter getFilter() {
                        return DiagramEditingDomain.this.deb.getFilter();
                    }

                    public boolean isPostcommitOnly() {
                        return false;
                    }
                };
                super.addResourceSetListener(this.debWrapper);
            } else {
                super.addResourceSetListener(l);
            }
        }

        public void removeResourceSetListener(ResourceSetListener l) {
            if (DiagramEventBroker.class.isInstance(l)) {
                assert (this.deb != null);
                this.deb = null;
                super.removeResourceSetListener(this.debWrapper);
                this.debWrapper = null;
            } else {
                super.removeResourceSetListener(l);
            }
        }

        public DiagramEditingDomain(AdapterFactory adapterFactory, ResourceSet resourceSet) {
            super(adapterFactory, resourceSet);
        }

        public DiagramEditingDomain(AdapterFactory adapterFactory, TransactionalCommandStack stack, ResourceSet resourceSet) {
            super(adapterFactory, stack, resourceSet);
        }

        public DiagramEditingDomain(AdapterFactory adapterFactory, TransactionalCommandStack stack) {
            super(adapterFactory, stack);
        }

        public DiagramEditingDomain(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public void precommit(InternalTransaction tx) throws RollbackException {
            Command existingTriggers;
            super.precommit(tx);
            if (tx.getParent() == null && this.deb != null && !((existingTriggers = tx.getTriggers()) instanceof CompoundCommand)) {
                if (existingTriggers != null) {
                    tx.addTriggers(NOOP_TRIGGER);
                } else {
                    tx.addTriggers(NOOP_TRIGGER);
                    tx.addTriggers(NOOP_TRIGGER);
                }
            }
        }

        public void broadcastUnbatched(Notification notification) {
            super.broadcastUnbatched(notification);
            final ResourceSetChangeEvent unbatchedChangeEvent = new ResourceSetChangeEvent((TransactionalEditingDomain)this, null, Collections.singletonList(notification));
            try {
                this.runExclusive(new Runnable(){

                    public void run() {
                        try {
                            if (DiagramEditingDomain.this.deb != null) {
                                DiagramEditingDomain.this.deb.resourceSetChanged(unbatchedChangeEvent);
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            catch (InterruptedException interruptedException) {}
        }

        protected void postcommit(InternalTransaction tx) {
            block14: {
                try {
                    List notifications = this.getValidator().getNotificationsForPostcommit((Transaction)tx);
                    if (this.deb == null || notifications == null || notifications.isEmpty()) break block14;
                    TransactionValidator originalValidator = null;
                    if (this.originatingTransaction == null) {
                        this.originatingTransaction = tx;
                        originalValidator = this.getValidator();
                        this.setValidator((TransactionValidator)new ReadWriteValidatorImpl());
                    } else {
                        this.originatingTransaction.addTriggers(new TriggerCommand(Collections.singletonList(new DiagramEventBrokerCommand(tx.getChangeDescription()))));
                        this.originatingTransaction.getNotifications().addAll(notifications);
                    }
                    try {
                        try {
                            ArrayList cache = new ArrayList(notifications.size());
                            List filtered = FilterManager.getInstance().select(notifications, this.deb.getFilter(), cache);
                            HashMap<String, Boolean> options = new HashMap<String, Boolean>(this.originatingTransaction.getOptions());
                            options.put("no_undo", Boolean.FALSE);
                            InternalTransaction newTx = this.startTransaction(false, options);
                            try {
                                this.deb.resourceSetChanged(new ResourceSetChangeEvent((TransactionalEditingDomain)this, (Transaction)tx, filtered));
                                newTx.commit();
                            }
                            catch (RuntimeException e) {
                                newTx.rollback();
                                throw e;
                            }
                        }
                        catch (RollbackException rollbackException) {
                            if (this.originatingTransaction == tx) {
                                this.originatingTransaction = null;
                                this.getValidator().dispose();
                                this.setValidator(originalValidator);
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.originatingTransaction == tx) {
                            this.originatingTransaction = null;
                            this.getValidator().dispose();
                            this.setValidator(originalValidator);
                        }
                        throw throwable;
                    }
                    if (this.originatingTransaction == tx) {
                        this.originatingTransaction = null;
                        this.getValidator().dispose();
                        this.setValidator(originalValidator);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.originatingTransaction == null) {
                super.postcommit(tx);
            }
        }
    }

    private static class DiagramEventBrokerCommand
    extends AbstractCommand
    implements ConditionalRedoCommand {
        private final TransactionChangeDescription change;

        DiagramEventBrokerCommand(TransactionChangeDescription change) {
            this.change = change;
        }

        protected boolean prepare() {
            return true;
        }

        public final void execute() {
        }

        public boolean canUndo() {
            return this.change != null && this.change.canApply();
        }

        public final void undo() {
            if (this.change != null) {
                this.change.applyAndReverse();
            }
        }

        public boolean canRedo() {
            return this.change != null && this.change.canApply();
        }

        public final void redo() {
            if (this.change != null) {
                this.change.applyAndReverse();
            }
        }
    }
}

