/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.action.util;

import java.util.ArrayList;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalActionManager;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalAction;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.util.IInlineTextEditorPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;

public class SelectionUtil {
    private SelectionUtil() {
    }

    public static void selectAndReveal(Object obj, IWorkbenchWindow window) {
        IWorkbenchPart part;
        if (window == null || obj == null) {
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        StructuredSelection selection = new StructuredSelection(obj);
        for (IWorkbenchPart part2 : parts) {
            ISetSelectionTarget target = null;
            target = part2 instanceof ISetSelectionTarget ? (ISetSelectionTarget)part2 : (ISetSelectionTarget)part2.getAdapter(ISetSelectionTarget.class);
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            window.getShell().getDisplay().asyncExec(new Runnable((ISelection)selection){
                private final /* synthetic */ ISelection val$selection;
                {
                    this.val$selection = iSelection;
                }

                public void run() {
                    finalTarget.selectReveal(this.val$selection);
                }
            });
        }
    }

    private static IInlineTextEditorPart getInlineTextEditorPart(IWorkbenchPart part) {
        if (part instanceof IInlineTextEditorPart) {
            return (IInlineTextEditorPart)part;
        }
        return (IInlineTextEditorPart)part.getAdapter(IInlineTextEditorPart.class);
    }

    public static void startInlineEdit(final IWorkbenchPart part, final Object newElement) {
        part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IInlineTextEditorPart inlineTextEditorPart = SelectionUtil.getInlineTextEditorPart(part);
                if (inlineTextEditorPart != null) {
                    inlineTextEditorPart.startInlineEdit(newElement);
                } else {
                    if (part instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(newElement));
                    }
                    if (part instanceof IInlineTextEditorPart) {
                        ((IInlineTextEditorPart)part).startInlineEdit();
                    }
                }
            }
        });
    }

    public static void startRename(final IWorkbenchPart part, final Object newElement) {
        part.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IInlineTextEditorPart inlineTextEditorPart = SelectionUtil.getInlineTextEditorPart(part);
                if (inlineTextEditorPart != null) {
                    inlineTextEditorPart.startInlineEdit(newElement, new Runnable(){

                        public void run() {
                            GlobalAction renameAction = GlobalActionManager.getInstance().getGlobalAction(part, GlobalActionId.RENAME);
                            if (renameAction != null && renameAction.isRunnable()) {
                                renameAction.run();
                            }
                        }
                    });
                } else {
                    GlobalAction renameAction;
                    if (part instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(newElement));
                    }
                    if ((renameAction = GlobalActionManager.getInstance().getGlobalAction(part, GlobalActionId.RENAME)) != null && renameAction.isRunnable()) {
                        renameAction.run();
                    }
                }
            }
        });
    }
}

