/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.DiagramActionsDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.DiagramActionsPlugin;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class CopyAction
extends DiagramAction {
    private static final String JRE_VERSION = System.getProperty("java.version");

    public CopyAction(IWorkbenchPage page) {
        super(page);
    }

    public void init() {
        super.init();
        this.setText(DiagramUIActionsMessages.CopyAction_Copy);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setId("copyBitmapAction");
    }

    protected boolean calculateEnabled() {
        if (!JRE_VERSION.startsWith("1.4")) {
            return false;
        }
        if (this.isCopyAll()) {
            return true;
        }
        return this.canCopy(this.getSelectedObjects());
    }

    protected boolean isCopyAll() {
        List selectObjects = this.getStructuredSelection().toList();
        return selectObjects.size() == 1 && selectObjects.get(0) instanceof DiagramEditPart;
    }

    protected boolean canCopy(List parts) {
        int i = 0;
        while (i < parts.size()) {
            Object o = parts.get(i);
            if (o instanceof ShapeEditPart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        try {
            this.getDiagramEditPart().getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    CopyAction.this.run();
                }
            });
        }
        catch (Exception e) {
            Trace.catching((Plugin)DiagramActionsPlugin.getInstance(), (String)DiagramActionsDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"doRun()", (Throwable)e);
            Log.error((Plugin)DiagramActionsPlugin.getInstance(), (int)9, (String)"getPropertyValue", (Throwable)e);
        }
    }

    public void refresh() {
        this.setEnabled(this.calculateEnabled());
    }
}

