/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.properties.extended;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gmf.runtime.common.ui.services.properties.ICompositePropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.IExtendedPropertyDescriptor;
import org.eclipse.gmf.runtime.common.ui.services.properties.extended.IExtendedPropertySource;
import org.eclipse.gmf.runtime.common.ui.services.properties.internal.l10n.CommonUIServicesPropertiesMessages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PropertySource
implements IExtendedPropertySource {
    private Object element;
    protected Map properties;
    protected Map propertyDescriptors = new HashMap();
    private boolean flag = false;
    protected ICompositePropertySource enclosed = null;

    public PropertySource() {
        this.properties = new HashMap();
    }

    public void addPropertySource(ICompositePropertySource source) {
        assert (this != source);
        if (this.enclosed == null) {
            this.enclosed = source;
        } else {
            this.enclosed.addPropertySource(source);
        }
    }

    public PropertySource(Object element) {
        this();
        this.element = element;
    }

    public Object getEditableValue() {
        if (this.isDirty()) {
            this.setDirty(false);
            return CommonUIServicesPropertiesMessages.ExtendedPropertyDescriptor_blank;
        }
        if (this.getElement() == null && this.enclosed != null) {
            return this.enclosed.getEditableValue();
        }
        return this.getElement();
    }

    public void setEditableValue(Object object) {
        assert (false) : "This method is obsolete and should not be used";
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList list = new ArrayList(this.propertyDescriptors.values());
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[list.size()];
        System.arraycopy(list.toArray(), 0, descriptors, 0, list.size());
        if (this.enclosed != null) {
            IPropertyDescriptor[] enclosedDecriptors = this.enclosed.getPropertyDescriptors();
            IPropertyDescriptor[] all = new IPropertyDescriptor[descriptors.length + enclosedDecriptors.length];
            System.arraycopy(enclosedDecriptors, 0, all, 0, enclosedDecriptors.length);
            System.arraycopy(descriptors, 0, all, enclosedDecriptors.length, descriptors.length);
            return all;
        }
        return descriptors;
    }

    public void addPropertyDescriptor(IExtendedPropertyDescriptor propertyDescriptor) {
        assert (propertyDescriptor != null);
        this.propertyDescriptors.put(propertyDescriptor.getId(), propertyDescriptor);
        propertyDescriptor.setPropertySource(this);
    }

    public Object getPropertyValue(Object id) {
        assert (id != null);
        if (this.properties.containsKey(id)) {
            IExtendedPropertyDescriptor propertyDescriptor = (IExtendedPropertyDescriptor)this.propertyDescriptors.get(id);
            Object[] args = new Object[]{id};
            String message = MessageFormat.format(CommonUIServicesPropertiesMessages.PropertySource__ERROR__descriptorError, args);
            assert (propertyDescriptor != null) : message;
            if (propertyDescriptor.isDirty()) {
                propertyDescriptor.setDirtyFlag(false);
                if (this.properties.get(id) instanceof IExtendedPropertySource) {
                    ((IExtendedPropertySource)this.properties.get(id)).setDirty(true);
                    return this.properties.get(id);
                }
                return propertyDescriptor.getBlank();
            }
            return this.properties.get(id);
        }
        if (this.enclosed != null) {
            return this.enclosed.getPropertyValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        assert (id != null);
        if (this.propertyDescriptors.containsKey(id)) {
            return true;
        }
        if (this.enclosed != null) {
            return this.enclosed.isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.propertyDescriptors.containsKey(id)) {
            if (this.isValueOkay(id, value)) {
                Object oldValue = this.getPropertyValue(id);
                if (oldValue != null && oldValue.equals(value) || oldValue == null && value == null) {
                    return;
                }
                boolean failed = true;
                this.addProperty(id, value);
                try {
                    this.getPropertyDescriptor(id).setPropertyValue(value);
                    failed = false;
                }
                finally {
                    if (failed) {
                        this.addProperty(id, oldValue);
                    }
                }
            }
        } else if (this.enclosed != null) {
            this.enclosed.setPropertyValue(id, value);
        }
    }

    public Object getElement() {
        return this.element;
    }

    public void setElement(Object element) {
        assert (element != null);
        this.element = element;
    }

    public void addProperty(Object id, Object property) {
        this.properties.put(id, property);
    }

    public void removeProperty(Object id) {
        assert (id != null);
        this.propertyDescriptors.remove(id);
        this.properties.remove(id);
    }

    public IExtendedPropertyDescriptor getPropertyDescriptor(Object id) {
        assert (id != null);
        return (IExtendedPropertyDescriptor)this.propertyDescriptors.get(id);
    }

    public boolean isDirty() {
        return this.flag;
    }

    public void setDirty(boolean flag) {
        this.flag = flag;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setPropertyDescriptors(Map propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    public void refresh() {
    }

    public boolean isValueOkay(Object id, Object value) {
        if (value == null) {
            return true;
        }
        return !(value instanceof String) || !((String)value).equals(CommonUIServicesPropertiesMessages.ExtendedPropertyDescriptor_blank);
    }
}

