/*

   Copyright 1999-2003  The Apache Software Foundation 

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

*/

package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.util.CSSConstants;

/**
 * This class provides a manager for the 'writing-mode' property values.
 *
 * @author <a href="mailto:stephane@hillion.org">Stephane Hillion</a>
 * @version $Id: WritingModeManager.java,v 1.5 2004/12/03 12:20:16 deweese Exp $
 */
public class WritingModeManager extends IdentifierManager {
    
    /**
     * The identifier values.
     */
    protected final static StringMap values = new StringMap();
    static {
	values.put(CSSConstants.CSS_LR_VALUE,
                   SVGValueConstants.LR_VALUE);
	values.put(CSSConstants.CSS_LR_TB_VALUE,
                   SVGValueConstants.LR_TB_VALUE);
	values.put(CSSConstants.CSS_RL_VALUE,
                   SVGValueConstants.RL_VALUE);
	values.put(CSSConstants.CSS_RL_TB_VALUE,
                   SVGValueConstants.RL_TB_VALUE);
	values.put(CSSConstants.CSS_TB_VALUE,
                   SVGValueConstants.TB_VALUE);
	values.put(CSSConstants.CSS_TB_RL_VALUE,
                   SVGValueConstants.TB_RL_VALUE);
    }

    /**
     * Implements {@link
     * org.apache.batik.css.engine.value.ValueManager#isInheritedProperty()}.
     */
    public boolean isInheritedProperty() {
	return true;
    }

    /**
     * Implements {@link
     * org.apache.batik.css.engine.value.ValueManager#getPropertyName()}.
     */
    public String getPropertyName() {
	return CSSConstants.CSS_WRITING_MODE_PROPERTY;
    }
    
    /**
     * Implements {@link
     * org.apache.batik.css.engine.value.ValueManager#getDefaultValue()}.
     */
    public Value getDefaultValue() {
        return SVGValueConstants.LR_TB_VALUE;
    }

    /**
     * Implements {@link IdentifierManager#getIdentifiers()}.
     */
    public StringMap getIdentifiers() {
        return values;
    }
}
