/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.routers;

import org.eclipse.draw2d.AbstractRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.TreeRouter;

public class BranchRouter
extends AbstractRouter {
    private TreeRouter tree;

    public BranchRouter(TreeRouter tree) {
        this.tree = tree;
    }

    public void route(Connection conn) {
        Point ptTrunkLoc = this.getTrunkLocation(conn);
        this.getTree().setTrunkLocation(conn, ptTrunkLoc);
        Point ptSourceLoc = this.getSourceLocation(conn, ptTrunkLoc);
        PointList points = this.recreateBranch(conn, ptSourceLoc, ptTrunkLoc);
        conn.setPoints(points);
    }

    protected Point getTrunkLocation(Connection conn) {
        PointList points = this.getTree().getPointsFromConstraint(conn);
        Point ptTrunkLoc = this.getTree().getTrunkLocation(conn);
        if (this.getTree().isTreeBranch(conn, points)) {
            if (this.getTree().isTopDown(conn)) {
                ptTrunkLoc.x = points.getPoint((int)3).x;
            } else {
                ptTrunkLoc.y = points.getPoint((int)3).y;
            }
            if (this.getTree().isOrthogonalTreeBranch(conn, points)) {
                if (this.getTree().isTopDown(conn)) {
                    ptTrunkLoc.y = points.getPoint((int)2).y;
                } else {
                    ptTrunkLoc.x = points.getPoint((int)2).x;
                }
            }
        }
        return ptTrunkLoc;
    }

    public Point getSourceLocation(Connection conn, Point ptTrunkLoc) {
        Point ptSourceRef = conn.getSourceAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptSourceRef);
        boolean bTopDown = this.getTree().isTopDown(conn);
        int branchOffset = this.getSourceBranchOffset(conn) + (bTopDown ? ptSourceRef.x : ptSourceRef.y);
        Point ref = bTopDown ? new Point(branchOffset, ptTrunkLoc.y) : new Point(ptTrunkLoc.x, branchOffset);
        LineSeg line = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, conn.getSourceAnchor(), ref);
        return line.getOrigin();
    }

    public PointList recreateBranch(Connection conn, Point ptSourceLoc, Point ptTrunkLoc) {
        PointList points = new PointList(4);
        boolean bTopDown = this.getTree().isTopDown(conn);
        points.addPoint(new Point(ptSourceLoc));
        Point pt2 = bTopDown ? new Point(ptSourceLoc.x, ptTrunkLoc.y) : new Point(ptTrunkLoc.x, ptSourceLoc.y);
        points.addPoint(pt2);
        points.addPoint(new Point(ptTrunkLoc));
        LineSeg line = OrthogonalRouterUtilities.getOrthogonalLineSegToAnchorLoc(conn, conn.getTargetAnchor(), ptTrunkLoc);
        Point ptTargetLoc = line.getOrigin();
        Point pt4 = bTopDown ? new Point(ptTrunkLoc.x, ptTargetLoc.y) : new Point(ptTargetLoc.x, ptTrunkLoc.y);
        points.addPoint(pt4);
        return points;
    }

    protected TreeRouter getTree() {
        return this.tree;
    }

    private int getSourceBranchOffset(Connection conn) {
        Point ptSourceRef = conn.getSourceAnchor().getReferencePoint();
        conn.translateToRelative((Translatable)ptSourceRef);
        boolean bTopDown = this.getTree().isTopDown(conn);
        int branchOffset = bTopDown ? ptSourceRef.x : ptSourceRef.y;
        PointList constraintPoints = this.getTree().getPointsFromConstraint(conn);
        if (this.getTree().isTreeBranch(conn, constraintPoints)) {
            Point ptLoc = constraintPoints.getFirstPoint();
            branchOffset = bTopDown ? ptLoc.x : ptLoc.y;
        }
        return branchOffset - (bTopDown ? ptSourceRef.x : ptSourceRef.y);
    }
}

