/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;

public class PDFXObject
extends AbstractPDFStream {
    private PDFImage pdfimage;
    private int xnum;

    public PDFXObject(int xnumber, PDFImage img) {
        this.xnum = xnumber;
        this.pdfimage = img;
    }

    public int getXNumber() {
        return this.xnum;
    }

    protected int output(OutputStream stream) throws IOException {
        int length = super.output(stream);
        this.pdfimage = null;
        return length;
    }

    protected String buildStreamDict(String lengthEntry) {
        String dictEntries = this.getFilterList().buildFilterDictEntries();
        if (this.pdfimage.isPS()) {
            return this.buildDictionaryFromPS(lengthEntry, dictEntries);
        }
        return this.buildDictionaryFromImage(lengthEntry, dictEntries);
    }

    private String buildDictionaryFromPS(String lengthEntry, String dictEntries) {
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getObjectID());
        sb.append("<</Type /XObject\n");
        sb.append("/Subtype /PS\n");
        sb.append("/Length " + lengthEntry);
        sb.append(dictEntries);
        sb.append("\n>>\n");
        return sb.toString();
    }

    private String buildDictionaryFromImage(String lengthEntry, String dictEntries) {
        String ref;
        StringBuffer sb = new StringBuffer(128);
        sb.append(this.getObjectID());
        sb.append("<</Type /XObject\n");
        sb.append("/Subtype /Image\n");
        sb.append("/Name /Im" + this.xnum + "\n");
        sb.append("/Length " + lengthEntry + "\n");
        sb.append("/Width " + this.pdfimage.getWidth() + "\n");
        sb.append("/Height " + this.pdfimage.getHeight() + "\n");
        sb.append("/BitsPerComponent " + this.pdfimage.getBitsPerPixel() + "\n");
        PDFICCStream pdfICCStream = this.pdfimage.getICCStream();
        if (pdfICCStream != null) {
            sb.append("/ColorSpace [/ICCBased " + pdfICCStream.referencePDF() + "]\n");
        } else {
            PDFColorSpace cs = this.pdfimage.getColorSpace();
            sb.append("/ColorSpace /" + cs.getColorSpacePDFString() + "\n");
        }
        if (this.pdfimage.getColorSpace().getColorSpace() == 3) {
            sb.append("/Decode [ 1.0 0.0 1.0 0.0 1.0 0.0 1.1 0.0 ]\n");
        }
        if (this.pdfimage.isTransparent()) {
            PDFColor transp = this.pdfimage.getTransparentColor();
            sb.append("/Mask [" + transp.red255() + " " + transp.red255() + " " + transp.green255() + " " + transp.green255() + " " + transp.blue255() + " " + transp.blue255() + "]\n");
        }
        if ((ref = this.pdfimage.getSoftMask()) != null) {
            sb.append("/SMask " + ref + "\n");
        }
        sb.append(dictEntries);
        sb.append("\n>>\n");
        return sb.toString();
    }

    protected void outputRawStreamData(OutputStream out) throws IOException {
        this.pdfimage.outputContents(out);
    }

    protected int getSizeHint() throws IOException {
        return 0;
    }

    protected void prepareImplicitFilters() {
        if (this.pdfimage.isDCT()) {
            this.getFilterList().ensureDCTFilterInPlace();
        }
    }

    protected void setupFilterList() {
        if (!this.getFilterList().isInitialized()) {
            this.getFilterList().addDefaultFilters(this.getDocumentSafely().getFilterMap(), this.pdfimage.getFilterHint());
        }
        super.setupFilterList();
    }
}

