/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.util.Arrays;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandDefinition;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

final class DefinitionSignature {
    private final String myName;
    private final EClassifier myType;
    private final EClassifier[] myArgs;

    public static DefinitionSignature create(ExecutionContext ctx, XpandDefinition def) {
        if (def == null || ctx == null) {
            return null;
        }
        EClassifier type = ctx.getTypeForName(def.getTargetType());
        if (type == null) {
            return null;
        }
        EClassifier[] args = new EClassifier[def.getParams().length];
        int i = 0;
        while (i < def.getParams().length) {
            EClassifier nextArg = ctx.getTypeForName(def.getParams()[i].getType().getValue());
            if (nextArg == null) {
                return null;
            }
            args[i] = nextArg;
            ++i;
        }
        return new DefinitionSignature(def.getName(), type, args);
    }

    public static DefinitionSignature create(ExecutionContext ctx, Extension extension) {
        if (extension == null || ctx == null) {
            return null;
        }
        extension.init(ctx);
        return new DefinitionSignature(extension.getName(), null, extension.getParameterTypes().toArray(new EClassifier[extension.getParameterTypes().size()]));
    }

    private DefinitionSignature(String name, EClassifier type, EClassifier[] args) {
        this.myName = name;
        this.myType = type;
        this.myArgs = args;
        assert (this.myName != null);
        assert (this.myArgs != null);
        EClassifier[] eClassifierArray = this.myArgs;
        int n = this.myArgs.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier nextArg = eClassifierArray[n2];
            assert (nextArg != null);
            ++n2;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DefinitionSignature) {
            DefinitionSignature that = (DefinitionSignature)o;
            return this.myName.equals(that.myName) && (this.myType == null && that.myType == null || this.myType.equals(that.myType)) && Arrays.equals(this.myArgs, that.myArgs);
        }
        return false;
    }

    public int hashCode() {
        return this.myName.hashCode() + (this.myType == null ? 0 : 17 * this.myType.hashCode()) + 31 * Arrays.hashCode(this.myArgs);
    }
}

