/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.LEDEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.editparts.TerminalEditPart;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractTestBase;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.gmf.tests.runtime.diagram.ui.util.ITestCommandCallback;

public class DiagramGraphicalViewerTests
extends AbstractTestBase {
    public static Test suite() {
        TestSuite s = new TestSuite(DiagramGraphicalViewerTests.class);
        return s;
    }

    public DiagramGraphicalViewerTests() {
        super("Diagram Graphical Viewer Test Suite");
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getLogicTestFixture() {
        return (LogicTestFixture)this.getTestFixture();
    }

    public void testIDToEditPartRegistry() throws Exception {
        LogicTestFixture fixture = this.getLogicTestFixture();
        fixture.openDiagram();
        Rectangle rect = new Rectangle(this.getDiagramEditPart().getFigure().getBounds());
        this.getDiagramEditPart().getFigure().translateToAbsolute((Translatable)rect);
        IElementType typeLED = ElementTypeRegistry.getInstance().getType("logic.led");
        IElementType typeWire = ElementTypeRegistry.getInstance().getType("logic.wire");
        Point createPt = new Point(100, 100);
        LEDEditPart led1EP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(led1EP.getFigure().getSize().getExpanded(100, 100));
        LEDEditPart led2EP = (LEDEditPart)this.getLogicTestFixture().createShapeUsingTool(typeLED, createPt, (IGraphicalEditPart)this.getDiagramEditPart());
        createPt.getTranslated(led2EP.getFigure().getSize().getExpanded(100, 100));
        final IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)this.getDiagramEditPart().getViewer();
        EObject led1 = led1EP.getNotationView().getElement();
        EObject led2 = led2EP.getNotationView().getElement();
        final String led1ID = ((XMLResource)led1.eResource()).getID(led1);
        final String led2ID = ((XMLResource)led2.eResource()).getID(led2);
        EObject outputTerminal = (EObject)((LED)((View)led1EP.getModel()).getElement()).getOutputTerminals().get(0);
        TerminalEditPart outputTerminalEP = (TerminalEditPart)viewer.findEditPartsForElement(((XMLResource)outputTerminal.eResource()).getID(outputTerminal), TerminalEditPart.class).get(0);
        EObject inputTerminal = (EObject)((LED)((View)led2EP.getModel()).getElement()).getInputTerminals().get(0);
        TerminalEditPart inputTerminalEP = (TerminalEditPart)viewer.findEditPartsForElement(((XMLResource)inputTerminal.eResource()).getID(inputTerminal), TerminalEditPart.class).get(0);
        ConnectionEditPart wireEP = this.getLogicTestFixture().createConnectorUsingTool((IGraphicalEditPart)outputTerminalEP, (IGraphicalEditPart)inputTerminalEP, typeWire);
        EObject wire = ((View)wireEP.getModel()).getElement();
        String wireID = ((XMLResource)wire.eResource()).getID(wire);
        DiagramGraphicalViewerTests.assertEquals((String)"Number of LEDEditPart for led1ID incorrect", (int)1, (int)viewer.findEditPartsForElement(led1ID, LEDEditPart.class).size());
        DiagramGraphicalViewerTests.assertEquals((String)"Number of ConnectionEditParts for led1ID incorrect", (int)0, (int)viewer.findEditPartsForElement(led1ID, org.eclipse.gef.ConnectionEditPart.class).size());
        View shape3 = this.createShapeView(this.getDiagramEditPart(), ViewUtil.resolveSemanticElement((View)led2EP.getNotationView()), new Point(100, 200));
        DiagramGraphicalViewerTests.assertEquals((String)"Number of ShapeEditParts for led2ID incorrect", (int)2, (int)viewer.findEditPartsForElement(led2ID, ShapeEditPart.class).size());
        DeleteCommand delete = new DeleteCommand(this.getLogicTestFixture().getEditingDomain(), shape3);
        this.testCommand((ICommand)delete, new ITestCommandCallback(){

            public void onCommandExecution() {
                DiagramGraphicalViewerTests.assertEquals((String)"Number of LEDEditParts for led1ID incorrect", (int)1, (int)viewer.findEditPartsForElement(led1ID, LEDEditPart.class).size());
                DiagramGraphicalViewerTests.assertEquals((String)"Number of LEDEditParts for led2ID incorrect", (int)1, (int)viewer.findEditPartsForElement(led2ID, LEDEditPart.class).size());
            }
        });
        this.clearDiagram();
        DiagramGraphicalViewerTests.assertEquals((String)"Number of IGraphicalEditParts for led1ID incorrect", (int)0, (int)viewer.findEditPartsForElement(led1ID, IGraphicalEditPart.class).size());
        DiagramGraphicalViewerTests.assertEquals((String)"Number of IGraphicalEditParts for led2ID incorrect", (int)0, (int)viewer.findEditPartsForElement(led2ID, IGraphicalEditPart.class).size());
        DiagramGraphicalViewerTests.assertEquals((String)"Number of IGraphicalEditParts for wireID incorrect", (int)0, (int)viewer.findEditPartsForElement(wireID, IGraphicalEditPart.class).size());
    }
}

