/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.logic;

import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.runtime.diagram.ui.AbstractShapeTests;
import org.eclipse.gmf.tests.runtime.diagram.ui.logic.LogicTestFixture;
import org.eclipse.swt.widgets.Display;

public class DiagramEventBrokerTests
extends AbstractShapeTests {
    public DiagramEventBrokerTests(String arg0) {
        super(arg0);
    }

    public static Test suite() {
        return new TestSuite(DiagramEventBrokerTests.class);
    }

    protected void setTestFixture() {
        this.testFixture = new LogicTestFixture();
    }

    protected LogicTestFixture getLogicTestFixture() {
        return (LogicTestFixture)this.getTestFixture();
    }

    public DiagramEventBroker getDiagramEventBroker(TransactionalEditingDomain theEditingDomain) {
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public void testDiagramEventBroker() throws Exception {
        final View view = this.getDiagramEditPart().getNotationView();
        DiagramEditPart diagramEP = this.getDiagramEditPart();
        TestListenningEditPart ep = new TestListenningEditPart(diagramEP, this.getDiagramEventBroker(diagramEP.getEditingDomain()), (EObject)view);
        TransactionalEditingDomain editingDomain = ep.getEditingDomain();
        ep.activate();
        AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                view.setType("ddd");
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            DiagramEventBrokerTests.assertFalse((boolean)false);
        }
        this.flushEventQueue();
        DiagramEventBrokerTests.assertTrue((boolean)ep.receivedTypeEvent());
    }

    public void testBlockingUI_Protected() {
        DiagramEditPart diagramEP = this.getDiagramEditPart();
        TransactionalEditingDomain editingDomain = diagramEP.getEditingDomain();
        final Boolean[] result = new Boolean[2];
        result[0] = Boolean.FALSE;
        final AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "", null, new ArrayList()){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                try {
                    result[0] = Boolean.TRUE;
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return new CommandResult(Status.OK_STATUS);
            }
        };
        Thread transactionThread = new Thread(new Runnable(){

            public void run() {
                try {
                    command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        });
        Display.getDefault().readAndDispatch();
        transactionThread.start();
        while (!result[0].booleanValue()) {
            Display.getDefault().readAndDispatch();
        }
        ArrangeRequest arrRequest = new ArrangeRequest("arrange_deferred", "DEFAULT");
        arrRequest.setViewAdaptersToArrange(new ArrayList());
        Command arrCmd = this.getDiagramEditPart().getCommand((Request)arrRequest);
        DiagramEventBrokerTests.assertTrue((arrCmd == null || !arrCmd.canExecute() ? 1 : 0) != 0);
        transactionThread.stop();
    }

    public void testBlockingUI_Unprotected() {
        DiagramEditPart diagramEP = this.getDiagramEditPart();
        TransactionalEditingDomain editingDomain = diagramEP.getEditingDomain();
        HashMap<String, Boolean> unchecked_options = new HashMap<String, Boolean>();
        unchecked_options.put("no_undo", Boolean.TRUE);
        unchecked_options.put("unprotected", Boolean.TRUE);
        final Boolean[] result = new Boolean[]{Boolean.FALSE, Boolean.FALSE};
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "", unchecked_options, new ArrayList()){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Thread accessCommandThread = new Thread(new Runnable(){

                    public void run() {
                        ArrangeRequest arrRequest = new ArrangeRequest("arrange_deferred", "DEFAULT");
                        arrRequest.setViewAdaptersToArrange(new ArrayList());
                        Command arrCmd = DiagramEventBrokerTests.this.getDiagramEditPart().getCommand((Request)arrRequest);
                        result[0] = new Boolean(arrCmd == null || !arrCmd.canExecute());
                        result[1] = Boolean.TRUE;
                    }
                });
                accessCommandThread.start();
                while (!result[1].booleanValue()) {
                    Display.getDefault().readAndDispatch();
                }
                accessCommandThread.stop();
                return new CommandResult(Status.OK_STATUS);
            }
        };
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        DiagramEventBrokerTests.assertTrue((boolean)result[0]);
    }

    private class TestListenningEditPart
    extends GraphicalEditPart {
        private boolean receivedTypeEvent;
        private DiagramEventBroker eventBroker;
        private DiagramEditPart diagremEditPart;

        public boolean receivedTypeEvent() {
            return this.receivedTypeEvent;
        }

        protected Diagram getDiagramView() {
            return this.diagremEditPart.getDiagramView();
        }

        public TestListenningEditPart(DiagramEditPart dEP, DiagramEventBroker eventBroker, EObject model) {
            super(model);
            this.receivedTypeEvent = false;
            this.eventBroker = eventBroker;
            this.diagremEditPart = dEP;
            this.addListenerFilter("Type", (NotificationListener)this, model, (EStructuralFeature)NotationPackage.eINSTANCE.getView_Type());
        }

        public IFigure createFigure() {
            return null;
        }

        protected void addListenerFilter(String filterId, NotificationListener listener, EObject element, EStructuralFeature feature) {
            if (element == null) {
                return;
            }
            Assert.isNotNull((Object)filterId);
            Assert.isNotNull((Object)listener);
            this.eventBroker.addNotificationListener(element, feature, listener);
        }

        public TestListenningEditPart(EObject model) {
            super(model);
            this.receivedTypeEvent = false;
        }

        protected void handleNotificationEvent(Notification event) {
            if (NotationPackage.eINSTANCE.getView_Type().equals(event.getFeature())) {
                this.receivedTypeEvent = true;
            }
        }

        public boolean hasNotationView() {
            return false;
        }

        protected void addSemanticListeners() {
        }
    }
}

