/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ColorsAndFontsPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    protected void createFieldEditors() {
        FontFieldEditor defaultFont = new FontFieldEditor("Appearance.defaultFont", "Default font", this.getFieldEditorParent());
        this.addField((FieldEditor)defaultFont);
        ColorFieldEditor defaultFontColor = new ColorFieldEditor("Appearance.fontColor", "Default font color", this.getFieldEditorParent());
        this.addField((FieldEditor)defaultFontColor);
        this.makeAccessible(defaultFontColor);
        ColorFieldEditor defaultFillColor = new ColorFieldEditor("Appearance.fillColor", "Default fill color", this.getFieldEditorParent());
        this.addField((FieldEditor)defaultFillColor);
        this.makeAccessible(defaultFillColor);
        ColorFieldEditor defaultLineColor = new ColorFieldEditor("Appearance.lineColor", "Default line color", this.getFieldEditorParent());
        this.addField((FieldEditor)defaultLineColor);
        this.makeAccessible(defaultLineColor);
    }

    protected final void makeAccessible(ColorFieldEditor editor) {
        editor.getColorSelector().getButton().getAccessible().addAccessibleListener((AccessibleListener)new ColorAccessibleListener(editor));
    }

    public void init(IWorkbench workbench) {
    }

    private static class ColorAccessibleListener
    extends AccessibleAdapter {
        private final ColorFieldEditor myEditor;

        public ColorAccessibleListener(ColorFieldEditor editor) {
            this.myEditor = editor;
        }

        public void getName(AccessibleEvent e) {
            e.result = Action.removeMnemonics((String)this.myEditor.getLabelText());
        }
    }

    protected static class ColorsAndFontsPreferenceInitializer
    extends AbstractPreferenceInitializer {
        private final IPreferenceStore myStore;

        public ColorsAndFontsPreferenceInitializer(IPreferenceStore store) {
            this.myStore = store;
        }

        public void initializeDefaultPreferences() {
            PreferenceConverter.setDefault((IPreferenceStore)this.myStore, (String)"Appearance.defaultFont", (FontData)this.getDefaultFontData());
            PreferenceConverter.setDefault((IPreferenceStore)this.myStore, (String)"Appearance.fontColor", (RGB)this.getDefaultFontColor());
            PreferenceConverter.setDefault((IPreferenceStore)this.myStore, (String)"Appearance.fillColor", (RGB)this.getDefaultFillColor());
            PreferenceConverter.setDefault((IPreferenceStore)this.myStore, (String)"Appearance.lineColor", (RGB)this.getDefaultLineColor());
        }

        protected FontData getDefaultFontData() {
            FontData[] fontDataArray = JFaceResources.getDefaultFont().getFontData();
            FontData fontData = fontDataArray[0];
            fontData.setHeight(9);
            return fontData;
        }

        protected RGB getDefaultFontColor() {
            return new RGB(0, 0, 0);
        }

        protected RGB getDefaultFillColor() {
            return new RGB(255, 255, 255);
        }

        protected RGB getDefaultLineColor() {
            return new RGB(0, 0, 0);
        }
    }
}

