/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConstrainedLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TextCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.BorderItemSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ResizableCompartmentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetCompartmentRatioCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.FixedLocationResizableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.TextSelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;

public class ConstrainedToolbarLayoutEditPolicy
extends ConstrainedLayoutEditPolicy {
    private static final double NULL_CONSTRAINT = -1.0;
    private boolean horizontal;
    private Transposer transposer = new Transposer();

    public ConstrainedToolbarLayoutEditPolicy() {
        this(false);
    }

    public ConstrainedToolbarLayoutEditPolicy(boolean horizontal) {
        this.horizontal = horizontal;
        this.transposer.setEnabled(horizontal);
    }

    protected boolean isHorizontal() {
        return this.horizontal;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child.getEditPolicy((Object)"PrimaryDrag Policy") == null) {
            if (child instanceof ResizableCompartmentEditPart) {
                return new ResizableCompartmentEditPolicy(this.isHorizontal());
            }
            if (child instanceof TextCompartmentEditPart) {
                return new TextSelectionEditPolicy();
            }
            if (child instanceof IBorderItemEditPart) {
                return new BorderItemSelectionEditPolicy();
            }
            if (child instanceof FixedLocationResizableEditPart) {
                return child.getEditPolicy((Object)"PrimaryDrag Policy");
            }
        }
        return child.getEditPolicy((Object)"PrimaryDrag Policy");
    }

    public Command getCommand(Request request) {
        if ("autosize".equals(request.getType())) {
            return this.getAutoSizeCommand(request);
        }
        return super.getCommand(request);
    }

    public EditPart getTargetEditPart(Request request) {
        return this.understandsRequest(request) ? this.getHost() : null;
    }

    public boolean understandsRequest(Request req) {
        if ("autosize".equals(req.getType())) {
            return true;
        }
        return super.understandsRequest(req);
    }

    protected Command getAutoSizeCommand(Request request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cmc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.Command_AdjustRatioCommand_Label);
        for (IGraphicalEditPart child : this.getHost().getChildren()) {
            if (!(child instanceof ResizableCompartmentEditPart)) continue;
            cmc.compose((IUndoableOperation)new SetCompartmentRatioCommand(editingDomain, (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), -1.0));
        }
        return cmc.isEmpty() ? null : new ICommandProxy(cmc.reduce());
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest req) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cmc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.Command_AdjustRatioCommand_Label);
        boolean before = this.transposer.t((Point)req.getMoveDelta()).y != 0;
        GraphicalEditPart c = (GraphicalEditPart)req.getEditParts().get(0);
        IFigure p = c.getFigure();
        if (!(p instanceof ResizableCompartmentFigure)) {
            return null;
        }
        IFigure a = ((ResizableCompartmentFigure)p).getAdjacentSibling(before);
        double parentHeight = this.transposer.t((Dimension)p.getParent().getSize()).height;
        double heightDelta = MapModeUtil.getMapMode((IFigure)p).DPtoLP(this.transposer.t((Dimension)req.getSizeDelta()).height);
        Map registry = this.getHost().getViewer().getVisualPartMap();
        for (IFigure f : p.getParent().getChildren()) {
            IGraphicalEditPart part = (IGraphicalEditPart)registry.get(f);
            if (!(part instanceof ResizableCompartmentEditPart)) continue;
            double r = -1.0;
            if (f.isVisible()) {
                int height = this.transposer.t((Dimension)f.getSize()).height;
                r = f == p ? ((double)height + heightDelta) / parentHeight : (f == a ? ((double)height - heightDelta) / parentHeight : (double)height / parentHeight);
            }
            cmc.compose((IUndoableOperation)new SetCompartmentRatioCommand(editingDomain, (IAdaptable)new EObjectAdapter((EObject)((View)part.getModel())), r));
        }
        return new ICommandProxy((ICommand)cmc);
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        return null;
    }

    protected Object getConstraintFor(Point point) {
        return null;
    }

    protected Object getConstraintFor(Rectangle rect) {
        return null;
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }
}

