/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.ChildAccess;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Point;
import org.eclipse.gmf.gmfgraph.Polygon;
import org.eclipse.gmf.gmfgraph.Polyline;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.graphdef.editor.navigator.GMFGraphNavigatorGroup;
import org.eclipse.gmf.graphdef.editor.navigator.GMFGraphNavigatorItem;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorPlugin;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphVisualIDRegistry;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphElementTypes;
import org.eclipse.gmf.graphdef.editor.providers.GMFGraphParserProvider;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserService;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class GMFGraphNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        GMFGraphDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        GMFGraphDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof GMFGraphNavigatorItem && !this.isOwnView(((GMFGraphNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        View view;
        if (element instanceof GMFGraphNavigatorGroup) {
            GMFGraphNavigatorGroup group = (GMFGraphNavigatorGroup)((Object)element);
            return GMFGraphDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof GMFGraphNavigatorItem) {
            GMFGraphNavigatorItem navigatorItem = (GMFGraphNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        if (element instanceof IAdaptable && (view = (View)((IAdaptable)element).getAdapter(View.class)) != null && this.isOwnView(view)) {
            return this.getImage(view);
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (GMFGraphVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Canvas", GMFGraphElementTypes.Canvas_1000);
            }
            case 2005: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Compartment", GMFGraphElementTypes.Compartment_2005);
            }
            case 2006: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Node", GMFGraphElementTypes.Node_2006);
            }
            case 2007: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Connection", GMFGraphElementTypes.Connection_2007);
            }
            case 2008: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/gmf/2006/GraphicalDefinition?FigureGallery", GMFGraphElementTypes.FigureGallery_2008);
            }
            case 3009: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?FigureDescriptor", GMFGraphElementTypes.FigureDescriptor_3009);
            }
            case 3010: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Rectangle", GMFGraphElementTypes.Rectangle_3010);
            }
            case 3011: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Rectangle", GMFGraphElementTypes.Rectangle_3011);
            }
            case 3012: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Ellipse", GMFGraphElementTypes.Ellipse_3012);
            }
            case 3013: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?RoundedRectangle", GMFGraphElementTypes.RoundedRectangle_3013);
            }
            case 3014: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Polyline", GMFGraphElementTypes.Polyline_3014);
            }
            case 3022: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Point", GMFGraphElementTypes.Point_3022);
            }
            case 3023: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Polygon", GMFGraphElementTypes.Polygon_3023);
            }
            case 3015: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Ellipse", GMFGraphElementTypes.Ellipse_3015);
            }
            case 3016: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?RoundedRectangle", GMFGraphElementTypes.RoundedRectangle_3016);
            }
            case 3017: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Polyline", GMFGraphElementTypes.Polyline_3017);
            }
            case 3024: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Polygon", GMFGraphElementTypes.Polygon_3024);
            }
            case 3018: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Rectangle", GMFGraphElementTypes.Rectangle_3018);
            }
            case 3019: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Ellipse", GMFGraphElementTypes.Ellipse_3019);
            }
            case 3020: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?RoundedRectangle", GMFGraphElementTypes.RoundedRectangle_3020);
            }
            case 3021: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Polyline", GMFGraphElementTypes.Polyline_3021);
            }
            case 3025: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Polygon", GMFGraphElementTypes.Polygon_3025);
            }
            case 4002: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/gmf/2006/GraphicalDefinition?ChildAccess", GMFGraphElementTypes.ChildAccess_4002);
            }
            case 4003: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Compartment?accessor", GMFGraphElementTypes.CompartmentAccessor_4003);
            }
            case 4004: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/gmf/2006/GraphicalDefinition?DiagramLabel?accessor", GMFGraphElementTypes.DiagramLabelAccessor_4004);
            }
            case 4006: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/gmf/2006/GraphicalDefinition?Node?contentPane", GMFGraphElementTypes.NodeContentPane_4006);
            }
            case 4005: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/gmf/2006/GraphicalDefinition?DiagramElement?figure", GMFGraphElementTypes.DiagramElementFigure_4005);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = GMFGraphDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && GMFGraphElementTypes.isKnownElementType(elementType)) {
            image = GMFGraphElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        View view;
        if (element instanceof GMFGraphNavigatorGroup) {
            GMFGraphNavigatorGroup group = (GMFGraphNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof GMFGraphNavigatorItem) {
            GMFGraphNavigatorItem navigatorItem = (GMFGraphNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        if (element instanceof IAdaptable && (view = (View)((IAdaptable)element).getAdapter(View.class)) != null && this.isOwnView(view)) {
            return this.getText(view);
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (GMFGraphVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return this.getCanvas_1000Text(view);
            }
            case 2005: {
                return this.getCompartment_2005Text(view);
            }
            case 2006: {
                return this.getNode_2006Text(view);
            }
            case 2007: {
                return this.getConnection_2007Text(view);
            }
            case 2008: {
                return this.getFigureGallery_2008Text(view);
            }
            case 3009: {
                return this.getFigureDescriptor_3009Text(view);
            }
            case 3010: {
                return this.getRectangle_3010Text(view);
            }
            case 3011: {
                return this.getRectangle_3011Text(view);
            }
            case 3012: {
                return this.getEllipse_3012Text(view);
            }
            case 3013: {
                return this.getRoundedRectangle_3013Text(view);
            }
            case 3014: {
                return this.getPolyline_3014Text(view);
            }
            case 3022: {
                return this.getPoint_3022Text(view);
            }
            case 3023: {
                return this.getPolygon_3023Text(view);
            }
            case 3015: {
                return this.getEllipse_3015Text(view);
            }
            case 3016: {
                return this.getRoundedRectangle_3016Text(view);
            }
            case 3017: {
                return this.getPolyline_3017Text(view);
            }
            case 3024: {
                return this.getPolygon_3024Text(view);
            }
            case 3018: {
                return this.getRectangle_3018Text(view);
            }
            case 3019: {
                return this.getEllipse_3019Text(view);
            }
            case 3020: {
                return this.getRoundedRectangle_3020Text(view);
            }
            case 3021: {
                return this.getPolyline_3021Text(view);
            }
            case 3025: {
                return this.getPolygon_3025Text(view);
            }
            case 4002: {
                return this.getChildAccess_4002Text(view);
            }
            case 4003: {
                return this.getCompartmentAccessor_4003Text(view);
            }
            case 4004: {
                return this.getDiagramLabelAccessor_4004Text(view);
            }
            case 4006: {
                return this.getNodeContentPane_4006Text(view);
            }
            case 4005: {
                return this.getDiagramElementFigure_4005Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getCompartment_2005Text(View view) {
        GMFGraphParserProvider.HintAdapter hintAdapter = new GMFGraphParserProvider.HintAdapter(GMFGraphElementTypes.Compartment_2005, (EObject)(view.getElement() != null ? view.getElement() : view), GMFGraphVisualIDRegistry.getType(5005));
        IParser parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        if (parser != null) {
            return parser.getPrintString((IAdaptable)hintAdapter, ParserOptions.NONE.intValue());
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5005");
        return "";
    }

    private String getNode_2006Text(View view) {
        GMFGraphParserProvider.HintAdapter hintAdapter = new GMFGraphParserProvider.HintAdapter(GMFGraphElementTypes.Node_2006, (EObject)(view.getElement() != null ? view.getElement() : view), GMFGraphVisualIDRegistry.getType(5006));
        IParser parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        if (parser != null) {
            return parser.getPrintString((IAdaptable)hintAdapter, ParserOptions.NONE.intValue());
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5006");
        return "";
    }

    private String getConnection_2007Text(View view) {
        GMFGraphParserProvider.HintAdapter hintAdapter = new GMFGraphParserProvider.HintAdapter(GMFGraphElementTypes.Connection_2007, (EObject)(view.getElement() != null ? view.getElement() : view), GMFGraphVisualIDRegistry.getType(5007));
        IParser parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        if (parser != null) {
            return parser.getPrintString((IAdaptable)hintAdapter, ParserOptions.NONE.intValue());
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5007");
        return "";
    }

    private String getFigureGallery_2008Text(View view) {
        GMFGraphParserProvider.HintAdapter hintAdapter = new GMFGraphParserProvider.HintAdapter(GMFGraphElementTypes.FigureGallery_2008, (EObject)(view.getElement() != null ? view.getElement() : view), GMFGraphVisualIDRegistry.getType(5009));
        IParser parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        if (parser != null) {
            return parser.getPrintString((IAdaptable)hintAdapter, ParserOptions.NONE.intValue());
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5009");
        return "";
    }

    private String getFigureDescriptor_3009Text(View view) {
        GMFGraphParserProvider.HintAdapter hintAdapter = new GMFGraphParserProvider.HintAdapter(GMFGraphElementTypes.FigureDescriptor_3009, (EObject)(view.getElement() != null ? view.getElement() : view), GMFGraphVisualIDRegistry.getType(5008));
        IParser parser = ParserService.getInstance().getParser((IAdaptable)hintAdapter);
        if (parser != null) {
            return parser.getPrintString((IAdaptable)hintAdapter, ParserOptions.NONE.intValue());
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5008");
        return "";
    }

    private String getRectangle_3010Text(View view) {
        Rectangle domainModelElement = (Rectangle)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3010");
        return "";
    }

    private String getRectangle_3011Text(View view) {
        Rectangle domainModelElement = (Rectangle)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3011");
        return "";
    }

    private String getEllipse_3012Text(View view) {
        Ellipse domainModelElement = (Ellipse)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3012");
        return "";
    }

    private String getRoundedRectangle_3013Text(View view) {
        RoundedRectangle domainModelElement = (RoundedRectangle)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3013");
        return "";
    }

    private String getPolyline_3014Text(View view) {
        Polyline domainModelElement = (Polyline)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3014");
        return "";
    }

    private String getPoint_3022Text(View view) {
        Point domainModelElement = (Point)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getX());
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3022");
        return "";
    }

    private String getPolygon_3023Text(View view) {
        Polygon domainModelElement = (Polygon)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3023");
        return "";
    }

    private String getEllipse_3015Text(View view) {
        Ellipse domainModelElement = (Ellipse)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3015");
        return "";
    }

    private String getRoundedRectangle_3016Text(View view) {
        RoundedRectangle domainModelElement = (RoundedRectangle)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3016");
        return "";
    }

    private String getPolyline_3017Text(View view) {
        Polyline domainModelElement = (Polyline)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3017");
        return "";
    }

    private String getPolygon_3024Text(View view) {
        Polygon domainModelElement = (Polygon)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3024");
        return "";
    }

    private String getRectangle_3018Text(View view) {
        Rectangle domainModelElement = (Rectangle)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3018");
        return "";
    }

    private String getEllipse_3019Text(View view) {
        Ellipse domainModelElement = (Ellipse)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3019");
        return "";
    }

    private String getRoundedRectangle_3020Text(View view) {
        RoundedRectangle domainModelElement = (RoundedRectangle)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3020");
        return "";
    }

    private String getPolyline_3021Text(View view) {
        Polyline domainModelElement = (Polyline)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3021");
        return "";
    }

    private String getPolygon_3025Text(View view) {
        Polygon domainModelElement = (Polygon)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3025");
        return "";
    }

    private String getCanvas_1000Text(View view) {
        Canvas domainModelElement = (Canvas)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getName();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getChildAccess_4002Text(View view) {
        ChildAccess domainModelElement = (ChildAccess)view.getElement();
        if (domainModelElement != null) {
            return domainModelElement.getAccessor();
        }
        GMFGraphDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 4002");
        return "";
    }

    private String getCompartmentAccessor_4003Text(View view) {
        return "";
    }

    private String getDiagramLabelAccessor_4004Text(View view) {
        return "";
    }

    private String getNodeContentPane_4006Text(View view) {
        return "";
    }

    private String getDiagramElementFigure_4005Text(View view) {
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "GMFGraph".equals(GMFGraphVisualIDRegistry.getModelID(view));
    }
}

