/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.naming;

import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.gmf.internal.bridge.naming.NamingStrategy;
import org.eclipse.gmf.internal.common.NamesDispenser;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;

public abstract class AbstractNamingStrategy
implements NamingStrategy {
    private final String suffix;
    private final NamesDispenser namesDispenser;
    private final NamingStrategy chainedNamingStrategy;
    private final NamingStrategy prefixNamingStrategy;

    public AbstractNamingStrategy(String suffix, NamesDispenser namesDispenser, NamingStrategy chainedNamingStrategy, NamingStrategy prefixNamingStrategy) {
        this.suffix = suffix;
        this.namesDispenser = namesDispenser;
        this.chainedNamingStrategy = chainedNamingStrategy;
        this.prefixNamingStrategy = prefixNamingStrategy;
    }

    protected String createClassName(String s) {
        s = this.getValidClassName(s);
        if (this.namesDispenser == null) {
            return this.suffix == null ? s : String.valueOf(s) + this.suffix;
        }
        return this.namesDispenser.get(s, this.suffix);
    }

    protected String getValidClassName(String s) {
        assert (!this.isEmpty(s));
        s = CodeGenUtil.validJavaIdentifier((String)s);
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    protected boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    protected final NamingStrategy getChainedNamingStrategy() {
        return this.chainedNamingStrategy;
    }

    protected final NamingStrategy getPrefixNamingStrategy() {
        return this.prefixNamingStrategy;
    }

    public String get(CanvasMapping mapping) {
        if (this.chainedNamingStrategy != null) {
            return this.chainedNamingStrategy.get(mapping);
        }
        return null;
    }

    public String get(NodeMapping mapping) {
        if (this.chainedNamingStrategy != null) {
            return this.chainedNamingStrategy.get(mapping);
        }
        return null;
    }

    public String get(LinkMapping mapping) {
        if (this.chainedNamingStrategy != null) {
            return this.chainedNamingStrategy.get(mapping);
        }
        return null;
    }

    public String get(CompartmentMapping mapping) {
        if (this.chainedNamingStrategy != null) {
            return this.chainedNamingStrategy.get(mapping);
        }
        return null;
    }

    public String get(LabelMapping mapping) {
        if (this.chainedNamingStrategy != null) {
            return this.chainedNamingStrategy.get(mapping);
        }
        return null;
    }

    protected String getCompartmentHostPrefix(CompartmentMapping mapping) {
        return this.getPrefixNamingStrategy() != null ? this.getPrefixNamingStrategy().get(mapping.getParentNode()) : "Node";
    }

    protected String getLabelHostPrefix(LabelMapping mapping) {
        MappingEntry parentMapping = mapping.getMapEntry();
        if (parentMapping instanceof NodeMapping) {
            return this.getPrefixNamingStrategy() != null ? this.getPrefixNamingStrategy().get((NodeMapping)parentMapping) : "Node";
        }
        if (parentMapping instanceof LinkMapping) {
            return this.getPrefixNamingStrategy() != null ? this.getPrefixNamingStrategy().get((LinkMapping)parentMapping) : "Link";
        }
        throw new IllegalArgumentException(String.valueOf(mapping));
    }
}

